/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import java.util.function.Consumer;
import net.imglib2.AbstractLocalizableInt;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.util.IntervalIndexer;

class ArrayLocalizingSpliterator<T extends NativeType<T>>
extends AbstractLocalizableInt
implements LocalizableSpliterator<T> {
    private final ArrayImg<T, ?> img;
    private final T type;
    private final Index index;
    private final int fence;

    ArrayLocalizingSpliterator(ArrayImg<T, ?> img, int origin, int fence) {
        super(img.numDimensions());
        this.img = img;
        this.type = img.createLinkedType();
        this.index = this.type.index();
        this.fence = fence;
        this.type.updateContainer(this);
        this.index.set(origin - 1);
        IntervalIndexer.indexToPosition(origin, img.dim, this.position);
        this.position[0] = this.position[0] - 1;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index.get() < this.fence - 1) {
            this.fwd();
            action.accept(this.type);
            return true;
        }
        return false;
    }

    private void fwd() {
        this.index.inc();
        this.position[0] = this.position[0] + 1;
        if (this.position[0] > this.img.dim[0] - 1) {
            this.position[0] = 0;
            for (int d = 1; d < this.n; ++d) {
                int n = d;
                this.position[n] = this.position[n] + 1;
                if (this.position[n] <= this.img.dim[d] - 1) break;
                this.position[d] = 0;
            }
        }
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        int len = this.fence - this.index.get() - 1;
        while (len > 0) {
            int lenX = Math.min(len, this.img.dim[0] - 1 - this.position[0]);
            for (int x = 0; x < lenX; ++x) {
                this.position[0] = this.position[0] + 1;
                this.index.inc();
                action.accept(this.type);
            }
            if ((len -= lenX) <= 0) continue;
            this.nextLine();
        }
    }

    private void nextLine() {
        this.position[0] = -1;
        for (int d = 1; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + 1;
            if (this.position[n] <= this.img.dim[d] - 1) break;
            this.position[d] = 0;
        }
    }

    @Override
    public ArrayLocalizingSpliterator<T> trySplit() {
        int mid;
        int lo = this.index.get() + 1;
        if (lo >= (mid = lo + this.fence >>> 1)) {
            return null;
        }
        ArrayLocalizingSpliterator<T> prefix = new ArrayLocalizingSpliterator<T>(this.img, lo, mid);
        this.index.set(mid - 1);
        IntervalIndexer.indexToPosition(mid, this.img.dim, this.position);
        this.position[0] = this.position[0] - 1;
        return prefix;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index.get() - 1;
    }

    @Override
    public int characteristics() {
        return 17744;
    }

    @Override
    public ArrayLocalizingSpliterator<T> copy() {
        return new ArrayLocalizingSpliterator<T>(this.img, this.index.get() + 1, this.fence);
    }

    @Override
    public T get() {
        return this.type;
    }
}

