/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.AbstractImg;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class ArrayImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    public ArrayImgFactory(T type) {
        super(type);
    }

    @Override
    public ArrayImg<T, ?> create(long ... dimensions) {
        ArrayImg<NativeType, ?> img = this.create(dimensions, (NativeType)this.type(), ((NativeType)this.type()).getNativeTypeFactory());
        return img;
    }

    @Override
    public ArrayImg<T, ?> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions));
    }

    @Override
    public ArrayImg<T, ?> create(int[] dimensions) {
        return this.create(Util.int2long(dimensions));
    }

    private <A extends ArrayDataAccess<A>> ArrayImg<T, A> create(long[] dimensions, T type, NativeTypeFactory<T, A> typeFactory) {
        Dimensions.verify(dimensions);
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        int numEntities = ArrayImgFactory.numEntitiesRangeCheck(dimensions, entitiesPerPixel);
        ArrayDataAccess data = (ArrayDataAccess)ArrayDataAccessFactory.get(typeFactory).createArray(numEntities);
        ArrayImg<T, ArrayDataAccess> img = new ArrayImg<T, ArrayDataAccess>(data, dimensions, entitiesPerPixel);
        img.setLinkedType(typeFactory.createLinkedType(img));
        return img;
    }

    public static int numEntitiesRangeCheck(long[] dimensions, Fraction entitiesPerPixel) {
        long numEntities = entitiesPerPixel.mulCeil(AbstractImg.numElements(dimensions));
        if (numEntities > Integer.MAX_VALUE) {
            throw new RuntimeException("Number of elements in ArrayImg too big, use for example CellImg instead: " + numEntities + " > " + Integer.MAX_VALUE);
        }
        return (int)numEntities;
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (type instanceof NativeType) {
            return new ArrayImgFactory<NativeType>((NativeType)type);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    @Deprecated
    public ArrayImgFactory() {
    }

    @Override
    @Deprecated
    public ArrayImg<T, ?> create(long[] dim, T type) {
        this.cache(type);
        ArrayImg<T, ?> img = this.create(dim, type, type.getNativeTypeFactory());
        return img;
    }
}

