/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img;

import net.imglib2.Cursor;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealCursor;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.Type;
import net.imglib2.util.Util;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.Views;
import net.imglib2.view.iteration.SubIntervalIterable;

public class ImgView<T extends Type<T>>
extends IterableRandomAccessibleInterval<T>
implements Img<T>,
SubIntervalIterable<T> {
    private final ImgFactory<T> factory;
    private final IterableInterval<T> ii;

    @Deprecated
    public ImgView(RandomAccessibleInterval<T> in, ImgFactory<T> fac) {
        super(in);
        this.factory = fac;
        this.ii = Views.flatIterable(in);
    }

    @Override
    public ImgFactory<T> factory() {
        return this.factory;
    }

    @Override
    public Img<T> copy() {
        Img<T> copy = this.factory.create(this);
        RealCursor srcCursor = this.localizingCursor();
        RandomAccess resAccess = copy.randomAccess();
        while (srcCursor.hasNext()) {
            srcCursor.fwd();
            resAccess.setPosition((Localizable)((Object)srcCursor));
            ((Type)resAccess.get()).set((Type)srcCursor.get());
        }
        return copy;
    }

    @Override
    public Cursor<T> cursor() {
        return this.ii.cursor();
    }

    @Override
    public Cursor<T> localizingCursor() {
        return this.ii.localizingCursor();
    }

    @Override
    public boolean supportsOptimizedCursor(Interval interval) {
        if (this.sourceInterval instanceof SubIntervalIterable) {
            return ((SubIntervalIterable)((Object)this.sourceInterval)).supportsOptimizedCursor(interval);
        }
        return false;
    }

    @Override
    public Object subIntervalIterationOrder(Interval interval) {
        if (this.sourceInterval instanceof SubIntervalIterable) {
            return ((SubIntervalIterable)((Object)this.sourceInterval)).subIntervalIterationOrder(interval);
        }
        return new FlatIterationOrder(interval);
    }

    @Override
    public Cursor<T> cursor(Interval interval) {
        if (this.sourceInterval instanceof SubIntervalIterable) {
            return ((SubIntervalIterable)((Object)this.sourceInterval)).cursor(interval);
        }
        return Views.interval((RandomAccessible)((Object)this.sourceInterval), interval).cursor();
    }

    @Override
    public Cursor<T> localizingCursor(Interval interval) {
        if (this.sourceInterval instanceof SubIntervalIterable) {
            return ((SubIntervalIterable)((Object)this.sourceInterval)).localizingCursor(interval);
        }
        return Views.interval((RandomAccessible)((Object)this.sourceInterval), interval).localizingCursor();
    }

    public static <T extends Type<T>> Img<T> wrap(RandomAccessibleInterval<T> accessible) {
        if (accessible instanceof Img) {
            return (Img)accessible;
        }
        Type type = (Type)Util.getTypeFromInterval(accessible);
        ImgFactory<Type> factory = Util.getSuitableImgFactory(accessible, type);
        return ImgView.wrap(accessible, factory);
    }

    public static <T extends Type<T>> Img<T> wrap(RandomAccessibleInterval<T> accessible, ImgFactory<T> factory) {
        if (accessible instanceof Img) {
            return (Img)accessible;
        }
        return new ImgView<T>(accessible, factory);
    }
}

