/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.imglib2.IterableInterval;
import net.imglib2.IterableRealInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.converter.BiConverter;
import net.imglib2.converter.ColorChannelOrder;
import net.imglib2.converter.Converter;
import net.imglib2.converter.TypeIdentity;
import net.imglib2.converter.read.BiConvertedIterableInterval;
import net.imglib2.converter.read.BiConvertedIterableRealInterval;
import net.imglib2.converter.read.BiConvertedRandomAccessible;
import net.imglib2.converter.read.BiConvertedRandomAccessibleInterval;
import net.imglib2.converter.read.BiConvertedRealRandomAccessible;
import net.imglib2.converter.read.BiConvertedRealRandomAccessibleRealInterval;
import net.imglib2.converter.read.ConvertedIterableInterval;
import net.imglib2.converter.read.ConvertedIterableRealInterval;
import net.imglib2.converter.read.ConvertedRandomAccessible;
import net.imglib2.converter.read.ConvertedRandomAccessibleInterval;
import net.imglib2.converter.read.ConvertedRealRandomAccessible;
import net.imglib2.converter.read.ConvertedRealRandomAccessibleRealInterval;
import net.imglib2.converter.readwrite.ARGBChannelSamplerConverter;
import net.imglib2.converter.readwrite.CompositeARGBSamplerConverter;
import net.imglib2.converter.readwrite.SamplerConverter;
import net.imglib2.converter.readwrite.WriteConvertedIterableInterval;
import net.imglib2.converter.readwrite.WriteConvertedIterableRandomAccessibleInterval;
import net.imglib2.converter.readwrite.WriteConvertedIterableRealInterval;
import net.imglib2.converter.readwrite.WriteConvertedRandomAccessible;
import net.imglib2.converter.readwrite.WriteConvertedRandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.Composite;
import net.imglib2.view.composite.NumericComposite;
import net.imglib2.view.composite.RealComposite;

public class Converters {
    public static final <A, B extends Type<B>> RandomAccessible<B> convert(RandomAccessible<A> source, Converter<? super A, ? super B> converter, B b) {
        return Converters.convert2(source, converter, () -> b.copy());
    }

    public static final <A, B> RandomAccessible<B> convert2(RandomAccessible<A> source, Converter<? super A, ? super B> converter, Supplier<B> targetSupplier) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRandomAccessible<A, B>(source, converter, targetSupplier);
    }

    public static final <A, B extends Type<B>> RandomAccessible<B> convert(RandomAccessible<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, B b) {
        return Converters.convert2(source, converterSupplier, () -> b.copy());
    }

    public static final <A, B> RandomAccessible<B> convert2(RandomAccessible<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, Supplier<B> targetSupplier) {
        return new ConvertedRandomAccessible<A, B>(source, converterSupplier, targetSupplier);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessible<A, B> convert(RandomAccessible<A> source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedRandomAccessible<A, B>(source, converter);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessible<A, B> convert(RandomAccessible<A> source, Supplier<SamplerConverter<? super A, B>> converterSupplier) {
        return new WriteConvertedRandomAccessible<A, B>(source, converterSupplier);
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> convert(RandomAccessibleInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        return Converters.convert2(source, converter, () -> b.copy());
    }

    public static final <A, B> RandomAccessibleInterval<B> convert2(RandomAccessibleInterval<A> source, Converter<? super A, ? super B> converter, Supplier<B> targetSupplier) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRandomAccessibleInterval<A, B>(source, converter, targetSupplier);
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> convert(RandomAccessibleInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, B b) {
        return Converters.convert2(source, converterSupplier, () -> b.copy());
    }

    public static final <A, B> RandomAccessibleInterval<B> convert2(RandomAccessibleInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, Supplier<B> targetSupplier) {
        return new ConvertedRandomAccessibleInterval<A, B>(source, converterSupplier, targetSupplier);
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> convertRAI(RandomAccessibleInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        return Converters.convert(source, converter, b);
    }

    public static final <A, B> RandomAccessibleInterval<B> convertRAI2(RandomAccessibleInterval<A> source, Converter<? super A, ? super B> converter, Supplier<B> targetSupplier) {
        return Converters.convert2(source, converter, targetSupplier);
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> convertRAI(RandomAccessibleInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, B b) {
        return Converters.convert(source, converterSupplier, b);
    }

    public static final <A, B> RandomAccessibleInterval<B> convertRAI2(RandomAccessibleInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, Supplier<B> targetSupplier) {
        return Converters.convert2(source, converterSupplier, targetSupplier);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessibleInterval<A, B> convert(RandomAccessibleInterval<A> source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedRandomAccessibleInterval<A, B>(source, converter);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessibleInterval<A, B> convert(RandomAccessibleInterval<A> source, Supplier<SamplerConverter<? super A, B>> converterSupplier) {
        return new WriteConvertedRandomAccessibleInterval<A, B>(source, converterSupplier);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessibleInterval<A, B> convertRAI(RandomAccessibleInterval<A> source, SamplerConverter<? super A, B> converter) {
        return Converters.convert(source, converter);
    }

    public static final <A, B extends Type<B>> IterableRealInterval<B> convert(IterableRealInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        return Converters.convert2(source, converter, () -> b.copy());
    }

    public static final <A, B> IterableRealInterval<B> convert2(IterableRealInterval<A> source, Converter<? super A, ? super B> converter, Supplier<B> targetSupplier) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedIterableRealInterval<A, B>(source, converter, targetSupplier);
    }

    public static final <A, B extends Type<B>> IterableRealInterval<B> convert(IterableRealInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, B b) {
        return Converters.convert2(source, converterSupplier, () -> b.copy());
    }

    public static final <A, B> IterableRealInterval<B> convert2(IterableRealInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, Supplier<B> targetSupplier) {
        return new ConvertedIterableRealInterval<A, B>(source, converterSupplier, targetSupplier);
    }

    public static final <A, B extends Type<B>> WriteConvertedRandomAccessibleInterval<A, B> convertRAI(RandomAccessibleInterval<A> source, Supplier<SamplerConverter<? super A, B>> converterSupplier) {
        return Converters.convert(source, converterSupplier);
    }

    public static final <A, B extends Type<B>> IterableInterval<B> convert(IterableInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        return Converters.convert2(source, converter, () -> b.copy());
    }

    public static final <A, B> IterableInterval<B> convert2(IterableInterval<A> source, Converter<? super A, ? super B> converter, Supplier<B> targetSupplier) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedIterableInterval<A, B>(source, converter, targetSupplier);
    }

    public static final <A, B extends Type<B>> IterableInterval<B> convert(IterableInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, B b) {
        return Converters.convert2(source, converterSupplier, () -> b.copy());
    }

    public static final <A, B> IterableInterval<B> convert2(IterableInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, Supplier<B> targetSupplier) {
        return new ConvertedIterableInterval<A, B>(source, converterSupplier, targetSupplier);
    }

    public static final <A, B extends Type<B>> WriteConvertedIterableInterval<A, B> convert(IterableInterval<A> source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedIterableInterval<A, B>(source, converter);
    }

    public static final <A, B extends Type<B>> WriteConvertedIterableRealInterval<A, B> convert(IterableRealInterval<A> source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedIterableRealInterval<A, B>(source, converter);
    }

    public static final <A, B extends Type<B>> WriteConvertedIterableInterval<A, B> convert(IterableInterval<A> source, Supplier<SamplerConverter<? super A, B>> converterSupplier) {
        return new WriteConvertedIterableInterval<A, B>(source, converterSupplier);
    }

    public static final <A, B extends Type<B>, S extends RandomAccessible<A> & IterableInterval<A>> WriteConvertedIterableRandomAccessibleInterval<A, B, S> convertRandomAccessibleIterableInterval(S source, SamplerConverter<? super A, B> converter) {
        return new WriteConvertedIterableRandomAccessibleInterval<A, B, S>(source, converter);
    }

    public static final <A, B extends Type<B>, S extends RandomAccessible<A> & IterableInterval<A>> WriteConvertedIterableRandomAccessibleInterval<A, B, S> convertRandomAccessibleIterableInterval(S source, Supplier<SamplerConverter<? super A, B>> converterSupplier) {
        return new WriteConvertedIterableRandomAccessibleInterval<A, B, S>(source, converterSupplier);
    }

    public static final <A, B extends Type<B>> RealRandomAccessibleRealInterval<B> convert(RealRandomAccessibleRealInterval<A> source, Converter<? super A, ? super B> converter, B b) {
        return Converters.convert2(source, converter, () -> b.copy());
    }

    public static final <A, B> RealRandomAccessibleRealInterval<B> convert2(RealRandomAccessibleRealInterval<A> source, Converter<? super A, ? super B> converter, Supplier<B> targetSupplier) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRealRandomAccessibleRealInterval<A, B>(source, converter, targetSupplier);
    }

    public static final <A, B extends Type<B>> RealRandomAccessibleRealInterval<B> convert(RealRandomAccessibleRealInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, B b) {
        return Converters.convert2(source, converterSupplier, () -> b.copy());
    }

    public static final <A, B> RealRandomAccessibleRealInterval<B> convert2(RealRandomAccessibleRealInterval<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, Supplier<B> targetSupplier) {
        return new ConvertedRealRandomAccessibleRealInterval<A, B>(source, converterSupplier, targetSupplier);
    }

    public static final <A, B extends Type<B>> RealRandomAccessible<B> convert(RealRandomAccessible<A> source, Converter<? super A, ? super B> converter, B b) {
        return Converters.convert2(source, converter, () -> b.copy());
    }

    public static final <A, B> RealRandomAccessible<B> convert2(RealRandomAccessible<A> source, Converter<? super A, ? super B> converter, Supplier<B> targetSupplier) {
        if (TypeIdentity.class.isInstance(converter)) {
            return source;
        }
        return new ConvertedRealRandomAccessible<A, B>(source, converter, targetSupplier);
    }

    public static final <A, B extends Type<B>> RealRandomAccessible<B> convert(RealRandomAccessible<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, B b) {
        return Converters.convert2(source, converterSupplier, () -> b.copy());
    }

    public static final <A, B> RealRandomAccessible<B> convert2(RealRandomAccessible<A> source, Supplier<Converter<? super A, ? super B>> converterSupplier, Supplier<B> targetSupplier) {
        return new ConvertedRealRandomAccessible<A, B>(source, converterSupplier, targetSupplier);
    }

    public static final WriteConvertedRandomAccessibleInterval<ARGBType, UnsignedByteType> argbChannel(RandomAccessibleInterval<ARGBType> source, int channel) {
        return Converters.convert(source, new ARGBChannelSamplerConverter(channel));
    }

    public static final WriteConvertedRandomAccessible<ARGBType, UnsignedByteType> argbChannel(RandomAccessible<ARGBType> source, int channel) {
        return Converters.convert(source, new ARGBChannelSamplerConverter(channel));
    }

    public static final RandomAccessibleInterval<UnsignedByteType> argbChannels(RandomAccessibleInterval<ARGBType> source) {
        return Views.stack(Converters.argbChannel(source, 0), Converters.argbChannel(source, 1), Converters.argbChannel(source, 2), Converters.argbChannel(source, 3));
    }

    public static final RandomAccessibleInterval<UnsignedByteType> argbChannels(RandomAccessibleInterval<ARGBType> source, int ... channels) {
        ArrayList<WriteConvertedRandomAccessibleInterval<ARGBType, UnsignedByteType>> hyperSlices = new ArrayList<WriteConvertedRandomAccessibleInterval<ARGBType, UnsignedByteType>>();
        for (int channel : channels) {
            hyperSlices.add(Converters.argbChannel(source, channel));
        }
        return Views.stack(hyperSlices);
    }

    public static final RandomAccessible<ARGBType> mergeARGB(RandomAccessible<UnsignedByteType> source, ColorChannelOrder channelOrder) {
        return Converters.convert(Views.collapse(source), new CompositeARGBSamplerConverter(channelOrder));
    }

    public static final RandomAccessibleInterval<ARGBType> mergeARGB(RandomAccessibleInterval<UnsignedByteType> source, ColorChannelOrder channelOrder) {
        int channelAxis = source.numDimensions() - 1;
        if (source.min(channelAxis) > 0L || source.max(channelAxis) < (long)(channelOrder.channelCount() - 1)) {
            throw new IllegalArgumentException();
        }
        return Converters.convert(Views.collapse(source), new CompositeARGBSamplerConverter(channelOrder));
    }

    public static final <A extends RealType<A>, B extends Type<B>> RandomAccessibleInterval<B> composeReal(List<RandomAccessibleInterval<A>> components, Converter<RealComposite<A>, B> composer, B targetType) {
        return Converters.composeReal2(components, composer, () -> targetType.copy());
    }

    public static final <A extends RealType<A>, B> RandomAccessibleInterval<B> composeReal2(List<RandomAccessibleInterval<A>> components, Converter<RealComposite<A>, B> composer, Supplier<B> targetSupplier) {
        return Converters.convert2(Views.collapseReal(Views.stack(components)), composer, targetSupplier);
    }

    public static final <A extends NumericType<A>, B extends Type<B>> RandomAccessibleInterval<B> composeNumeric(List<RandomAccessibleInterval<A>> components, Converter<NumericComposite<A>, B> composer, B targetType) {
        return Converters.composeNumeric2(components, composer, () -> targetType.copy());
    }

    public static final <A extends NumericType<A>, B> RandomAccessibleInterval<B> composeNumeric2(List<RandomAccessibleInterval<A>> components, Converter<NumericComposite<A>, B> composer, Supplier<B> targetSupplier) {
        return Converters.convert2(Views.collapseNumeric(Views.stack(components)), composer, targetSupplier);
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> compose(List<RandomAccessibleInterval<A>> components, Converter<Composite<A>, B> composer, B targetType) {
        return Converters.compose2(components, composer, () -> targetType.copy());
    }

    public static final <A, B extends Type<B>> RandomAccessibleInterval<B> compose2(List<RandomAccessibleInterval<A>> components, Converter<Composite<A>, B> composer, Supplier<B> targetSupplier) {
        return Converters.convert2(Views.collapse(Views.stack(components)), composer, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RandomAccessible<C> convert(RandomAccessible<A> sourceA, RandomAccessible<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, C c) {
        return Converters.convert2(sourceA, sourceB, converter, () -> c.copy());
    }

    public static final <A, B, C> RandomAccessible<C> convert2(RandomAccessible<A> sourceA, RandomAccessible<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<C> targetSupplier) {
        return new BiConvertedRandomAccessible<A, B, C>(sourceA, sourceB, converter, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RandomAccessible<C> convert(RandomAccessible<A> sourceA, RandomAccessible<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, C c) {
        return Converters.convert2(sourceA, sourceB, converterSupplier, () -> c.copy());
    }

    public static final <A, B, C> RandomAccessible<C> convert2(RandomAccessible<A> sourceA, RandomAccessible<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<C> targetSupplier) {
        return new BiConvertedRandomAccessible<A, B, C>(sourceA, sourceB, converterSupplier, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RandomAccessibleInterval<C> convert(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, C c) {
        return Converters.convert2(sourceA, sourceB, converter, () -> c.copy());
    }

    public static final <A, B, C> RandomAccessibleInterval<C> convert2(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<C> targetSupplier) {
        return new BiConvertedRandomAccessibleInterval<A, B, C>(sourceA, sourceB, converter, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RandomAccessibleInterval<C> convert(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, C c) {
        return Converters.convert2(sourceA, sourceB, converterSupplier, () -> c.copy());
    }

    public static final <A, B, C> RandomAccessibleInterval<C> convert2(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<C> targetSupplier) {
        return new BiConvertedRandomAccessibleInterval<A, B, C>(sourceA, sourceB, converterSupplier, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RandomAccessibleInterval<C> convertRAI(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, C c) {
        return Converters.convert(sourceA, sourceB, converter, c);
    }

    public static final <A, B, C> RandomAccessibleInterval<C> convertRAI2(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<C> targetSupplier) {
        return Converters.convert2(sourceA, sourceB, converter, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RandomAccessibleInterval<C> convertRAI(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, C c) {
        return Converters.convert(sourceA, sourceB, converterSupplier, c);
    }

    public static final <A, B, C> RandomAccessibleInterval<C> convertRAI2(RandomAccessibleInterval<A> sourceA, RandomAccessibleInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<C> targetSupplier) {
        return Converters.convert2(sourceA, sourceB, converterSupplier, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> IterableInterval<C> convert(IterableInterval<A> sourceA, IterableInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, C c) {
        return Converters.convert2(sourceA, sourceB, converter, () -> c.copy());
    }

    public static final <A, B, C> IterableInterval<C> convert2(IterableInterval<A> sourceA, IterableInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<C> targetSupplier) {
        return new BiConvertedIterableInterval<A, B, C>(sourceA, sourceB, converter, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> IterableInterval<C> convert(IterableInterval<A> sourceA, IterableInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, C c) {
        return Converters.convert2(sourceA, sourceB, converterSupplier, () -> c.copy());
    }

    public static final <A, B, C> IterableInterval<C> convert2(IterableInterval<A> sourceA, IterableInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<C> targetSupplier) {
        return new BiConvertedIterableInterval<A, B, C>(sourceA, sourceB, converterSupplier, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> IterableRealInterval<C> convert(IterableRealInterval<A> sourceA, IterableRealInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, C c) {
        return Converters.convert2(sourceA, sourceB, converter, () -> c.copy());
    }

    public static final <A, B, C> IterableRealInterval<C> convert2(IterableRealInterval<A> sourceA, IterableRealInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<C> targetSupplier) {
        return new BiConvertedIterableRealInterval<A, B, C>(sourceA, sourceB, converter, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> IterableRealInterval<C> convert(IterableRealInterval<A> sourceA, IterableRealInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, C c) {
        return Converters.convert2(sourceA, sourceB, converterSupplier, () -> c.copy());
    }

    public static final <A, B, C> IterableRealInterval<C> convert2(IterableRealInterval<A> sourceA, IterableRealInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<C> targetSupplier) {
        return new BiConvertedIterableRealInterval<A, B, C>(sourceA, sourceB, converterSupplier, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RealRandomAccessibleRealInterval<C> convert(RealRandomAccessibleRealInterval<A> sourceA, RealRandomAccessibleRealInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, C c) {
        return Converters.convert2(sourceA, sourceB, converter, () -> c.copy());
    }

    public static final <A, B, C> RealRandomAccessibleRealInterval<C> convert2(RealRandomAccessibleRealInterval<A> sourceA, RealRandomAccessibleRealInterval<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<C> targetSupplier) {
        return new BiConvertedRealRandomAccessibleRealInterval<A, B, C>(sourceA, sourceB, converter, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RealRandomAccessibleRealInterval<C> convert(RealRandomAccessibleRealInterval<A> sourceA, RealRandomAccessibleRealInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, C c) {
        return Converters.convert2(sourceA, sourceB, converterSupplier, () -> c.copy());
    }

    public static final <A, B, C> RealRandomAccessibleRealInterval<C> convert2(RealRandomAccessibleRealInterval<A> sourceA, RealRandomAccessibleRealInterval<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<C> targetSupplier) {
        return new BiConvertedRealRandomAccessibleRealInterval<A, B, C>(sourceA, sourceB, converterSupplier, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RealRandomAccessible<C> convert(RealRandomAccessible<A> sourceA, RealRandomAccessible<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, C c) {
        return Converters.convert2(sourceA, sourceB, converter, () -> c.copy());
    }

    public static final <A, B, C> RealRandomAccessible<C> convert2(RealRandomAccessible<A> sourceA, RealRandomAccessible<B> sourceB, BiConverter<? super A, ? super B, ? super C> converter, Supplier<C> targetSupplier) {
        return new BiConvertedRealRandomAccessible<A, B, C>(sourceA, sourceB, converter, targetSupplier);
    }

    public static final <A, B, C extends Type<C>> RealRandomAccessible<C> convert(RealRandomAccessible<A> sourceA, RealRandomAccessible<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, C c) {
        return Converters.convert2(sourceA, sourceB, converterSupplier, () -> c.copy());
    }

    public static final <A, B, C> RealRandomAccessible<C> convert2(RealRandomAccessible<A> sourceA, RealRandomAccessible<B> sourceB, Supplier<BiConverter<? super A, ? super B, ? super C>> converterSupplier, Supplier<C> targetSupplier) {
        return new BiConvertedRealRandomAccessible<A, B, C>(sourceA, sourceB, converterSupplier, targetSupplier);
    }
}

