/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.function.Supplier;
import net.imglib2.blocks.Extension;
import net.imglib2.converter.Converter;
import net.imglib2.img.NativeImg;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.NativeType;
import net.imglib2.view.TransformBuilder;

class ViewProperties<T extends NativeType<T>, R extends NativeType<R>> {
    private final T viewType;
    private final NativeImg<R, ?> root;
    private final R rootType;
    private final Extension extension;
    private final MixedTransform transform;
    private final boolean hasTransform;
    private final MixedTransform permuteInvertTransform;
    private final boolean hasPermuteInvertTransform;
    private final Supplier<Converter<R, T>> converterSupplier;

    ViewProperties(T viewType, NativeImg<R, ?> root, R rootType, Extension extension, MixedTransform transform, MixedTransform permuteInvertTransform, Supplier<? extends Converter<?, ?>> converterSupplier) {
        this.viewType = viewType;
        this.root = root;
        this.rootType = rootType;
        this.extension = extension;
        this.transform = transform;
        this.hasTransform = !TransformBuilder.isIdentity(transform);
        this.permuteInvertTransform = permuteInvertTransform;
        this.hasPermuteInvertTransform = !TransformBuilder.isIdentity(permuteInvertTransform);
        this.converterSupplier = converterSupplier == null ? null : () -> (Converter)converterSupplier.get();
    }

    public String toString() {
        return "ViewProperties{viewType=" + this.viewType.getClass().getSimpleName() + ", root=" + this.root + ", rootType=" + this.rootType.getClass().getSimpleName() + ", extension=" + this.extension + ", transform=" + this.transform + ", hasPermuteInvertTransform=" + this.hasPermuteInvertTransform + ", permuteInvertTransform=" + this.permuteInvertTransform + ", converterSupplier=" + this.converterSupplier + '}';
    }

    public T getViewType() {
        return this.viewType;
    }

    public NativeImg<R, ?> getRoot() {
        return this.root;
    }

    public R getRootType() {
        return this.rootType;
    }

    public Extension getExtension() {
        return this.extension;
    }

    public boolean hasTransform() {
        return this.hasTransform;
    }

    public MixedTransform getTransform() {
        return this.transform;
    }

    public boolean hasPermuteInvertTransform() {
        return this.hasPermuteInvertTransform;
    }

    public MixedTransform getPermuteInvertTransform() {
        return this.permuteInvertTransform;
    }

    public boolean hasConverterSupplier() {
        return this.converterSupplier != null;
    }

    public Supplier<Converter<R, T>> getConverterSupplier() {
        return this.converterSupplier;
    }
}

