/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.blocks.Convert;
import net.imglib2.blocks.Extension;
import net.imglib2.blocks.MemCopy;
import net.imglib2.blocks.PermuteInvert;
import net.imglib2.blocks.PrimitiveBlocks;
import net.imglib2.blocks.PrimitiveBlocksUtils;
import net.imglib2.blocks.RangeCopier;
import net.imglib2.blocks.Ranges;
import net.imglib2.blocks.TempArray;
import net.imglib2.blocks.ViewProperties;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;

class ViewPrimitiveBlocks<T extends NativeType<T>, R extends NativeType<R>>
implements PrimitiveBlocks<T> {
    private final ViewProperties<T, R> props;
    private final RangeCopier copier;
    private final TempArray<R> tempArrayPermute;
    private final TempArray<R> tempArrayConvert;
    private final PermuteInvert permuteInvert;
    private final Convert convert;

    public ViewPrimitiveBlocks(ViewProperties<T, R> props) {
        this.props = props;
        PrimitiveType primitiveType = props.getRootType().getNativeTypeFactory().getPrimitiveType();
        MemCopy<?> memCopy = MemCopy.forPrimitiveType(primitiveType);
        Extension extension = props.getExtension() != null ? props.getExtension() : Extension.border();
        Object oob = PrimitiveBlocksUtils.extractOobValue(props.getRootType(), extension);
        Ranges findRanges = Ranges.forExtension(extension);
        this.copier = RangeCopier.create(props.getRoot(), findRanges, memCopy, oob);
        this.tempArrayConvert = (TempArray)Cast.unchecked(TempArray.forPrimitiveType(primitiveType));
        this.tempArrayPermute = (TempArray)Cast.unchecked(TempArray.forPrimitiveType(primitiveType));
        this.permuteInvert = new PermuteInvert(memCopy, props.getPermuteInvertTransform());
        this.convert = props.hasConverterSupplier() ? Convert.create(props.getRootType(), props.getViewType(), props.getConverterSupplier()) : null;
    }

    @Override
    public T getType() {
        return this.props.getViewType();
    }

    @Override
    public void copy(long[] srcPos, Object dest, int[] size) {
        int[] destSize;
        long[] destPos;
        if (this.props.hasTransform()) {
            MixedTransform transform = this.props.getTransform();
            int n = transform.numTargetDimensions();
            destPos = new long[n];
            destSize = new int[n];
            for (int d = 0; d < n; ++d) {
                int t = (int)transform.getTranslation(d);
                if (transform.getComponentZero(d)) {
                    destPos[d] = t;
                    destSize[d] = 1;
                    continue;
                }
                int c = transform.getComponentMapping(d);
                destPos[d] = transform.getComponentInversion(d) ? (long)t - srcPos[c] - (long)size[c] + 1L : (long)t + srcPos[c];
                destSize[d] = size[c];
            }
        } else {
            destPos = srcPos;
            destSize = size;
        }
        boolean doPermute = this.props.hasPermuteInvertTransform();
        boolean doConvert = this.props.hasConverterSupplier();
        int length = (int)Intervals.numElements(size);
        if (doPermute && doConvert) {
            R copyDest = this.tempArrayPermute.get(length);
            R permuteDest = this.tempArrayConvert.get(length);
            this.copier.copy(destPos, copyDest, destSize);
            this.permuteInvert.permuteAndInvert(copyDest, permuteDest, size);
            this.convert.convert(permuteDest, dest, length);
        } else if (doPermute) {
            R copyDest = this.tempArrayConvert.get(length);
            this.copier.copy(destPos, copyDest, destSize);
            this.permuteInvert.permuteAndInvert(copyDest, dest, size);
        } else if (doConvert) {
            R copyDest = this.tempArrayPermute.get(length);
            this.copier.copy(destPos, copyDest, destSize);
            this.convert.convert(copyDest, dest, length);
        } else {
            this.copier.copy(destPos, dest, destSize);
        }
    }

    @Override
    public PrimitiveBlocks<T> threadSafe() {
        return PrimitiveBlocksUtils.threadSafe(this::newInstance);
    }

    ViewPrimitiveBlocks<T, R> newInstance() {
        return new ViewPrimitiveBlocks<T, R>(this);
    }

    private ViewPrimitiveBlocks(ViewPrimitiveBlocks<T, R> blocks) {
        this.props = blocks.props;
        this.copier = blocks.copier.newInstance();
        this.permuteInvert = blocks.permuteInvert.newInstance();
        this.convert = blocks.convert == null ? null : blocks.convert.newInstance();
        this.tempArrayConvert = blocks.tempArrayConvert.newInstance();
        this.tempArrayPermute = blocks.tempArrayPermute.newInstance();
    }
}

