/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.EnumMap;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.BooleanArray;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.type.PrimitiveType;

class PrimitiveTypeProperties<P, A extends ArrayDataAccess<A>> {
    final Class<P> primitiveArrayClass;
    final IntFunction<P> createPrimitiveArray;
    final ToIntFunction<P> primitiveArrayLength;
    final Function<P, A> wrapAsAccess;
    private static final EnumMap<PrimitiveType, PrimitiveTypeProperties<?, ?>> creators = new EnumMap(PrimitiveType.class);

    static PrimitiveTypeProperties<?, ?> get(PrimitiveType primitiveType) {
        PrimitiveTypeProperties<?, ?> props = creators.get((Object)primitiveType);
        if (props == null) {
            throw new IllegalArgumentException();
        }
        return props;
    }

    A wrap(Object data) {
        if (data == null) {
            throw new NullPointerException();
        }
        if (!this.primitiveArrayClass.isInstance(data)) {
            throw new IllegalArgumentException("expected " + this.primitiveArrayClass.getSimpleName() + " argument");
        }
        return (A)((ArrayDataAccess)this.wrapAsAccess.apply(data));
    }

    P allocate(int length) {
        return this.createPrimitiveArray.apply(length);
    }

    int length(P array) {
        return this.primitiveArrayLength.applyAsInt(array);
    }

    private PrimitiveTypeProperties(Class<P> primitiveArrayClass, IntFunction<P> createPrimitiveArray, ToIntFunction<P> primitiveArrayLength, Function<P, A> wrapAsAccess) {
        this.primitiveArrayClass = primitiveArrayClass;
        this.createPrimitiveArray = createPrimitiveArray;
        this.primitiveArrayLength = primitiveArrayLength;
        this.wrapAsAccess = wrapAsAccess;
    }

    static {
        creators.put(PrimitiveType.BOOLEAN, new PrimitiveTypeProperties<boolean[], BooleanArray>(boolean[].class, boolean[]::new, a -> ((boolean[])a).length, BooleanArray::new));
        creators.put(PrimitiveType.BYTE, new PrimitiveTypeProperties<byte[], ByteArray>(byte[].class, byte[]::new, a -> ((byte[])a).length, ByteArray::new));
        creators.put(PrimitiveType.CHAR, new PrimitiveTypeProperties<char[], CharArray>(char[].class, char[]::new, a -> ((char[])a).length, CharArray::new));
        creators.put(PrimitiveType.SHORT, new PrimitiveTypeProperties<short[], ShortArray>(short[].class, short[]::new, a -> ((short[])a).length, ShortArray::new));
        creators.put(PrimitiveType.INT, new PrimitiveTypeProperties<int[], IntArray>(int[].class, int[]::new, a -> ((int[])a).length, IntArray::new));
        creators.put(PrimitiveType.LONG, new PrimitiveTypeProperties<long[], LongArray>(long[].class, long[]::new, a -> ((long[])a).length, LongArray::new));
        creators.put(PrimitiveType.FLOAT, new PrimitiveTypeProperties<float[], FloatArray>(float[].class, float[]::new, a -> ((float[])a).length, FloatArray::new));
        creators.put(PrimitiveType.DOUBLE, new PrimitiveTypeProperties<double[], DoubleArray>(double[].class, double[]::new, a -> ((double[])a).length, DoubleArray::new));
    }
}

