/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.RandomAccessible;
import net.imglib2.blocks.FallbackPrimitiveBlocks;
import net.imglib2.blocks.ViewAnalyzer;
import net.imglib2.blocks.ViewPrimitiveBlocks;
import net.imglib2.blocks.ViewPropertiesOrError;
import net.imglib2.type.NativeType;
import net.imglib2.util.Util;

public interface PrimitiveBlocks<T extends NativeType<T>> {
    public T getType();

    public void copy(long[] var1, Object var2, int[] var3);

    default public void copy(int[] srcPos, Object dest, int[] size) {
        this.copy(Util.int2long(srcPos), dest, size);
    }

    public PrimitiveBlocks<T> threadSafe();

    public static <T extends NativeType<T>> PrimitiveBlocks<T> of(RandomAccessible<T> ra) {
        return PrimitiveBlocks.of(ra, OnFallback.WARN);
    }

    public static <T extends NativeType<T>, R extends NativeType<R>> PrimitiveBlocks<T> of(RandomAccessible<T> ra, OnFallback onFallback) {
        ViewPropertiesOrError props = ViewAnalyzer.getViewProperties(ra);
        if (props.isFullySupported()) {
            return new ViewPrimitiveBlocks(props.getViewProperties());
        }
        if (props.isSupported() && onFallback != OnFallback.FAIL) {
            if (onFallback == OnFallback.WARN) {
                System.err.println(props.getErrorMessage());
            }
            return new FallbackPrimitiveBlocks(props.getFallbackProperties());
        }
        throw new IllegalArgumentException(props.getErrorMessage());
    }

    public static enum OnFallback {
        ACCEPT,
        WARN,
        FAIL;

    }
}

