/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.Arrays;
import net.imglib2.type.PrimitiveType;

interface MemCopy<T> {
    public static final MemCopyBoolean BOOLEAN = new MemCopyBoolean();
    public static final MemCopyByte BYTE = new MemCopyByte();
    public static final MemCopyChar CHAR = new MemCopyChar();
    public static final MemCopyShort SHORT = new MemCopyShort();
    public static final MemCopyInt INT = new MemCopyInt();
    public static final MemCopyLong LONG = new MemCopyLong();
    public static final MemCopyFloat FLOAT = new MemCopyFloat();
    public static final MemCopyDouble DOUBLE = new MemCopyDouble();

    public void copyForward(T var1, int var2, T var3, int var4, int var5);

    public void copyReverse(T var1, int var2, T var3, int var4, int var5);

    public void copyValue(T var1, int var2, T var3, int var4, int var5);

    public void copyStrided(T var1, int var2, T var3, int var4, int var5, int var6);

    default public void copyLines(int lineDir, int lineLength, int numLines, T src, int srcPos, int srcStep, T dest, int destPos, int destStep) {
        if (lineDir == 1) {
            for (int i = 0; i < numLines; ++i) {
                this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
            }
        } else if (lineDir == -1) {
            for (int i = 0; i < numLines; ++i) {
                this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
            }
        } else {
            for (int i = 0; i < numLines; ++i) {
                this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
            }
        }
    }

    public static MemCopy<?> forPrimitiveType(PrimitiveType primitiveType) {
        switch (primitiveType) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTE: {
                return BYTE;
            }
            case CHAR: {
                return CHAR;
            }
            case SHORT: {
                return SHORT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class MemCopyDouble
    implements MemCopy<double[]> {
        @Override
        public void copyForward(double[] src, int srcPos, double[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(double[] src, int srcPos, double[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(double[] src, int srcPos, double[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(double[] src, int srcPos, double[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, double[] src, int srcPos, int srcStep, double[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }

    public static class MemCopyFloat
    implements MemCopy<float[]> {
        @Override
        public void copyForward(float[] src, int srcPos, float[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(float[] src, int srcPos, float[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(float[] src, int srcPos, float[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(float[] src, int srcPos, float[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, float[] src, int srcPos, int srcStep, float[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }

    public static class MemCopyLong
    implements MemCopy<long[]> {
        @Override
        public void copyForward(long[] src, int srcPos, long[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(long[] src, int srcPos, long[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(long[] src, int srcPos, long[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(long[] src, int srcPos, long[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, long[] src, int srcPos, int srcStep, long[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }

    public static class MemCopyInt
    implements MemCopy<int[]> {
        @Override
        public void copyForward(int[] src, int srcPos, int[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(int[] src, int srcPos, int[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(int[] src, int srcPos, int[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(int[] src, int srcPos, int[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, int[] src, int srcPos, int srcStep, int[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }

    public static class MemCopyChar
    implements MemCopy<char[]> {
        @Override
        public void copyForward(char[] src, int srcPos, char[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(char[] src, int srcPos, char[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(char[] src, int srcPos, char[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(char[] src, int srcPos, char[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, char[] src, int srcPos, int srcStep, char[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }

    public static class MemCopyShort
    implements MemCopy<short[]> {
        @Override
        public void copyForward(short[] src, int srcPos, short[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(short[] src, int srcPos, short[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(short[] src, int srcPos, short[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(short[] src, int srcPos, short[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, short[] src, int srcPos, int srcStep, short[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }

    public static class MemCopyByte
    implements MemCopy<byte[]> {
        @Override
        public void copyForward(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(byte[] src, int srcPos, byte[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, byte[] src, int srcPos, int srcStep, byte[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }

    public static class MemCopyBoolean
    implements MemCopy<boolean[]> {
        @Override
        public void copyForward(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
            System.arraycopy(src, srcPos, dest, destPos, length);
        }

        @Override
        public void copyReverse(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
            for (int i = 0; i < length; ++i) {
                dest[destPos + i] = src[srcPos - i];
            }
        }

        @Override
        public void copyValue(boolean[] src, int srcPos, boolean[] dest, int destPos, int length) {
            Arrays.fill(dest, destPos, destPos + length, src[srcPos]);
        }

        @Override
        public void copyStrided(boolean[] src, int srcPos, boolean[] dest, int destPos, int destStride, int length) {
            if (destStride == 1) {
                this.copyForward(src, srcPos, dest, destPos, length);
            } else {
                for (int i = 0; i < length; ++i) {
                    dest[destPos + i * destStride] = src[srcPos + i];
                }
            }
        }

        @Override
        public void copyLines(int lineDir, int lineLength, int numLines, boolean[] src, int srcPos, int srcStep, boolean[] dest, int destPos, int destStep) {
            if (lineDir == 1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyForward(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else if (lineDir == -1) {
                for (int i = 0; i < numLines; ++i) {
                    this.copyReverse(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            } else {
                for (int i = 0; i < numLines; ++i) {
                    this.copyValue(src, srcPos + i * srcStep, dest, destPos + i * destStep, lineLength);
                }
            }
        }
    }
}

