/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.FinalInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.blocks.FallbackProperties;
import net.imglib2.blocks.PrimitiveBlocks;
import net.imglib2.blocks.PrimitiveTypeProperties;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

class FallbackPrimitiveBlocks<T extends NativeType<T>, A extends ArrayDataAccess<A>>
implements PrimitiveBlocks<T> {
    private final RandomAccessible<T> source;
    private final T type;
    private final PrimitiveTypeProperties<?, A> primitiveTypeProperties;
    private final NativeTypeFactory<T, A> nativeTypeFactory;

    public FallbackPrimitiveBlocks(FallbackProperties<T> props) {
        this(props.getView(), props.getViewType());
    }

    public FallbackPrimitiveBlocks(RandomAccessible<T> source, T type) {
        this.source = source;
        this.type = type;
        if (type.getEntitiesPerPixel().getRatio() != 1.0) {
            throw new IllegalArgumentException("Types with entitiesPerPixel != 1 are not supported");
        }
        this.nativeTypeFactory = type.getNativeTypeFactory();
        this.primitiveTypeProperties = PrimitiveTypeProperties.get(this.nativeTypeFactory.getPrimitiveType());
    }

    @Override
    public T getType() {
        return this.type;
    }

    @Override
    public void copy(long[] srcPos, Object dest, int[] size) {
        ArrayImg<T, A> img = new ArrayImg<T, A>(this.primitiveTypeProperties.wrap(dest), Util.int2long(size), this.type.getEntitiesPerPixel());
        img.setLinkedType(this.nativeTypeFactory.createLinkedType(img));
        FinalInterval interval = FinalInterval.createMinSize(srcPos, Util.int2long(size));
        LoopBuilder.setImages(Views.interval(this.source, interval), img).forEachPixel((a, b) -> b.set(a));
    }

    @Override
    public PrimitiveBlocks<T> threadSafe() {
        return this;
    }
}

