/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import net.imglib2.blocks.ExtensionImpl;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;

interface Extension {
    public Type type();

    public static Extension border() {
        return ExtensionImpl.border;
    }

    public static Extension mirrorSingle() {
        return ExtensionImpl.mirrorSingle;
    }

    public static Extension mirrorDouble() {
        return ExtensionImpl.mirrorDouble;
    }

    public static <T> Extension constant(T oobValue) {
        return new ExtensionImpl.ConstantExtension<T>(oobValue);
    }

    public static Extension of(OutOfBoundsFactory<?, ?> oobFactory) {
        if (oobFactory instanceof OutOfBoundsBorderFactory) {
            return Extension.border();
        }
        if (oobFactory instanceof OutOfBoundsMirrorFactory) {
            OutOfBoundsMirrorFactory.Boundary boundary = ((OutOfBoundsMirrorFactory)oobFactory).getBoundary();
            return boundary == OutOfBoundsMirrorFactory.Boundary.SINGLE ? Extension.mirrorSingle() : Extension.mirrorDouble();
        }
        if (oobFactory instanceof OutOfBoundsConstantValueFactory) {
            return Extension.constant(((OutOfBoundsConstantValueFactory)oobFactory).getValue());
        }
        return new ExtensionImpl.UnknownExtension(oobFactory);
    }

    public static enum Type {
        CONSTANT(true),
        BORDER(false),
        MIRROR_SINGLE(false),
        MIRROR_DOUBLE(false),
        UNKNOWN(true);

        private final boolean isValueDependent;

        private Type(boolean isValueDependent) {
            this.isValueDependent = isValueDependent;
        }

        public boolean isValueDependent() {
            return this.isValueDependent;
        }
    }
}

