/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.blocks;

import java.util.Iterator;
import java.util.List;
import net.imglib2.blocks.MemCopy;
import net.imglib2.blocks.RangeCopier;
import net.imglib2.blocks.Ranges;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;

class ArrayImgRangeCopier<T>
implements RangeCopier<T> {
    private final int n;
    private final int[] srcDims;
    private final Ranges findRanges;
    private final MemCopy<T> memCopy;
    private final T oob;
    private final List<Ranges.Range>[] rangesPerDimension;
    private final Ranges.Range[] ranges;
    private final int[] dsteps;
    private final int[] doffsets;
    private final int[] csteps;
    private final int[] lengths;
    private final T src;

    public ArrayImgRangeCopier(ArrayImg<?, ?> arrayImg, Ranges findRanges, MemCopy<T> memCopy, T oob) {
        this.n = arrayImg.numDimensions();
        this.srcDims = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.srcDims[d] = (int)arrayImg.dimension(d);
        }
        this.findRanges = findRanges;
        this.memCopy = memCopy;
        this.oob = oob;
        this.rangesPerDimension = new List[this.n];
        this.ranges = new Ranges.Range[this.n];
        this.dsteps = new int[this.n];
        this.doffsets = new int[this.n + 1];
        this.csteps = new int[this.n];
        this.lengths = new int[this.n];
        this.src = ((ArrayDataAccess)arrayImg.update(null)).getCurrentStorageArray();
    }

    private ArrayImgRangeCopier(ArrayImgRangeCopier<T> copier) {
        this.n = copier.n;
        this.srcDims = (int[])copier.srcDims.clone();
        this.findRanges = copier.findRanges;
        this.memCopy = copier.memCopy;
        this.oob = copier.oob;
        this.src = copier.src;
        this.rangesPerDimension = new List[this.n];
        this.ranges = new Ranges.Range[this.n];
        this.dsteps = new int[this.n];
        this.doffsets = new int[this.n + 1];
        this.csteps = new int[this.n];
        this.lengths = new int[this.n];
    }

    @Override
    public ArrayImgRangeCopier<T> newInstance() {
        return new ArrayImgRangeCopier<T>(this);
    }

    @Override
    public void copy(long[] srcPos, T dest, int[] size) {
        for (int d = 0; d < this.n; ++d) {
            this.rangesPerDimension[d] = this.findRanges.findRanges(srcPos[d], size[d], this.srcDims[d], this.srcDims[d]);
        }
        this.setupDestSize(size);
        this.copy(dest, this.n - 1);
    }

    private void copy(T dest, int d) {
        Iterator<Ranges.Range> iterator = this.rangesPerDimension[d].iterator();
        while (iterator.hasNext()) {
            Ranges.Range range;
            this.ranges[d] = range = iterator.next();
            this.updateRange(d);
            if (range.dir == Ranges.Direction.CONSTANT) {
                this.fillRanges(dest, d);
                continue;
            }
            if (d > 0) {
                this.copy(dest, d - 1);
                continue;
            }
            this.copyRanges(dest);
        }
    }

    private void setupDestSize(int[] size) {
        this.dsteps[0] = 1;
        for (int d = 0; d < this.n - 1; ++d) {
            this.dsteps[d + 1] = this.dsteps[d] * size[d];
        }
    }

    private void updateRange(int d) {
        Ranges.Range r = this.ranges[d];
        this.lengths[d] = r.w;
        this.doffsets[d] = this.doffsets[d + 1] + this.dsteps[d] * r.x;
    }

    private void copyRanges(T dest) {
        this.csteps[0] = 1;
        for (int d = 0; d < this.n - 1; ++d) {
            this.csteps[d + 1] = this.csteps[d] * this.srcDims[d];
        }
        int sOffset = 0;
        block5: for (int d = 0; d < this.n; ++d) {
            Ranges.Range r = this.ranges[d];
            sOffset += this.csteps[d] * r.cellx;
            switch (r.dir) {
                case BACKWARD: {
                    this.csteps[d] = -this.csteps[d];
                    continue block5;
                }
                case STAY: {
                    this.csteps[d] = 0;
                }
            }
        }
        int dOffset = this.doffsets[0];
        if (this.n > 1) {
            this.copyRangesRecursively(this.src, sOffset, dest, dOffset, this.n - 1);
        } else {
            int l0 = this.lengths[0];
            int cstep0 = this.csteps[0];
            this.memCopy.copyLines(cstep0, l0, 1, this.src, sOffset, 0, dest, dOffset, 0);
        }
    }

    private void copyRangesRecursively(T src, int srcPos, T dest, int destPos, int d) {
        int length = this.lengths[d];
        int cstep = this.csteps[d];
        int dstep = this.dsteps[d];
        if (d > 1) {
            for (int i = 0; i < length; ++i) {
                this.copyRangesRecursively(src, srcPos + i * cstep, dest, destPos + i * dstep, d - 1);
            }
        } else {
            int l0 = this.lengths[0];
            int cstep0 = this.csteps[0];
            this.memCopy.copyLines(cstep0, l0, length, src, srcPos, cstep, dest, destPos, dstep);
        }
    }

    void fillRanges(T dest, int dConst) {
        int dOffset = this.doffsets[dConst];
        int n = dConst;
        this.lengths[n] = this.lengths[n] * this.dsteps[dConst];
        if (this.n - 1 > dConst) {
            this.fillRangesRecursively(dest, dOffset, this.n - 1, dConst);
        } else {
            this.memCopy.copyValue(this.oob, 0, dest, dOffset, this.lengths[dConst]);
        }
    }

    private void fillRangesRecursively(T dest, int destPos, int d, int dConst) {
        int length = this.lengths[d];
        int dstep = this.dsteps[d];
        if (d > dConst + 1) {
            for (int i = 0; i < length; ++i) {
                this.fillRangesRecursively(dest, destPos + i * dstep, d - 1, dConst);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                this.memCopy.copyValue(this.oob, 0, dest, destPos + i * dstep, this.lengths[dConst]);
            }
        }
    }
}

