/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.ArrayList;
import net.imglib2.IterableRealInterval;
import net.imglib2.RealCursor;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;

public class RealPointSampleList<T>
implements IterableRealInterval<T> {
    protected final int n;
    protected final ArrayList<RealPoint> coordinates = new ArrayList();
    protected final ArrayList<T> samples = new ArrayList();
    protected int lastIndex = -1;
    protected final double[] min;
    protected final double[] max;

    public RealPointSampleList(int n) {
        this.n = n;
        this.min = new double[n];
        this.max = new double[n];
        for (int d = 0; d < n; ++d) {
            this.min[d] = Double.MAX_VALUE;
            this.max[d] = -1.7976931348623157E308;
        }
    }

    public void add(RealPoint position, T sample) {
        this.coordinates.add(position);
        this.samples.add(sample);
        this.lastIndex = this.samples.size() - 1;
        for (int d = 0; d < this.n; ++d) {
            double x = position.getDoublePosition(d);
            if (x < this.min[d]) {
                this.min[d] = x;
            }
            if (!(x > this.max[d])) continue;
            this.max[d] = x;
        }
    }

    @Override
    public RealCursor<T> cursor() {
        return new RealPointSampleListCursor();
    }

    @Override
    public Object iterationOrder() {
        return this;
    }

    @Override
    public T firstElement() {
        return this.samples.get(0);
    }

    @Override
    public RealCursor<T> localizingCursor() {
        return new RealPointSampleListCursor();
    }

    @Override
    public long size() {
        return this.samples.size();
    }

    @Override
    public double realMax(int d) {
        return this.max[d];
    }

    @Override
    public void realMax(double[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = this.max[d];
        }
    }

    @Override
    public void realMax(RealPositionable m) {
        m.setPosition(this.max);
    }

    @Override
    public double realMin(int d) {
        return this.min[d];
    }

    @Override
    public void realMin(double[] m) {
        for (int d = 0; d < this.n; ++d) {
            m[d] = this.min[d];
        }
    }

    @Override
    public void realMin(RealPositionable m) {
        m.setPosition(this.min);
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    public class RealPointSampleListCursor
    implements RealCursor<T> {
        protected int index = -1;
        protected RealPoint position = null;
        protected T sample = null;

        @Override
        public RealCursor<T> copy() {
            RealPointSampleListCursor copy = new RealPointSampleListCursor();
            copy.index = this.index;
            copy.position = this.position;
            copy.sample = this.sample;
            return copy;
        }

        @Override
        public double getDoublePosition(int d) {
            return this.position.getDoublePosition(d);
        }

        @Override
        public float getFloatPosition(int d) {
            return this.position.getFloatPosition(d);
        }

        @Override
        public void localize(float[] pos) {
            this.position.localize(pos);
        }

        @Override
        public void localize(double[] pos) {
            this.position.localize(pos);
        }

        @Override
        public int numDimensions() {
            return RealPointSampleList.this.n;
        }

        @Override
        public T get() {
            return this.sample;
        }

        @Override
        public void fwd() {
            ++this.index;
            this.position = RealPointSampleList.this.coordinates.get(this.index);
            this.sample = RealPointSampleList.this.samples.get(this.index);
        }

        @Override
        public boolean hasNext() {
            return this.index < RealPointSampleList.this.lastIndex;
        }

        @Override
        public void jumpFwd(long steps) {
            if (steps == 0L) {
                return;
            }
            this.index = (int)((long)this.index + steps);
            this.position = RealPointSampleList.this.coordinates.get(this.index);
            this.sample = RealPointSampleList.this.samples.get(this.index);
        }

        @Override
        public void reset() {
            this.index = -1;
            this.position = null;
            this.sample = null;
        }

        @Override
        public T next() {
            this.fwd();
            return this.sample;
        }
    }
}

