/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Arrays;
import java.util.function.Supplier;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.util.Localizables;

public class PointSample<T>
extends AbstractLocalizable
implements RandomAccess<T> {
    protected final Supplier<T> sampleSupplier;

    protected PointSample(Supplier<T> sampleSupplier, long[] position, boolean copy) {
        super(copy ? (long[])position.clone() : position);
        this.sampleSupplier = sampleSupplier;
    }

    public PointSample(Supplier<T> sampleSupplier, int n) {
        super(n);
        this.sampleSupplier = sampleSupplier;
    }

    public PointSample(Supplier<T> sampleSupplier, long ... position) {
        this(sampleSupplier, position, true);
    }

    public PointSample(Supplier<T> sampleSupplier, int ... position) {
        this(sampleSupplier, position.length);
        this.setPosition(position);
    }

    public PointSample(Supplier<T> sampleSupplier, Localizable localizable) {
        this(sampleSupplier, localizable.numDimensions());
        localizable.localize(this.position);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getLongPosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getLongPosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.position[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.position[d] = position;
    }

    public String toString() {
        return Localizables.toString(this) + " -> " + this.get().toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            PointSample other = (PointSample)obj;
            return Localizables.equals(this, other) && this.get().equals(other.get());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.position) ^ this.get().hashCode();
    }

    public static <T> PointSample<T> wrap(T sample, long[] position) {
        return new PointSample<Object>(() -> sample, position, false);
    }

    public static <T> PointSample<T> wrapSupplier(Supplier<T> sampleSupplier, long[] position) {
        return new PointSample<T>(sampleSupplier, position, false);
    }

    @Override
    public T get() {
        return this.sampleSupplier.get();
    }

    @Override
    public PointSample<T> copy() {
        return new PointSample<T>(this.sampleSupplier, this.position, true);
    }
}

