/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import java.util.Arrays;
import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.util.Localizables;

public class Point
extends AbstractLocalizable
implements Positionable {
    protected Point(long[] position, boolean copy) {
        super(copy ? (long[])position.clone() : position);
    }

    public Point(int n) {
        super(n);
    }

    public Point(long ... position) {
        this(position, true);
    }

    public Point(int ... position) {
        super(position.length);
        this.setPosition(position);
    }

    public Point(Localizable localizable) {
        super(localizable.numDimensions());
        localizable.localize(this.position);
    }

    @Override
    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
    }

    @Override
    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
    }

    @Override
    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
    }

    @Override
    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getLongPosition(d);
        }
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
        }
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    @Override
    public void setPosition(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getLongPosition(d);
        }
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
    }

    @Override
    public void setPosition(int position, int d) {
        this.position[d] = position;
    }

    @Override
    public void setPosition(long position, int d) {
        this.position[d] = position;
    }

    public String toString() {
        return Localizables.toString(this);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && Localizables.equals(this, (Point)obj);
    }

    public int hashCode() {
        return Arrays.hashCode(this.position);
    }

    public static Point wrap(long[] position) {
        return new Point(position, false);
    }
}

