/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;

public interface Localizable
extends RealLocalizable {
    default public void localize(int[] position) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            position[d] = this.getIntPosition(d);
        }
    }

    default public void localize(long[] position) {
        int n = this.numDimensions();
        for (int d = 0; d < n; ++d) {
            position[d] = this.getLongPosition(d);
        }
    }

    default public void localize(Positionable position) {
        if (position.numDimensions() == this.numDimensions()) {
            position.setPosition(this);
        } else {
            int n = this.numDimensions();
            for (int d = 0; d < n; ++d) {
                position.setPosition(this.getLongPosition(d), d);
            }
        }
    }

    @Override
    default public void localize(RealPositionable position) {
        this.localize((Positionable)position);
    }

    default public int getIntPosition(int d) {
        return (int)this.getLongPosition(d);
    }

    default public long[] positionAsLongArray() {
        long[] out = new long[this.numDimensions()];
        this.localize(out);
        return out;
    }

    default public Point positionAsPoint() {
        return new Point(this);
    }

    public long getLongPosition(int var1);

    @Override
    default public float getFloatPosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    default public double getDoublePosition(int d) {
        return this.getLongPosition(d);
    }
}

