/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Collection;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.type.Type;
import net.imglib2.type.label.AbstractLabelMultisetLoader;
import net.imglib2.type.label.ByteUtils;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LabelMultisetToUnsignedLongConverter;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static byte[] serializeLabelMultisetTypes(Iterable<LabelMultisetType> lmts, int numElements) {
        int[] listEntryOffsets = new int[numElements];
        LongMappedAccessData listData = LongMappedAccessData.factory.createStorage(32L);
        LabelMultisetEntryList list = new LabelMultisetEntryList(listData, 0L);
        LabelMultisetEntryList list2 = new LabelMultisetEntryList();
        TIntObjectHashMap offsetsForHashes = new TIntObjectHashMap();
        LabelMultisetEntry iteratorEntry = new LabelMultisetEntry(0L, 1);
        LabelMultisetEntry addEntry = new LabelMultisetEntry(0L, 1);
        LabelMultisetEntry tmpAddEntry = new LabelMultisetEntry(0L, 1);
        int nextListOffset = 0;
        int o = 0;
        for (LabelMultisetType lmt : lmts) {
            boolean insertNeeded;
            list.createListAt(listData, nextListOffset);
            for (LabelMultisetEntry entry : lmt.entrySetWithRef(iteratorEntry)) {
                long id = entry.getElement().id();
                addEntry.setId(id);
                addEntry.setCount(entry.getCount());
                list.add(addEntry, tmpAddEntry);
            }
            boolean makeNewList = true;
            int hash = list.hashCode();
            TIntArrayList offsetsForHash = (TIntArrayList)offsetsForHashes.get(hash);
            if (offsetsForHash != null) {
                for (int offset : offsetsForHash) {
                    list2.referToDataAt(listData, offset);
                    if (!list.equals(list2)) continue;
                    makeNewList = false;
                    listEntryOffsets[o++] = offset;
                    break;
                }
            }
            if (!makeNewList) continue;
            boolean bl = insertNeeded = offsetsForHash == null;
            if (offsetsForHash == null) {
                offsetsForHash = new TIntArrayList();
            }
            offsetsForHash.add(nextListOffset);
            if (insertNeeded) {
                offsetsForHashes.put(hash, (Object)offsetsForHash);
            }
            listEntryOffsets[o++] = nextListOffset;
            nextListOffset = (int)((long)nextListOffset + list.getSizeInBytes());
        }
        byte[] bytes = new byte[VolatileLabelMultisetArray.getRequiredNumberOfBytes(0, listEntryOffsets, nextListOffset)];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putInt(0);
        for (int d : listEntryOffsets) {
            bb.putInt(d);
        }
        for (int i = 0; i < nextListOffset; ++i) {
            bb.put(ByteUtils.getByte(listData.data, i));
        }
        return bytes;
    }

    public static LabelMultisetType getOutOfBounds() {
        return LabelUtils.getOutOfBounds(1);
    }

    public static LabelMultisetType getOutOfBounds(int count) {
        return new LabelMultisetType(new LabelMultisetEntry(-3L, count));
    }

    public static VolatileLabelMultisetArray fromBytes(byte[] bytes, int numElements) {
        int i;
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        LOG.debug("Creating VolatileLabelMultisetArray from {} bytes for {} elements", (Object)bytes.length, (Object)numElements);
        int argMaxSize = bb.getInt();
        LOG.debug("Data contains {} arg maxes", (Object)argMaxSize);
        long[] argMax = new long[argMaxSize];
        for (int i2 = 0; i2 < argMaxSize; ++i2) {
            argMax[i2] = bb.getLong();
        }
        int[] data = new int[numElements];
        int listDataSize = bytes.length - (AbstractLabelMultisetLoader.listOffsetsSizeInBytes(data.length) + AbstractLabelMultisetLoader.argMaxListSizeInBytes(argMax.length));
        LongMappedAccessData listData = LongMappedAccessData.factory.createStorage(listDataSize);
        for (i = 0; i < data.length; ++i) {
            data[i] = bb.getInt();
        }
        for (i = 0; i < listDataSize; ++i) {
            ByteUtils.putByte(bb.get(), listData.data, i);
        }
        if (argMaxSize == 0) {
            argMax = new long[data.length];
            for (i = 0; i < data.length; ++i) {
                int listDataIdx = data[i];
                LabelMultisetEntryList lmel = new LabelMultisetEntryList();
                lmel.referToDataAt(listData, listDataIdx);
                argMax[i] = LabelUtils.getArgMax(lmel);
            }
        }
        return new VolatileLabelMultisetArray(data, listData, listDataSize, true, argMax);
    }

    public static long getArgMax(Collection<? extends LabelMultisetType.Entry<Label>> labelMultisetEntries) {
        int maxCount = 0;
        long maxCountId = -2L;
        for (LabelMultisetType.Entry<Label> entry : labelMultisetEntries) {
            if (maxCount >= entry.getCount()) continue;
            maxCount = entry.getCount();
            maxCountId = entry.getElement().id();
        }
        return maxCountId;
    }

    public static RandomAccessibleInterval<UnsignedLongType> convertToUnsignedLong(RandomAccessibleInterval<LabelMultisetType> labelMultisets) {
        return Converters.convert(labelMultisets, (Converter)new LabelMultisetToUnsignedLongConverter(), (Type)new UnsignedLongType());
    }
}

