/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import java.nio.ByteBuffer;
import net.imglib2.Interval;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.label.ByteUtils;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LabelUtils;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.view.Views;

public class LabelMultisetTypeDownscaler {
    public static VolatileLabelMultisetArray createDownscaledCell(RandomAccessible<LabelMultisetType> source, Interval interval, int[] factor, int maxNumEntriesPerPixel) {
        return LabelMultisetTypeDownscaler.createDownscaledCell((RandomAccessibleInterval<LabelMultisetType>)Views.interval(source, (Interval)interval), factor, maxNumEntriesPerPixel);
    }

    public static VolatileLabelMultisetArray createDownscaledCell(RandomAccessibleInterval<LabelMultisetType> source, int[] downscaleFactor, int maxNumEntriesPerPixel) {
        RandomAccess randomAccess = source.randomAccess();
        int numDim = source.numDimensions();
        long[] sourceShape = new long[numDim];
        long[] cellOffset = new long[numDim];
        long[] totalOffset = new long[numDim];
        for (int i = 0; i < numDim; ++i) {
            sourceShape[i] = source.max(i) + 1L;
        }
        int numDownscaledLists = 1;
        for (int i = 0; i < numDim; ++i) {
            long cellDimLength = (long)Math.ceil((double)sourceShape[i] / (double)downscaleFactor[i]);
            numDownscaledLists = (int)((long)numDownscaledLists * cellDimLength);
        }
        int[] listEntryOffsets = new int[numDownscaledLists];
        LongMappedAccessData listEntryData = LongMappedAccessData.factory.createStorage(32L);
        LabelMultisetEntryList list = new LabelMultisetEntryList(listEntryData, 0L);
        LabelMultisetEntryList list2 = new LabelMultisetEntryList();
        LabelMultisetEntry iteratorEntry = new LabelMultisetEntry(0L, 1);
        LabelMultisetEntry addEntry = new LabelMultisetEntry(0L, 1);
        LabelMultisetEntry tmpAddEntry = new LabelMultisetEntry(0L, 1);
        int nextListOffset = 0;
        int o = 0;
        TIntObjectHashMap offsetsForHashes = new TIntObjectHashMap();
        TLongArrayList argMax = new TLongArrayList();
        TLongIntHashMap cellEntryMap = new TLongIntHashMap(10, 0.5f, -1L, -1);
        int d = 0;
        block2: while (d < numDim) {
            list.createListAt(listEntryData, nextListOffset);
            System.arraycopy(cellOffset, 0, totalOffset, 0, numDim);
            int g = 0;
            block3: while (g < numDim) {
                randomAccess.setPosition(totalOffset);
                for (LabelMultisetEntry sourceEntry : ((LabelMultisetType)((Object)randomAccess.get())).entrySetWithRef(iteratorEntry)) {
                    long id2 = sourceEntry.getElement().id();
                    int count2 = sourceEntry.getCount();
                    if (cellEntryMap.containsKey(id2)) {
                        cellEntryMap.put(id2, cellEntryMap.get(id2) + count2);
                        continue;
                    }
                    cellEntryMap.put(id2, count2);
                }
                for (g = 0; g < numDim; ++g) {
                    int n = g;
                    totalOffset[n] = totalOffset[n] + 1L;
                    if (totalOffset[g] < cellOffset[g] + (long)downscaleFactor[g] && totalOffset[g] < sourceShape[g]) continue block3;
                    totalOffset[g] = cellOffset[g];
                }
            }
            cellEntryMap.forEachEntry((id, count) -> {
                addEntry.setId(id);
                addEntry.setCount(count);
                list.add(addEntry, tmpAddEntry);
                return true;
            });
            cellEntryMap.clear();
            list.sortById();
            if (maxNumEntriesPerPixel > 0 && list.size() > maxNumEntriesPerPixel) {
                list.sort((e1, e2) -> Long.compare(e2.getCount(), e1.getCount()));
                list.limitSize(maxNumEntriesPerPixel);
                list.sortById();
            }
            argMax.add(LabelUtils.getArgMax(list));
            boolean makeNewList = true;
            int hash = list.hashCode();
            TIntArrayList offsetsForHash = (TIntArrayList)offsetsForHashes.get(hash);
            if (offsetsForHash == null) {
                offsetsForHash = new TIntArrayList();
                offsetsForHashes.put(hash, (Object)offsetsForHash);
            }
            for (int i = 0; i < offsetsForHash.size(); ++i) {
                int offset = offsetsForHash.get(i);
                list2.referToDataAt(listEntryData, offset);
                if (!list.equals(list2)) continue;
                makeNewList = false;
                listEntryOffsets[o++] = offset;
                break;
            }
            if (makeNewList) {
                listEntryOffsets[o++] = nextListOffset;
                offsetsForHash.add(nextListOffset);
                nextListOffset = (int)((long)nextListOffset + list.getSizeInBytes());
            }
            for (d = 0; d < numDim; ++d) {
                int n = d;
                cellOffset[n] = cellOffset[n] + (long)downscaleFactor[d];
                if (cellOffset[d] < sourceShape[d]) continue block2;
                cellOffset[d] = 0L;
            }
        }
        return new VolatileLabelMultisetArray(listEntryOffsets, listEntryData, nextListOffset, true, argMax.toArray());
    }

    public static int getSerializedVolatileLabelMultisetArraySize(VolatileLabelMultisetArray array) {
        return VolatileLabelMultisetArray.getRequiredNumberOfBytes(0, array.getCurrentStorageArray(), (int)array.getListDataUsedSizeInBytes());
    }

    public static void serializeVolatileLabelMultisetArray(VolatileLabelMultisetArray array, byte[] bytes) {
        int[] curStorage = array.getCurrentStorageArray();
        long[] data = array.getListData().data;
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putInt(0);
        for (int d : curStorage) {
            bb.putInt(d);
        }
        for (long i = 0L; i < array.getListDataUsedSizeInBytes(); ++i) {
            bb.put(ByteUtils.getByte(data, i));
        }
    }
}

