/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.math.BigInteger;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import net.imglib2.img.NativeImg;
import net.imglib2.type.AbstractNativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetEntryList;
import net.imglib2.type.label.LabelUtils;
import net.imglib2.type.label.RefList;
import net.imglib2.type.label.VolatileLabelMultisetArray;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Fraction;

public class LabelMultisetType
extends AbstractNativeType<LabelMultisetType>
implements IntegerType<LabelMultisetType> {
    public static final LabelMultisetType type = new LabelMultisetType();
    private final NativeImg<?, VolatileLabelMultisetArray> img;
    private VolatileLabelMultisetArray access;
    private final LabelMultisetEntryList entries = new LabelMultisetEntryList();
    private final Set<Entry<Label>> entrySet;

    public LabelMultisetType(NativeImg<?, VolatileLabelMultisetArray> img) {
        this(img, null);
    }

    public LabelMultisetType(VolatileLabelMultisetArray access) {
        this(null, access);
    }

    public LabelMultisetType() {
        this(null, new VolatileLabelMultisetArray(1, true, new long[]{-2L}));
    }

    public LabelMultisetType(LabelMultisetEntry entry) {
        this();
        this.access.getValue(this.i.get(), this.entries);
        this.entries.add(entry);
        this.access.setArgMax(this.i.get(), entry.getId());
    }

    public LabelMultisetType(LabelMultisetEntryList entries) {
        this();
        this.access.getValue(this.i.get(), this.entries);
        this.entries.addAll(entries);
        this.updateArgMax();
    }

    private LabelMultisetType(NativeImg<?, VolatileLabelMultisetArray> img, VolatileLabelMultisetArray access) {
        this.img = img;
        this.access = access;
        this.entrySet = new AbstractSet<Entry<Label>>(){
            private final RefList.RefIterator<Entry<Label>> iterator = new RefList.RefIterator<Entry<Label>>(){
                private final RefList.RefIterator<LabelMultisetEntry> it;
                {
                    this.it = LabelMultisetType.this.entries.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public LabelMultisetEntry next() {
                    return (LabelMultisetEntry)this.it.next();
                }

                @Override
                public void release() {
                    this.it.release();
                }

                @Override
                public void reset() {
                    this.it.reset();
                }
            };

            @Override
            public RefList.RefIterator<Entry<Label>> iterator() {
                this.iterator.reset();
                return this.iterator;
            }

            @Override
            public int size() {
                return LabelMultisetType.this.entries.size();
            }

            @Override
            public Stream<Entry<Label>> stream() {
                throw new UnsupportedOperationException("Streams are not compatible with " + this.getClass().getName() + " because its iterator reuses the same reference.");
            }

            @Override
            public Stream<Entry<Label>> parallelStream() {
                throw new UnsupportedOperationException("Streams are not compatible with " + this.getClass().getName() + " because its iterator reuses the same reference.");
            }
        };
    }

    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    public void updateContainer(Object c) {
        this.access = (VolatileLabelMultisetArray)this.img.update(c);
    }

    public LabelMultisetType createVariable() {
        return new LabelMultisetType();
    }

    public LabelMultisetType copy() {
        LabelMultisetType that = new LabelMultisetType(this.img, this.access);
        that.i.set(this.i.get());
        return that;
    }

    public void set(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public NativeTypeFactory<LabelMultisetType, ?> getNativeTypeFactory() {
        throw new UnsupportedOperationException();
    }

    public LabelMultisetType duplicateTypeOnSameNativeImg() {
        return new LabelMultisetType(this.img);
    }

    public int size() {
        this.access.getValue(this.i.get(), this.entries);
        return this.entries.multisetSize();
    }

    public boolean isEmpty() {
        this.access.getValue(this.i.get(), this.entries);
        return this.entries.isEmpty();
    }

    public boolean contains(Label l, LabelMultisetEntry ref) {
        return this.contains(l.id(), ref);
    }

    public boolean contains(Label l) {
        return this.contains(l.id());
    }

    public boolean contains(long id, LabelMultisetEntry ref) {
        this.access.getValue(this.i.get(), this.entries);
        return this.entries.binarySearch(id, ref) >= 0;
    }

    public boolean contains(long id) {
        this.access.getValue(this.i.get(), this.entries);
        return this.entries.binarySearch(id) >= 0;
    }

    public boolean containsAll(long[] ids) {
        this.access.getValue(this.i.get(), this.entries);
        for (long id : ids) {
            if (this.entries.binarySearch(id) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(long[] ids, LabelMultisetEntry ref) {
        this.access.getValue(this.i.get(), this.entries);
        for (long id : ids) {
            if (this.entries.binarySearch(id, ref) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<? extends Label> c) {
        this.access.getValue(this.i.get(), this.entries);
        for (Label label : c) {
            if (this.entries.binarySearch(label.id()) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(Collection<? extends Label> c, LabelMultisetEntry ref) {
        this.access.getValue(this.i.get(), this.entries);
        for (Label label : c) {
            if (this.entries.binarySearch(label.id(), ref) >= 0) continue;
            return false;
        }
        return true;
    }

    public int count(Label l) {
        return this.count(l.id());
    }

    public int count(long id) {
        this.access.getValue(this.i.get(), this.entries);
        int pos = this.entries.binarySearch(id);
        if (pos < 0) {
            return 0;
        }
        return ((LabelMultisetEntry)this.entries.get(pos)).getCount();
    }

    public int countWithRef(long id, LabelMultisetEntry ref) {
        this.access.getValue(this.i.get(), this.entries);
        int pos = this.entries.binarySearch(id, ref);
        if (pos < 0) {
            return 0;
        }
        return ((LabelMultisetEntry)this.entries.get(pos)).getCount();
    }

    public Set<Entry<Label>> entrySet() {
        this.access.getValue(this.i.get(), this.entries);
        return this.entrySet;
    }

    public Set<LabelMultisetEntry> entrySetWithRef(final LabelMultisetEntry ref) {
        this.access.getValue(this.i.get(), this.entries);
        return new AbstractSet<LabelMultisetEntry>(){

            @Override
            public Iterator<LabelMultisetEntry> iterator() {
                return new Iterator<LabelMultisetEntry>(){
                    int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return this.idx < this.size();
                    }

                    @Override
                    public LabelMultisetEntry next() {
                        return LabelMultisetType.this.entries.get(this.idx++, ref);
                    }
                };
            }

            @Override
            public int size() {
                return LabelMultisetType.this.entries.size();
            }
        };
    }

    public String toString() {
        this.access.getValue(this.i.get(), this.entries);
        return this.entries.toString();
    }

    boolean isValid() {
        return this.access.isValid();
    }

    public boolean valueEquals(LabelMultisetType other) {
        if (this.entries.size() != other.entries.size()) {
            return false;
        }
        Iterator ai = this.entries.iterator();
        Iterator bi = other.entries.iterator();
        while (ai.hasNext()) {
            LabelMultisetEntry a = (LabelMultisetEntry)ai.next();
            LabelMultisetEntry b = (LabelMultisetEntry)bi.next();
            if (a.getId() == b.getId() && a.getCount() == b.getCount()) continue;
            return false;
        }
        return true;
    }

    public VolatileLabelMultisetArray getAccess() {
        return this.access;
    }

    public void inc() {
        throw new UnsupportedOperationException();
    }

    public void dec() {
        throw new UnsupportedOperationException();
    }

    public double getMaxValue() {
        throw new UnsupportedOperationException();
    }

    public double getMinValue() {
        throw new UnsupportedOperationException();
    }

    public double getMinIncrement() {
        throw new UnsupportedOperationException();
    }

    public int getBitsPerPixel() {
        throw new UnsupportedOperationException();
    }

    public double getRealDouble() {
        return this.getIntegerLong();
    }

    public float getRealFloat() {
        return this.getIntegerLong();
    }

    public double getImaginaryDouble() {
        return 0.0;
    }

    public float getImaginaryFloat() {
        return 0.0f;
    }

    public void setReal(float f) {
        throw new UnsupportedOperationException();
    }

    public void setReal(double f) {
        throw new UnsupportedOperationException();
    }

    public void setImaginary(float f) {
        throw new UnsupportedOperationException();
    }

    public void setImaginary(double f) {
        throw new UnsupportedOperationException();
    }

    public void setComplexNumber(float r, float i) {
        throw new UnsupportedOperationException();
    }

    public void setComplexNumber(double r, double i) {
        throw new UnsupportedOperationException();
    }

    public float getPowerFloat() {
        return this.getRealFloat();
    }

    public double getPowerDouble() {
        return this.getRealDouble();
    }

    public float getPhaseFloat() {
        return 0.0f;
    }

    public double getPhaseDouble() {
        return 0.0;
    }

    public void complexConjugate() {
        throw new UnsupportedOperationException();
    }

    public void add(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void mul(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void sub(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void div(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void setOne() {
        throw new UnsupportedOperationException();
    }

    public void setZero() {
        throw new UnsupportedOperationException();
    }

    public void mul(float c) {
        throw new UnsupportedOperationException();
    }

    public void mul(double c) {
        throw new UnsupportedOperationException();
    }

    public int compareTo(LabelMultisetType arg0) {
        throw new UnsupportedOperationException();
    }

    public int getInteger() {
        return (int)this.getIntegerLong();
    }

    public long getIntegerLong() {
        return this.argMax();
    }

    public BigInteger getBigInteger() {
        BigInteger mask = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        return BigInteger.valueOf(this.argMax()).and(mask);
    }

    public void setInteger(int f) {
        throw new UnsupportedOperationException();
    }

    public void setInteger(long f) {
        throw new UnsupportedOperationException();
    }

    public void setBigInteger(BigInteger b) {
        throw new UnsupportedOperationException();
    }

    public long argMax() {
        return this.access.argMax(this.i.get());
    }

    public void updateArgMax() {
        this.access.setArgMax(this.i.get(), LabelUtils.getArgMax(this.entrySet()));
    }

    public static LabelMultisetType singleEntryWithSingleOccurrence() {
        return LabelMultisetType.singleEntryWithNumOccurrences(1);
    }

    public static LabelMultisetType singleEntryWithNumOccurrences(int numOccurrences) {
        return new LabelMultisetType(new LabelMultisetEntry(-2L, numOccurrences));
    }

    public void pow(LabelMultisetType c) {
        throw new UnsupportedOperationException();
    }

    public void pow(double d) {
        throw new UnsupportedOperationException();
    }

    public static interface Entry<E> {
        public E getElement();

        public int getCount();
    }
}

