/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.util.Iterator;
import java.util.Set;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LongMappedAccess;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.MappedObjectArrayList;
import net.imglib2.type.label.Multiset;

public class LabelMultisetEntryList
extends MappedObjectArrayList<LabelMultisetEntry, LongMappedAccess> {
    public LabelMultisetEntryList() {
        super(LabelMultisetEntry.type);
    }

    public LabelMultisetEntryList(int capacity) {
        super(LabelMultisetEntry.type, capacity);
    }

    public LabelMultisetEntryList(LongMappedAccessData data, long baseOffset) {
        super(LabelMultisetEntry.type, data, baseOffset);
    }

    protected int multisetSize() {
        int size = 0;
        for (LabelMultisetEntry e : this) {
            size += e.getCount();
        }
        return size;
    }

    public int binarySearch(long id) {
        return this.binarySearch(id, 0, this.size());
    }

    public int binarySearch(long id, LabelMultisetEntry ref) {
        return this.binarySearch(id, 0, this.size(), ref);
    }

    public int binarySearch(long id, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.size()) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        LabelMultisetEntry ref = (LabelMultisetEntry)this.createRef();
        int idx = this.binarySearch(id, fromIndex, toIndex, ref);
        this.releaseRef(ref);
        return idx;
    }

    public int binarySearch(long id, int fromIndex, int toIndex, LabelMultisetEntry ref) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.size()) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.get(mid, ref).getId();
            if (midVal < id) {
                low = mid + 1;
                continue;
            }
            if (midVal > id) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void sortById() {
        this.sort((o1, o2) -> {
            long i1 = o1.getId();
            long i2 = o2.getId();
            return Long.compare(i1, i2);
        });
    }

    public void mergeConsecutiveEntries() {
        int oldSize = this.size();
        if (oldSize < 2) {
            return;
        }
        int newSize = oldSize;
        LabelMultisetEntry oldTail = (LabelMultisetEntry)this.createRef();
        LabelMultisetEntry newTail = (LabelMultisetEntry)this.createRef();
        int newPos = 0;
        this.get(newPos, newTail);
        for (int oldPos = 1; oldPos < oldSize; ++oldPos) {
            this.get(oldPos, oldTail);
            if (oldTail.getId() == newTail.getId()) {
                newTail.setCount(newTail.getCount() + oldTail.getCount());
                --newSize;
                continue;
            }
            this.get(++newPos, newTail);
            if (newPos == oldPos) continue;
            newTail.set(oldTail);
        }
        this.setSize(newSize);
    }

    public void mergeWith(LabelMultisetEntryList list) {
        LabelMultisetEntry e2;
        LabelMultisetEntry e1;
        block10: {
            if (list.isEmpty()) {
                return;
            }
            if (this.isEmpty()) {
                for (LabelMultisetEntry e : list) {
                    this.add(e);
                }
                return;
            }
            e1 = (LabelMultisetEntry)this.createRef();
            e2 = (LabelMultisetEntry)this.createRef();
            int i = 0;
            int j = 0;
            long id1 = this.get(i, e1).getId();
            long id2 = list.get(j, e2).getId();
            block1: while (true) {
                if (id1 == id2) {
                    e1.setCount(e1.getCount() + e2.getCount());
                    if (++j < list.size()) {
                        id2 = list.get(j, e2).getId();
                        continue;
                    }
                    break block10;
                }
                if (id2 < id1) {
                    this.add(i, e2);
                    this.get(++i, e1).getId();
                    if (++j < list.size()) {
                        id2 = list.get(j, e2).getId();
                        continue;
                    }
                    break block10;
                }
                while (++i < this.size()) {
                    id1 = this.get(i, e1).getId();
                    if (id2 > id1) continue;
                    continue block1;
                }
                break;
            }
            while (j < list.size()) {
                this.add(list.get(j, e2));
                ++j;
            }
        }
        this.releaseRef(e2);
        this.releaseRef(e1);
    }

    public void mergeWith(Multiset<Label> multiset) {
        this.mergeWith(multiset.entrySet());
    }

    public void mergeWith(Set<LabelMultisetType.Entry<Label>> entrySet) {
        LabelMultisetEntry e1;
        block10: {
            if (entrySet.isEmpty()) {
                return;
            }
            if (this.isEmpty()) {
                LabelMultisetEntry e12 = (LabelMultisetEntry)this.createRef();
                this.ensureCapacity(entrySet.size());
                this.setSize(entrySet.size());
                int i = 0;
                for (LabelMultisetType.Entry<Label> e : entrySet) {
                    this.get(i++, e12);
                    e12.setId(e.getElement().id());
                    e12.setCount(e.getCount());
                }
                this.releaseRef(e12);
                return;
            }
            e1 = (LabelMultisetEntry)this.createRef();
            Iterator<LabelMultisetType.Entry<Label>> iter = entrySet.iterator();
            LabelMultisetType.Entry<Label> e2 = iter.next();
            int i = 0;
            long id1 = this.get(i, e1).getId();
            long id2 = e2.getElement().id();
            block1: while (true) {
                if (id1 == id2) {
                    e1.setCount(e1.getCount() + e2.getCount());
                    if (iter.hasNext()) {
                        e2 = iter.next();
                        id2 = e2.getElement().id();
                        continue;
                    }
                    break block10;
                }
                if (id2 < id1) {
                    this.add(i, e1);
                    e1.setId(id2);
                    e1.setCount(e2.getCount());
                    this.get(++i, e1).getId();
                    if (iter.hasNext()) {
                        e2 = iter.next();
                        id2 = e2.getElement().id();
                        continue;
                    }
                    break block10;
                }
                while (++i < this.size()) {
                    id1 = this.get(i, e1).getId();
                    if (id2 > id1) continue;
                    continue block1;
                }
                break;
            }
            while (true) {
                this.add(e1);
                this.get(i++, e1);
                e1.setId(id2);
                e1.setCount(e2.getCount());
                if (!iter.hasNext()) break;
                e2 = iter.next();
                id2 = e2.getElement().id();
            }
        }
        this.releaseRef(e1);
    }
}

