/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.montage;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.CompositeConverter;
import ij.plugin.HyperStackConverter;
import ij.plugin.RGBStackConverter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ShortProcessor;
import java.util.ArrayList;
import java.util.Arrays;

public class StackMontage {
    public static ImagePlus montageImages(ArrayList<ImagePlus> theimages, int nrows, int ncols) {
        int bd = theimages.get(0).getBitDepth();
        int[] dims = theimages.get(0).getDimensions();
        for (ImagePlus img : theimages) {
            if (bd == img.getBitDepth() && Arrays.equals(dims, img.getDimensions())) continue;
            IJ.error((String)"Stack Montage", (String)"Dimension Mismatch");
            return null;
        }
        ImageStack fstack = new ImageStack(dims[0] * ncols, dims[1] * nrows);
        for (int z = 0; z < dims[2] * dims[3] * dims[4]; ++z) {
            ByteProcessor ip;
            switch (bd) {
                case 8: {
                    ip = new ByteProcessor(dims[0] * ncols, dims[1] * nrows);
                    break;
                }
                case 16: {
                    ip = new ShortProcessor(dims[0] * ncols, dims[1] * nrows);
                    break;
                }
                case 24: {
                    ip = new ColorProcessor(dims[0] * ncols, dims[1] * nrows);
                    break;
                }
                case 32: {
                    ip = new FloatProcessor(dims[0] * ncols, dims[1] * nrows);
                    break;
                }
                default: {
                    ip = null;
                }
            }
            for (int r = 0; r < nrows; ++r) {
                for (int c = 0; c < ncols; ++c) {
                    int imgnumber = c + ncols * r;
                    if (imgnumber >= theimages.size()) continue;
                    int x = dims[0] * c;
                    int y = dims[1] * r;
                    ImagePlus imp = theimages.get(imgnumber);
                    ip.copyBits(imp.getStack().getProcessor(z + 1), x, y, 3);
                }
            }
            fstack.addSlice(ip);
        }
        ImagePlus fimp = new ImagePlus("Montage of Stacks", fstack);
        if (bd == 24) {
            fimp = CompositeConverter.makeComposite((ImagePlus)fimp);
            dims[2] = 3;
        }
        if (theimages.get(0).isHyperStack()) {
            fimp = HyperStackConverter.toHyperStack((ImagePlus)fimp, (int)dims[2], (int)dims[3], (int)dims[4]);
        }
        if (bd == 24) {
            RGBStackConverter.convertToRGB((ImagePlus)fimp);
        }
        return fimp;
    }
}

