/*
 * Decompiled with CFR 0.152.
 */
import ch.epfl.biop.montage.StackMontage;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.Duplicator;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Multi_Stack_Montage
implements PlugIn {
    private ArrayList<String> imagenames;
    private ArrayList<ImagePlus> imagestoprocess = new ArrayList(0);
    private final String nonestr = "*None*";
    private final int maximages = 10;
    private int nCols;
    private int nRows;

    public void run(String arg0) {
        this.imagenames = new ArrayList<String>(Arrays.asList(WindowManager.getImageTitles()));
        this.imagenames.add("*None*");
        if (this.imagenames.size() == 1) {
            IJ.error((String)"No images are open. Exiting");
            return;
        }
        if (this.showDialog()) {
            ImagePlus res = StackMontage.montageImages(this.imagestoprocess, this.nRows, this.nCols);
            res.show();
        }
    }

    private boolean showDialog() {
        int i;
        boolean macro;
        int count = this.imagenames.size() - 1 > 10 ? 10 : this.imagenames.size() - 1;
        this.nRows = this.nCols = (int)Math.sqrt(count);
        int n = count - this.nCols * this.nRows;
        if (n > 0) {
            this.nCols += (int)Math.ceil((double)n / (double)this.nRows);
        }
        String options = Macro.getOptions();
        boolean bl = macro = IJ.macroRunning() && options != null;
        if (macro) {
            count = 0;
            Pattern pattern = Pattern.compile("stack_\\d{1,3}");
            Matcher matcher = pattern.matcher(options);
            while (matcher.find()) {
                ++count;
            }
        }
        GenericDialog gd = new GenericDialog("Multi Stack Montage");
        for (i = 0; i < count; ++i) {
            gd.addChoice("Stack_" + (i + 1), this.imagenames.toArray(new String[0]), "*None*");
        }
        gd.addNumericField("Rows", (double)this.nRows, 0);
        gd.addNumericField("Columns", (double)this.nCols, 0);
        gd.setResizable(true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        for (i = 0; i < count; ++i) {
            String tmp = gd.getNextChoice();
            if (tmp.equals("*None*")) continue;
            this.imagestoprocess.add(WindowManager.getImage((String)tmp));
        }
        this.nRows = (int)gd.getNextNumber();
        this.nCols = (int)gd.getNextNumber();
        return true;
    }

    public static void main(String[] args) {
        Class<Multi_Stack_Montage> clazz = Multi_Stack_Montage.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring(5, url.length() - clazz.getName().length() - 6);
        System.setProperty("plugins.dir", pluginsDir);
        ImageJ ij = new ImageJ();
        ij.exitWhenQuitting(true);
        ImagePlus imp = IJ.openImage((String)"http://imagej.nih.gov/ij/images/confocal-series.zip");
        String imageName = imp.getTitle();
        ImagePlus imp1 = new Duplicator().run(imp, 1, 2, 1, 25, 1, 1);
        IJ.run((ImagePlus)imp1, (String)"Blue", (String)"");
        imp1.setTitle(imageName + "c1Blue");
        ImagePlus imp2 = new Duplicator().run(imp1, 1, 2, 1, 25, 1, 1);
        imp2.setC(2);
        IJ.run((ImagePlus)imp2, (String)"Magenta", (String)"");
        imp2.setTitle(imageName + "c1Blue_c2Magenta");
        ImagePlus imp3 = new Duplicator().run(imp2, 1, 2, 1, 25, 1, 1);
        imp3.setC(1);
        IJ.run((ImagePlus)imp3, (String)"Cyan", (String)"");
        imp3.setTitle(imageName + "c1Cyan_c2Magenta");
        IJ.run((ImagePlus)imp3, (String)"RGB Color", (String)"slices");
        IJ.run((ImagePlus)imp2, (String)"RGB Color", (String)"slices");
        IJ.run((ImagePlus)imp1, (String)"RGB Color", (String)"slices");
        IJ.run((ImagePlus)imp, (String)"RGB Color", (String)"slices");
        imp.show();
        imp1.show();
        imp2.show();
        imp3.show();
        IJ.runPlugIn((String)clazz.getName(), (String)"");
    }
}

