/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.viewer.image;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.imagej.Dataset;
import net.imagej.display.DatasetView;
import net.imagej.display.event.DataViewUpdatedEvent;
import net.imagej.ui.swing.viewer.image.FigureView;
import net.imagej.ui.swing.viewer.image.JHotDrawImageCanvas;
import net.imagej.ui.swing.viewer.image.SwingImageDisplayViewer;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.ImageFigure;
import org.scijava.AbstractContextual;
import org.scijava.event.EventHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.ui.awt.AWTImageTools;

public class DatasetFigureView
extends AbstractContextual
implements FigureView {
    private final DatasetView datasetView;
    private final ImageFigure figure;
    @Parameter
    private LogService log;

    public DatasetFigureView(SwingImageDisplayViewer displayViewer, DatasetView datasetView) {
        this.setContext(datasetView.getContext());
        this.datasetView = datasetView;
        JHotDrawImageCanvas canvas = displayViewer.getCanvas();
        Drawing drawing = canvas.getDrawing();
        this.figure = new ImageFigure();
        this.figure.setSelectable(false);
        this.figure.setTransformable(false);
        Dataset dataset = datasetView.getData();
        double minX = dataset.getImgPlus().realMin(0);
        double minY = dataset.getImgPlus().realMin(1);
        double maxX = dataset.getImgPlus().realMax(0);
        double maxY = dataset.getImgPlus().realMax(1);
        this.figure.setBounds(new Point2D.Double(minX, minY), new Point2D.Double(maxX, maxY));
        drawing.add((Figure)this.figure);
    }

    @EventHandler
    protected void onDataViewUpdatedEvent(DataViewUpdatedEvent event) {
        if (event.getView() == this.datasetView) {
            this.update();
        }
    }

    @Override
    public void update() {
        this.log.debug((Object)("Updating image figure: " + this));
        BufferedImage image = this.datasetView.getScreenImage().image();
        BufferedImage bufImage = AWTImageTools.makeBuffered((Image)image);
        this.figure.setBounds(new Rectangle2D.Double(0.0, 0.0, bufImage.getWidth(), bufImage.getHeight()));
        this.figure.setBufferedImage(bufImage);
    }

    public ImageFigure getFigure() {
        return this.figure;
    }

    public DatasetView getDataView() {
        return this.datasetView;
    }

    @Override
    public void dispose() {
        this.getFigure().requestRemove();
    }
}

