/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.imagej.ChannelCollection;
import net.imagej.display.DataView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayInfo;
import net.imagej.display.OverlayInfoList;
import net.imagej.display.OverlayService;
import net.imagej.display.OverlayView;
import net.imagej.display.event.DataViewSelectionEvent;
import net.imagej.event.OverlayCreatedEvent;
import net.imagej.event.OverlayDeletedEvent;
import net.imagej.event.OverlayRestructuredEvent;
import net.imagej.event.OverlayUpdatedEvent;
import net.imagej.options.OptionsChannels;
import net.imagej.overlay.CompositeOverlay;
import net.imagej.overlay.Overlay;
import org.scijava.Context;
import org.scijava.command.CommandService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.options.OptionsService;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.util.Prefs;

public class SwingOverlayManager
extends JFrame
implements ActionListener,
ItemListener {
    private static final String ACTION_ADD_PARTICLES = "add particles";
    private static final String ACTION_AND = "and";
    private static final String ACTION_DELETE = "delete";
    private static final String ACTION_DESELECT = "deselect";
    private static final String ACTION_DIVIDE = "divide";
    private static final String ACTION_DRAW = "draw";
    private static final String ACTION_FILL = "fill";
    private static final String ACTION_FLATTEN = "flatten";
    private static final String ACTION_HELP = "help";
    private static final String ACTION_LIST = "list";
    private static final String ACTION_MEASURE = "measure";
    private static final String ACTION_MULTI_MEASURE = "multi measure";
    private static final String ACTION_MULTI_PLOT = "multi plot";
    private static final String ACTION_OPEN = "open";
    private static final String ACTION_OPTIONS = "options";
    private static final String ACTION_OR = "or";
    private static final String ACTION_PROPERTIES = "properties";
    private static final String ACTION_REMOVE_SLICE_INFO = "remove slice info";
    private static final String ACTION_RENAME = "rename";
    private static final String ACTION_SAVE = "save";
    private static final String ACTION_SORT = "sort";
    private static final String ACTION_SPECIFY = "specify";
    private static final String ACTION_XOR = "xor";
    private static final String LAST_X = "lastXLocation";
    private static final String LAST_Y = "lastYLocation";
    private final Context context;
    private final JList<OverlayInfo> jlist;
    private final JCheckBox showAllCheckBox;
    private final JCheckBox editModeCheckBox;
    @Parameter
    private OverlayService overlayService;
    @Parameter
    private EventService eventService;
    @Parameter
    private ImageDisplayService imageDisplayService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private PlatformService platformService;
    @Parameter
    private OptionsService optionsService;
    private boolean selecting = false;
    private JPopupMenu popupMenu = null;
    private boolean shiftDown = false;
    private boolean altDown = false;

    public SwingOverlayManager(Context context) {
        this.context = context;
        context.inject((Object)this);
        this.jlist = new JList<OverlayInfo>(new OverlayListModel(this.overlayService.getOverlayInfo()));
        JScrollPane listScroller = new JScrollPane(this.jlist);
        listScroller.setPreferredSize(new Dimension(250, 80));
        listScroller.setAlignmentX(0.0f);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        listPanel.add(listScroller);
        listPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new GridLayout(9, 1, 5, 0));
        buttonPane.add(this.getDeleteButton());
        buttonPane.add(this.getRenameButton());
        buttonPane.add(this.getMeasureButton());
        buttonPane.add(this.getDeselectButton());
        buttonPane.add(this.getPropertiesButton());
        buttonPane.add(this.getFlattenButton());
        buttonPane.add(this.getFillButton());
        buttonPane.add(this.getDrawButton());
        buttonPane.add(this.getMoreButton());
        JPanel boolPane = new JPanel();
        boolPane.setLayout(new BoxLayout(boolPane, 1));
        this.showAllCheckBox = new JCheckBox("Show All", false);
        this.editModeCheckBox = new JCheckBox("Edit Mode", false);
        boolPane.add(this.showAllCheckBox);
        boolPane.add(this.editModeCheckBox);
        this.showAllCheckBox.addItemListener(this);
        this.editModeCheckBox.addItemListener(this);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BorderLayout());
        controlPanel.add((Component)buttonPane, "Center");
        controlPanel.add((Component)boolPane, "South");
        Container cp = this.getContentPane();
        cp.add((Component)listPanel, "Center");
        cp.add((Component)controlPanel, "East");
        this.setTitle("Overlay Manager");
        this.setupListSelectionListener();
        this.setupCloseListener();
        this.setupKeyListener();
        this.restoreLocation();
        this.pack();
        this.eventService.subscribe((Object)this);
        this.populateOverlayList();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command == null) {
            return;
        }
        if (command.equals(ACTION_ADD_PARTICLES)) {
            this.addParticles();
        } else if (command.equals(ACTION_AND)) {
            this.and();
        } else if (command.equals(ACTION_DELETE)) {
            this.delete();
        } else if (command.equals(ACTION_DESELECT)) {
            this.deselect();
        } else if (command.equals(ACTION_DIVIDE)) {
            this.divide();
        } else if (command.equals(ACTION_DRAW)) {
            this.draw();
        } else if (command.equals(ACTION_FILL)) {
            this.fill();
        } else if (command.equals(ACTION_FLATTEN)) {
            this.flatten();
        } else if (command.equals(ACTION_HELP)) {
            this.help();
        } else if (command.equals(ACTION_LIST)) {
            this.getList();
        } else if (command.equals(ACTION_MEASURE)) {
            this.measure();
        } else if (command.equals(ACTION_MULTI_MEASURE)) {
            this.multiMeasure();
        } else if (command.equals(ACTION_MULTI_PLOT)) {
            this.multiPlot();
        } else if (command.equals(ACTION_OPEN)) {
            this.open();
        } else if (command.equals(ACTION_OPTIONS)) {
            this.options();
        } else if (command.equals(ACTION_OR)) {
            this.or();
        } else if (command.equals(ACTION_PROPERTIES)) {
            this.properties();
        } else if (command.equals(ACTION_REMOVE_SLICE_INFO)) {
            this.removeSliceInfo();
        } else if (command.equals(ACTION_RENAME)) {
            this.rename();
        } else if (command.equals(ACTION_SAVE)) {
            this.save();
        } else if (command.equals(ACTION_SORT)) {
            this.sort();
        } else if (command.equals(ACTION_SPECIFY)) {
            this.specify();
        } else if (command.equals(ACTION_XOR)) {
            this.xor();
        }
    }

    private void populateOverlayList() {
        for (Overlay overlay : this.overlayService.getOverlays()) {
            boolean found = false;
            int totOverlays = this.overlayService.getOverlayInfo().getOverlayInfoCount();
            for (int i = 0; i < totOverlays; ++i) {
                OverlayInfo info = this.overlayService.getOverlayInfo().getOverlayInfo(i);
                if (overlay != info.getOverlay()) continue;
                found = true;
                break;
            }
            if (found) continue;
            OverlayInfo info = new OverlayInfo(overlay);
            this.overlayService.getOverlayInfo().addOverlayInfo(info);
        }
        this.jlist.updateUI();
    }

    @EventHandler
    protected void onEvent(OverlayCreatedEvent event) {
        this.overlayService.getOverlayInfo().addOverlay(event.getObject());
        this.jlist.updateUI();
    }

    @EventHandler
    protected void onEvent(OverlayDeletedEvent event) {
        Overlay overlay = event.getObject();
        this.overlayService.getOverlayInfo().deleteOverlay(overlay);
        int[] newSelectedIndices = this.overlayService.getOverlayInfo().selectedIndices();
        this.jlist.setSelectedIndices(newSelectedIndices);
        this.jlist.updateUI();
    }

    @EventHandler
    protected void onEvent(DataViewSelectionEvent event) {
        if (this.selecting) {
            return;
        }
        this.selecting = true;
        Overlay overlay = (Overlay)event.getView().getData();
        int overlayIndex = this.overlayService.getOverlayInfo().findIndex(overlay);
        OverlayInfo overlayInfo = this.overlayService.getOverlayInfo().getOverlayInfo(overlayIndex);
        overlayInfo.setSelected(event.isSelected());
        int[] selections = this.overlayService.getOverlayInfo().selectedIndices();
        this.jlist.setSelectedIndices(selections);
        this.selecting = false;
    }

    @EventHandler
    protected void onEvent(OverlayRestructuredEvent event) {
        this.jlist.updateUI();
    }

    @EventHandler
    protected void onEvent(OverlayUpdatedEvent event) {
        this.jlist.updateUI();
    }

    private void addParticles() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void and() {
        this.makeCompositeOverlay(CompositeOverlay.Operation.AND);
    }

    private void delete() {
        if (this.overlayService.getOverlayInfo().getOverlayInfoCount() == 0) {
            return;
        }
        LinkedList<Overlay> overlaysToDelete = new LinkedList<Overlay>();
        int[] selectedIndices = this.overlayService.getOverlayInfo().selectedIndices();
        if (selectedIndices.length == 0) {
            int result = JOptionPane.showConfirmDialog(this, "Delete all overlays?", "Delete All", 0);
            if (result != 0) {
                return;
            }
            for (int i = 0; i < this.overlayService.getOverlayInfo().getOverlayInfoCount(); ++i) {
                overlaysToDelete.add(this.overlayService.getOverlayInfo().getOverlayInfo(i).getOverlay());
            }
        } else {
            for (int i = 0; i < selectedIndices.length; ++i) {
                int index = selectedIndices[i];
                overlaysToDelete.add(this.overlayService.getOverlayInfo().getOverlayInfo(index).getOverlay());
            }
        }
        for (Overlay overlay : overlaysToDelete) {
            this.overlayService.removeOverlay(overlay);
        }
    }

    private void deselect() {
        this.overlayService.getOverlayInfo().deselectAll();
        this.jlist.clearSelection();
    }

    private void divide() {
        List overlays = this.overlayService.getOverlayInfo().selectedOverlays();
        int i = 0;
        while (i < overlays.size()) {
            Overlay o = (Overlay)overlays.get(i);
            if (!(o instanceof CompositeOverlay)) {
                overlays.remove(i);
                continue;
            }
            ++i;
        }
        if (overlays.size() == 0) {
            JOptionPane.showMessageDialog(this, "One or more composite overlays must be selected");
            return;
        }
        for (Overlay o : overlays) {
            this.overlayService.divideCompositeOverlay((CompositeOverlay)o);
        }
    }

    private void draw() {
        ChannelCollection channels = this.getChannels();
        List selected = this.overlayService.getOverlayInfo().selectedOverlays();
        for (Overlay o : selected) {
            ImageDisplay disp = this.overlayService.getFirstDisplay(o);
            this.overlayService.drawOverlay(o, disp, channels);
        }
    }

    private void fill() {
        ChannelCollection channels = this.getChannels();
        List selected = this.overlayService.getOverlayInfo().selectedOverlays();
        for (Overlay o : selected) {
            ImageDisplay disp = this.overlayService.getFirstDisplay(o);
            this.overlayService.fillOverlay(o, disp, channels);
        }
    }

    private void flatten() {
        ImageDisplay imageDisplay = this.imageDisplayService.getActiveImageDisplay();
        if (imageDisplay == null) {
            return;
        }
        this.commandService.run("net.imagej.plugins.commands.display.Flatten", true, new Object[]{"display", imageDisplay});
    }

    private void help() {
        try {
            URL url = new URL("https://imagej.net/software/imagej2/implementation-notes#image--overlay--overlay-manager");
            this.platformService.open(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void getList() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void measure() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void multiMeasure() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void multiPlot() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void open() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void options() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void or() {
        this.makeCompositeOverlay(CompositeOverlay.Operation.OR);
    }

    private void properties() {
        int[] selected = this.overlayService.getOverlayInfo().selectedIndices();
        if (selected.length == 0) {
            JOptionPane.showMessageDialog(this, "This command requires one or more selections");
            return;
        }
        this.runPropertiesPlugin();
    }

    private void removeSliceInfo() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void rename() {
        int[] selectedIndices = this.overlayService.getOverlayInfo().selectedIndices();
        if (selectedIndices.length < 1) {
            JOptionPane.showMessageDialog(this, "Must select an overlay to rename");
            return;
        }
        if (selectedIndices.length > 1) {
            JOptionPane.showMessageDialog(this, "Cannot rename multiple overlays simultaneously");
            return;
        }
        OverlayInfo info = this.overlayService.getOverlayInfo().getOverlayInfo(selectedIndices[0]);
        if (info == null) {
            return;
        }
        String name = JOptionPane.showInputDialog(this, (Object)"Enter new name for overlay");
        if (name == null || name.length() == 0) {
            info.getOverlay().setName(null);
        } else {
            info.getOverlay().setName(name);
        }
        this.jlist.updateUI();
    }

    private void save() {
        JOptionPane.showMessageDialog(this, "unimplemented");
    }

    private void sort() {
        this.overlayService.getOverlayInfo().sort();
        int[] newSelections = this.overlayService.getOverlayInfo().selectedIndices();
        this.jlist.setSelectedIndices(newSelections);
        this.jlist.updateUI();
    }

    private void specify() {
        ImageDisplay imageDisplay = this.imageDisplayService.getActiveImageDisplay();
        if (imageDisplay == null) {
            return;
        }
        this.commandService.run("net.imagej.plugins.commands.overlay.SelectionSpecify", true, new Object[]{"display", imageDisplay});
    }

    private void xor() {
        this.makeCompositeOverlay(CompositeOverlay.Operation.XOR);
    }

    private void setupKeyListener() {
        KeyListener listener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                SwingOverlayManager.this.altDown = e.isAltDown() || e.isAltGraphDown();
                SwingOverlayManager.this.shiftDown = e.isShiftDown();
                if (e.getKeyCode() == 70) {
                    SwingOverlayManager.this.flatten();
                }
                if (e.getKeyCode() == 127) {
                    SwingOverlayManager.this.delete();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SwingOverlayManager.this.altDown = e.isAltDown() || e.isAltGraphDown();
                SwingOverlayManager.this.shiftDown = e.isShiftDown();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        Stack<Component> stack = new Stack<Component>();
        stack.push(this);
        while (!stack.empty()) {
            Component component = (Component)stack.pop();
            component.addKeyListener(listener);
            if (!(component instanceof Container)) continue;
            Container container = (Container)component;
            for (Component c : container.getComponents()) {
                stack.push(c);
            }
        }
    }

    private void saveLocation() {
        Prefs.put(this.getClass(), (String)LAST_X, (int)this.getLocation().x);
        Prefs.put(this.getClass(), (String)LAST_Y, (int)this.getLocation().y);
    }

    private void restoreLocation() {
        int lastX = Prefs.getInt(this.getClass(), (String)LAST_X, (int)0);
        int lastY = Prefs.getInt(this.getClass(), (String)LAST_Y, (int)0);
        this.setLocation(lastX, lastY);
    }

    private void setupCloseListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingOverlayManager.this.saveLocation();
            }
        });
    }

    private void setupListSelectionListener() {
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (SwingOverlayManager.this.selecting) {
                    return;
                }
                SwingOverlayManager.this.selecting = true;
                ImageDisplay display = SwingOverlayManager.this.imageDisplayService.getActiveImageDisplay();
                if (display == null) {
                    return;
                }
                JList list = (JList)listSelectionEvent.getSource();
                List selectionValues = list.getSelectedValuesList();
                SwingOverlayManager.this.overlayService.getOverlayInfo().deselectAll();
                for (Object overlayInfoObj : selectionValues) {
                    OverlayInfo overlayInfo = (OverlayInfo)overlayInfoObj;
                    overlayInfo.setSelected(true);
                }
                block1: for (DataView overlayView : display) {
                    overlayView.setSelected(false);
                    for (Object overlayInfoObj : selectionValues) {
                        OverlayInfo overlayInfo = (OverlayInfo)overlayInfoObj;
                        if (overlayInfo.getOverlay() != overlayView.getData()) continue;
                        overlayInfo.setSelected(true);
                        overlayView.setSelected(true);
                        continue block1;
                    }
                }
                SwingOverlayManager.this.selecting = false;
            }
        };
        this.jlist.addListSelectionListener(listSelectionListener);
    }

    private JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = this.createPopupMenu();
        }
        return this.popupMenu;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(this.getOpenMenuItem());
        menu.add(this.getSaveMenuItem());
        menu.add(this.getAndMenuItem());
        menu.add(this.getOrMenuItem());
        menu.add(this.getXorMenuItem());
        menu.add(this.getDivideMenuItem());
        menu.add(this.getAddParticlesMenuItem());
        menu.add(this.getMultiMeasureMenuItem());
        menu.add(this.getMultiPlotMenuItem());
        menu.add(this.getSortMenuItem());
        menu.add(this.getSpecifyMenuItem());
        menu.add(this.getRemoveSliceInfoMenuItem());
        menu.add(this.getListMenuItem());
        menu.add(this.getHelpMenuItem());
        menu.add(this.getOptionsMenuItem());
        return menu;
    }

    private JMenuItem getAddParticlesMenuItem() {
        JMenuItem item = new JMenuItem("Add Particles");
        item.setActionCommand(ACTION_ADD_PARTICLES);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getAndMenuItem() {
        JMenuItem item = new JMenuItem("AND");
        item.setActionCommand(ACTION_AND);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getHelpMenuItem() {
        JMenuItem item = new JMenuItem("Help");
        item.setActionCommand(ACTION_HELP);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getListMenuItem() {
        JMenuItem item = new JMenuItem("List");
        item.setActionCommand(ACTION_LIST);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getMultiMeasureMenuItem() {
        JMenuItem item = new JMenuItem("Multi Measure");
        item.setActionCommand(ACTION_MULTI_MEASURE);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getMultiPlotMenuItem() {
        JMenuItem item = new JMenuItem("Multi Plot");
        item.setActionCommand(ACTION_MULTI_PLOT);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getOpenMenuItem() {
        JMenuItem item = new JMenuItem("Open...");
        item.setActionCommand(ACTION_OPEN);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getOptionsMenuItem() {
        JMenuItem item = new JMenuItem("Options...");
        item.setActionCommand(ACTION_OPTIONS);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getOrMenuItem() {
        JMenuItem item = new JMenuItem("OR (Combine)");
        item.setActionCommand(ACTION_OR);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getRemoveSliceInfoMenuItem() {
        JMenuItem item = new JMenuItem("Remove Slice Info");
        item.setActionCommand(ACTION_REMOVE_SLICE_INFO);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getSaveMenuItem() {
        JMenuItem item = new JMenuItem("Save...");
        item.setActionCommand(ACTION_SAVE);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getSortMenuItem() {
        JMenuItem item = new JMenuItem("Sort");
        item.setActionCommand(ACTION_SORT);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getSpecifyMenuItem() {
        JMenuItem item = new JMenuItem("Specify...");
        item.setActionCommand(ACTION_SPECIFY);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getDivideMenuItem() {
        JMenuItem item = new JMenuItem("Divide");
        item.setActionCommand(ACTION_DIVIDE);
        item.addActionListener(this);
        return item;
    }

    private JMenuItem getXorMenuItem() {
        JMenuItem item = new JMenuItem("XOR");
        item.setActionCommand(ACTION_XOR);
        item.addActionListener(this);
        return item;
    }

    private JButton getDeleteButton() {
        JButton button = new JButton("Delete");
        button.setActionCommand(ACTION_DELETE);
        button.addActionListener(this);
        return button;
    }

    private JButton getDeselectButton() {
        JButton button = new JButton("Deselect");
        button.setActionCommand(ACTION_DESELECT);
        button.addActionListener(this);
        return button;
    }

    private JButton getDrawButton() {
        JButton button = new JButton("Draw");
        button.setActionCommand(ACTION_DRAW);
        button.addActionListener(this);
        return button;
    }

    private JButton getFillButton() {
        JButton button = new JButton("Fill");
        button.setActionCommand(ACTION_FILL);
        button.addActionListener(this);
        return button;
    }

    private JButton getFlattenButton() {
        JButton button = new JButton("Flatten [f]");
        button.setActionCommand(ACTION_FLATTEN);
        button.addActionListener(this);
        return button;
    }

    private JButton getMeasureButton() {
        JButton button = new JButton("Measure");
        button.setActionCommand(ACTION_MEASURE);
        button.addActionListener(this);
        return button;
    }

    private JButton getMoreButton() {
        JButton button = new JButton("More \u00bb");
        button.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingOverlayManager.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
            }

            @Override
            public void mouseExited(MouseEvent evt) {
            }

            @Override
            public void mousePressed(MouseEvent evt) {
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
            }
        });
        return button;
    }

    private JButton getPropertiesButton() {
        JButton button = new JButton("Properties...");
        button.setActionCommand(ACTION_PROPERTIES);
        button.addActionListener(this);
        return button;
    }

    private JButton getRenameButton() {
        JButton button = new JButton("Rename...");
        button.setActionCommand(ACTION_RENAME);
        button.addActionListener(this);
        return button;
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean selected;
        boolean bl = selected = evt.getStateChange() == 1;
        if (evt.getSource() == this.showAllCheckBox) {
            // empty if block
        }
        if (evt.getSource() == this.editModeCheckBox && selected) {
            this.showAllCheckBox.setSelected(true);
        }
    }

    private Overlay getActiveOverlay() {
        ImageDisplay activeDisplay = this.imageDisplayService.getActiveImageDisplay();
        if (activeDisplay == null) {
            return null;
        }
        ImageDisplay views = activeDisplay;
        for (DataView view : views) {
            if (!view.isSelected() || !(view instanceof OverlayView)) continue;
            return ((OverlayView)view).getData();
        }
        return null;
    }

    private void runPropertiesPlugin() {
        HashMap<String, List> inputMap = new HashMap<String, List>();
        inputMap.put("overlays", this.overlayService.getOverlayInfo().selectedOverlays());
        this.commandService.run("net.imagej.plugins.commands.overlay.SelectedManagerOverlayProperties", true, inputMap);
    }

    private ChannelCollection getChannels() {
        OptionsChannels opts = (OptionsChannels)this.optionsService.getOptions(OptionsChannels.class);
        if (this.altDown) {
            return opts.getBgValues();
        }
        return opts.getFgValues();
    }

    private void makeCompositeOverlay(CompositeOverlay.Operation op) {
        ImageDisplay imageDisplay = this.imageDisplayService.getActiveImageDisplay();
        if (imageDisplay == null) {
            return;
        }
        List overlays = this.overlayService.getOverlayInfo().selectedOverlays();
        if (overlays.size() == 0) {
            overlays = this.overlayService.getOverlays(imageDisplay);
        }
        if (overlays.size() < 2) {
            JOptionPane.showMessageDialog(this, "This command only works with 2 or more overlays");
            return;
        }
        CompositeOverlay newOverlay = new CompositeOverlay(this.context);
        for (Overlay o : overlays) {
            newOverlay.doOperation(op, o);
        }
        imageDisplay.display((Object)newOverlay);
        imageDisplay.update();
    }

    private class OverlayListModel
    extends AbstractListModel<OverlayInfo> {
        private OverlayInfoList overlayInfoList;

        public OverlayListModel(OverlayInfoList list) {
            this.overlayInfoList = list;
        }

        @Override
        public OverlayInfo getElementAt(int index) {
            return this.overlayInfoList.getOverlayInfo(index);
        }

        @Override
        public int getSize() {
            return this.overlayInfoList.getOverlayInfoCount();
        }
    }
}

