/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.event.MouseEvent;
import net.imagej.display.ImageDisplay;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawService;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.tool.CreationTool;
import org.scijava.display.Display;

public class IJCreationTool<F extends Figure>
extends CreationTool
implements JHotDrawTool {
    private final ImageDisplay display;
    private final JHotDrawAdapter<F> adapter;

    public IJCreationTool(ImageDisplay display, JHotDrawAdapter<F> adapter) {
        super(adapter.createDefaultFigure());
        this.display = display;
        this.adapter = adapter;
    }

    protected Figure createFigure() {
        return this.getAdapter().createDefaultFigure();
    }

    protected void creationFinished(Figure figure) {
        super.creationFinished(figure);
        JHotDrawService jHotDrawService = (JHotDrawService)this.getDisplay().getContext().getService(JHotDrawService.class);
        jHotDrawService.linkOverlay(figure, this.getAdapter(), this.getDisplay());
    }

    @Override
    public ImageDisplay getDisplay() {
        return this.display;
    }

    public JHotDrawAdapter<F> getAdapter() {
        return this.adapter;
    }

    @Override
    public boolean isConstructing() {
        return this.createdFigure != null;
    }

    public void mouseClicked(MouseEvent evt) {
        if (!this.isLeftClick(evt)) {
            return;
        }
        super.mouseClicked(evt);
    }

    public void mousePressed(MouseEvent evt) {
        if (!this.isLeftClick(evt)) {
            return;
        }
        super.mousePressed(evt);
        this.adapter.mouseDown((Display<?>)this.getDisplay(), evt.getX(), evt.getY());
    }

    public void mouseReleased(MouseEvent evt) {
        if (!this.isLeftClick(evt)) {
            return;
        }
        super.mouseReleased(evt);
    }

    public void mouseDragged(MouseEvent evt) {
        super.mouseDragged(evt);
        this.adapter.mouseDrag((Display<?>)this.getDisplay(), evt.getX(), evt.getY());
    }

    private boolean isLeftClick(MouseEvent evt) {
        return evt.getButton() == 1;
    }
}

