/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ui.swing.overlay;

import java.awt.Shape;
import java.awt.geom.Point2D;
import net.imagej.display.ImageDisplay;
import net.imagej.display.OverlayView;
import net.imagej.overlay.AngleOverlay;
import net.imagej.overlay.Overlay;
import net.imagej.ui.swing.overlay.AbstractJHotDrawAdapter;
import net.imagej.ui.swing.overlay.IJCreationTool;
import net.imagej.ui.swing.overlay.JHotDrawAdapter;
import net.imagej.ui.swing.overlay.JHotDrawTool;
import net.imagej.ui.swing.tools.SwingAngleTool;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.geom.BezierPath;
import org.scijava.plugin.Plugin;
import org.scijava.tool.Tool;

@Plugin(type=JHotDrawAdapter.class, priority=95.0)
public class AngleJHotDrawAdapter
extends AbstractJHotDrawAdapter<AngleOverlay, AngleFigure> {
    @Override
    public boolean supports(Tool tool) {
        return tool instanceof SwingAngleTool;
    }

    @Override
    public boolean supports(Overlay overlay, Figure figure) {
        if (!(overlay instanceof AngleOverlay)) {
            return false;
        }
        return figure == null || figure instanceof AngleFigure;
    }

    public AngleOverlay createNewOverlay() {
        AngleOverlay overlay = new AngleOverlay(this.getContext());
        return overlay;
    }

    @Override
    public Figure createDefaultFigure() {
        AngleFigure figure = new AngleFigure();
        this.initDefaultSettings(figure);
        return figure;
    }

    @Override
    public void updateFigure(OverlayView overlayView, AngleFigure figure) {
        super.updateFigure(overlayView, figure);
        Overlay overlay = overlayView.getData();
        assert (overlay instanceof AngleOverlay);
        AngleOverlay angleOverlay = (AngleOverlay)overlay;
        double ptX = angleOverlay.getPoint1(0);
        double ptY = angleOverlay.getPoint1(1);
        figure.setEndPoint1(ptX, ptY);
        ptX = angleOverlay.getCenter(0);
        ptY = angleOverlay.getCenter(1);
        figure.setCenterPoint(ptX, ptY);
        ptX = angleOverlay.getPoint2(0);
        ptY = angleOverlay.getPoint2(1);
        figure.setEndPoint2(ptX, ptY);
    }

    @Override
    public void updateOverlay(AngleFigure figure, OverlayView overlayView) {
        int i;
        super.updateOverlay(figure, overlayView);
        Overlay overlay = overlayView.getData();
        assert (overlay instanceof AngleOverlay);
        AngleOverlay angleOverlay = (AngleOverlay)overlay;
        double[] ovPt = new double[angleOverlay.numDimensions()];
        Point2D.Double figPt = figure.getEndPoint1();
        ovPt[0] = figPt.x;
        ovPt[1] = figPt.y;
        for (i = 0; i < ovPt.length; ++i) {
            angleOverlay.setPoint1(ovPt[i], i);
        }
        figPt = figure.getCenterPoint();
        ovPt[0] = figPt.x;
        ovPt[1] = figPt.y;
        for (i = 0; i < ovPt.length; ++i) {
            angleOverlay.setCenter(ovPt[i], i);
        }
        figPt = figure.getEndPoint2();
        ovPt[0] = figPt.x;
        ovPt[1] = figPt.y;
        for (i = 0; i < ovPt.length; ++i) {
            angleOverlay.setPoint2(ovPt[i], i);
        }
        angleOverlay.update();
    }

    @Override
    public JHotDrawTool getCreationTool(ImageDisplay display) {
        return new IJCreationTool<AngleFigure>(display, this);
    }

    @Override
    public Shape toShape(AngleFigure figure) {
        throw new UnsupportedOperationException();
    }

    protected class AngleFigure
    extends BezierFigure {
        public AngleFigure() {
            this.addNode(new BezierPath.Node(6.0, 1.0));
            this.addNode(new BezierPath.Node(1.0, 1.0));
            this.addNode(new BezierPath.Node(1.0, 6.0));
            this.setConnectable(false);
        }

        public void setEndPoint1(double x, double y) {
            this.setPoint(0, this.point(x, y));
        }

        public void setCenterPoint(double x, double y) {
            this.setPoint(1, this.point(x, y));
        }

        public void setEndPoint2(double x, double y) {
            this.setPoint(2, this.point(x, y));
        }

        public Point2D.Double getEndPoint1() {
            return this.getPoint(0);
        }

        public Point2D.Double getCenterPoint() {
            return this.getPoint(1);
        }

        public Point2D.Double getEndPoint2() {
            return this.getPoint(2);
        }

        private Point2D.Double point(double x, double y) {
            return new Point2D.Double(x, y);
        }
    }
}

