/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3URI;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.janelia.saalfeldlab.n5.N5Exception;

public class AmazonS3Utils {
    public static final Pattern AWS_ENDPOINT_PATTERN = Pattern.compile("^(.+\\.)?(s3\\..*amazonaws\\.com)", 2);
    public static final Pattern S3_SCHEME = Pattern.compile("s3", 2);

    private AmazonS3Utils() {
    }

    public static String getS3Bucket(String uri) {
        try {
            return AmazonS3Utils.getS3Bucket(new URI(uri));
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String getS3Bucket(URI uri) {
        try {
            return new AmazonS3URI(uri).getBucket();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String path = uri.getPath().replaceFirst("^/", "");
            return path.split("/")[0];
        }
    }

    public static String getS3Key(String uri) {
        try {
            return AmazonS3Utils.getS3Key(new URI(uri));
        }
        catch (URISyntaxException uRISyntaxException) {
            return "";
        }
    }

    public static String getS3Key(URI uri) {
        try {
            String key = new AmazonS3URI(uri).getKey();
            return key == null ? "" : key;
        }
        catch (IllegalArgumentException key) {
            StringBuilder keyBuilder = new StringBuilder();
            String[] parts = uri.getPath().replaceFirst("^/", "").split("/");
            for (int i = 1; i < parts.length; ++i) {
                keyBuilder.append(parts[i]);
                if (i == parts.length - 1 && !uri.getPath().endsWith("/")) continue;
                keyBuilder.append("/");
            }
            return keyBuilder.toString();
        }
    }

    public static boolean areAnonymous(AWSCredentialsProvider credsProvider) {
        AWSCredentials creds = credsProvider.getCredentials();
        if (creds instanceof AnonymousAWSCredentials) {
            return true;
        }
        return creds.getAWSAccessKeyId() == null && creds.getAWSSecretKey() == null;
    }

    public static Regions getS3Region(AmazonS3URI uri, @Nullable String region) {
        Regions regionFromUri = AmazonS3Utils.parseRegion(uri.getRegion());
        return regionFromUri != null ? regionFromUri : AmazonS3Utils.parseRegion(region);
    }

    private static Regions parseRegion(String stringRegionFromUri) {
        return stringRegionFromUri != null ? Regions.fromName((String)stringRegionFromUri) : null;
    }

    public static AWSCredentialsProvider getS3Credentials(AWSCredentials s3Credentials, boolean s3Anonymous) {
        if (s3Credentials != null) {
            return new AWSStaticCredentialsProvider(s3Credentials);
        }
        if (!s3Anonymous) {
            return new DefaultAWSCredentialsProviderChain();
        }
        return null;
    }

    public static AmazonS3 createS3(String uri) {
        return AmazonS3Utils.createS3(uri, (String)null, null, null);
    }

    public static AmazonS3 createS3(String uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable String region) {
        return AmazonS3Utils.createS3(uri, s3Endpoint, s3Credentials, null, region);
    }

    public static AmazonS3 createS3(String uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable ClientConfiguration clientConfiguration, @Nullable String region) {
        try {
            AmazonS3URI s3Uri = new AmazonS3URI(uri);
            return AmazonS3Utils.createS3(s3Uri, s3Endpoint, s3Credentials, region);
        }
        catch (IllegalArgumentException e) {
            try {
                URI asURI = new URI(uri);
                URI endpointUri = new URI(asURI.getScheme(), asURI.getAuthority(), null, null, null);
                return AmazonS3Utils.createS3(AmazonS3Utils.getS3Bucket(uri), s3Credentials, new AwsClientBuilder.EndpointConfiguration(endpointUri.toString(), null), null);
            }
            catch (URISyntaxException e1) {
                throw new N5Exception("Could not create s3 client from uri: " + uri, e1);
            }
        }
    }

    public static AmazonS3 createS3(AmazonS3URI s3Uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable String region) {
        return AmazonS3Utils.createS3(s3Uri, s3Endpoint, s3Credentials, null, region);
    }

    public static AmazonS3 createS3(AmazonS3URI s3Uri, @Nullable String s3Endpoint, @Nullable AWSCredentialsProvider s3Credentials, @Nullable ClientConfiguration clientConfiguration, @Nullable String region) {
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = null;
        if (!S3_SCHEME.matcher(s3Uri.getURI().getScheme()).matches()) {
            endpointConfiguration = AmazonS3Utils.createEndpointConfiguration(s3Uri, s3Endpoint);
        }
        return AmazonS3Utils.createS3(s3Uri.getBucket(), s3Credentials, endpointConfiguration, clientConfiguration, AmazonS3Utils.getS3Region(s3Uri, region));
    }

    public static AwsClientBuilder.EndpointConfiguration createEndpointConfiguration(AmazonS3URI s3Uri, @Nullable String s3Endpoint) {
        Matcher matcher;
        AwsClientBuilder.EndpointConfiguration endpointConfiguration = s3Endpoint != null ? new AwsClientBuilder.EndpointConfiguration(s3Endpoint, null) : ((matcher = AWS_ENDPOINT_PATTERN.matcher(s3Uri.getURI().getHost())).find() ? new AwsClientBuilder.EndpointConfiguration(matcher.group(2), s3Uri.getRegion()) : new AwsClientBuilder.EndpointConfiguration(s3Uri.getURI().getHost(), s3Uri.getRegion()));
        return endpointConfiguration;
    }

    public static AmazonS3 createS3(String bucketName, @Nullable AWSCredentialsProvider credentialsProvider, @Nullable AwsClientBuilder.EndpointConfiguration endpointConfiguration, @Nullable Regions region) {
        return AmazonS3Utils.createS3(bucketName, credentialsProvider, endpointConfiguration, null, region);
    }

    public static AmazonS3 createS3(String bucketName, @Nullable AWSCredentialsProvider credentialsProvider, @Nullable AwsClientBuilder.EndpointConfiguration endpointConfiguration, @Nullable ClientConfiguration clientConfiguration, @Nullable Regions region) {
        boolean isAmazon = endpointConfiguration == null || AWS_ENDPOINT_PATTERN.matcher(endpointConfiguration.getServiceEndpoint()).find();
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        if (!isAmazon) {
            builder.withPathStyleAccessEnabled(Boolean.valueOf(true));
        }
        if (credentialsProvider == null) {
            builder.withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()));
        } else {
            builder.withCredentials(credentialsProvider);
        }
        if (clientConfiguration != null) {
            builder.withClientConfiguration(clientConfiguration);
        }
        if (endpointConfiguration != null) {
            builder.withEndpointConfiguration(endpointConfiguration);
        } else if (region != null) {
            builder.withRegion(region);
        } else {
            builder.withRegion("us-east-1");
        }
        AmazonS3 s3 = (AmazonS3)builder.build();
        if (!(credentialsProvider != null || s3.doesBucketExistV2(bucketName) && AmazonS3Utils.canListBucket(s3, bucketName))) {
            builder.withCredentials((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
            return (AmazonS3)builder.build();
        }
        return s3;
    }

    private static boolean canListBucket(AmazonS3 s3, String bucket) {
        ListObjectsV2Request request = new ListObjectsV2Request();
        request.setBucketName(bucket);
        request.setMaxKeys(Integer.valueOf(1));
        try {
            s3.listObjectsV2(request);
            return true;
        }
        catch (AmazonS3Exception e) {
            return false;
        }
    }
}

