/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5GenericStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonN5Writer;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.hdf5.HDF5Utils;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Reader;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Util;

public class N5HDF5Writer
extends N5HDF5Reader
implements GsonN5Writer {
    protected IHDF5Writer writer;

    public N5HDF5Writer(IHDF5Writer writer, boolean overrideBlockSize, GsonBuilder gsonBuilder, int ... defaultBlockSize) throws N5Exception {
        super((IHDF5Reader)writer, overrideBlockSize, gsonBuilder, defaultBlockSize);
        this.writer = writer;
        this.setAttribute("/", "n5", N5HDF5Reader.VERSION.toString());
    }

    public N5HDF5Writer(IHDF5Writer writer, boolean overrideBlockSize, int ... defaultBlockSize) throws IOException {
        this(writer, overrideBlockSize, new GsonBuilder(), defaultBlockSize);
    }

    public N5HDF5Writer(IHDF5Writer writer, int ... defaultBlockSize) throws IOException {
        this(writer, false, defaultBlockSize);
    }

    public N5HDF5Writer(String hdf5Path, boolean overrideBlockSize, GsonBuilder gsonBuilder, int ... defaultBlockSize) {
        this(N5HDF5Writer.openHdf5Writer(hdf5Path), overrideBlockSize, gsonBuilder, defaultBlockSize);
    }

    public N5HDF5Writer(String hdf5Path, boolean overrideBlockSize, int ... defaultBlockSize) {
        this(hdf5Path, overrideBlockSize, new GsonBuilder(), defaultBlockSize);
    }

    public N5HDF5Writer(String hdf5Path, int ... defaultBlockSize) {
        this(hdf5Path, false, defaultBlockSize);
    }

    @Override
    public void createDataset(String pathName, DatasetAttributes datasetAttributes) throws N5Exception {
        HDF5GenericStorageFeatures stringCompression;
        HDF5IntStorageFeatures uintCompression;
        HDF5IntStorageFeatures intCompression;
        HDF5FloatStorageFeatures floatCompression;
        DataType dataType = datasetAttributes.getDataType();
        Compression compression = datasetAttributes.getCompression();
        if (compression instanceof RawCompression) {
            floatCompression = HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION;
            intCompression = HDF5IntStorageFeatures.INT_NO_COMPRESSION;
            uintCompression = HDF5IntStorageFeatures.INT_NO_COMPRESSION_UNSIGNED;
            stringCompression = HDF5GenericStorageFeatures.GENERIC_NO_COMPRESSION;
        } else {
            floatCompression = HDF5FloatStorageFeatures.FLOAT_SHUFFLE_DEFLATE;
            intCompression = HDF5IntStorageFeatures.INT_AUTO_SCALING_DEFLATE;
            uintCompression = HDF5IntStorageFeatures.INT_AUTO_SCALING_DEFLATE_UNSIGNED;
            stringCompression = HDF5GenericStorageFeatures.GENERIC_DEFLATE;
        }
        if (this.writer.exists(pathName)) {
            this.writer.delete(pathName);
        }
        long[] hdf5Dimensions = (long[])datasetAttributes.getDimensions().clone();
        N5HDF5Writer.reorder(hdf5Dimensions);
        int[] hdf5BlockSize = (int[])datasetAttributes.getBlockSize().clone();
        N5HDF5Writer.reorder(hdf5BlockSize);
        switch (dataType) {
            case UINT8: {
                this.writer.uint8().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, uintCompression);
                break;
            }
            case UINT16: {
                this.writer.uint16().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, uintCompression);
                break;
            }
            case UINT32: {
                this.writer.uint32().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, uintCompression);
                break;
            }
            case UINT64: {
                this.writer.uint64().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, uintCompression);
                break;
            }
            case INT8: {
                this.writer.int8().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, intCompression);
                break;
            }
            case INT16: {
                this.writer.int16().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, intCompression);
                break;
            }
            case INT32: {
                this.writer.int32().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, intCompression);
                break;
            }
            case INT64: {
                this.writer.int64().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, intCompression);
                break;
            }
            case FLOAT32: {
                this.writer.float32().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, floatCompression);
                break;
            }
            case FLOAT64: {
                this.writer.float64().createMDArray(pathName, hdf5Dimensions, hdf5BlockSize, floatCompression);
                break;
            }
            case STRING: {
                this.writer.string().createMDArrayVL(pathName, hdf5Dimensions, hdf5BlockSize, stringCompression);
            }
            default: {
                return;
            }
        }
    }

    @Override
    public void createGroup(String pathName) throws N5Exception {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        String string = pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        if (this.writer.exists(pathName)) {
            if (!this.writer.isGroup(pathName)) {
                throw new N5Exception("Group " + pathName + " already exists and is not a group.");
            }
        } else {
            this.writer.object().createGroup(pathName);
        }
    }

    @Override
    public <T> void setAttribute(String pathName, String key, T attribute) throws N5Exception {
        String[] attributePathTokens;
        boolean isPath;
        boolean isRoot;
        String normalizedKey;
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        String finalPathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        String normalizedAttrPath = N5URI.normalizeAttributePath(key);
        String string = normalizedKey = normalizedAttrPath.isEmpty() ? "/" : normalizedAttrPath;
        if (this.writer.object().hasAttribute(finalPathName, normalizedKey)) {
            this.writer.object().deleteAttribute(finalPathName, normalizedKey);
        }
        if (isRoot = normalizedKey.equals("/")) {
            this.writer.object().getAllAttributeNames(finalPathName).forEach(it -> this.writer.object().deleteAttribute(finalPathName, it));
        }
        boolean bl = isPath = (attributePathTokens = normalizedKey.split("/")).length > 2 || attributePathTokens.length > 1 && !attributePathTokens[0].isEmpty() || N5URI.ARRAY_INDEX.asPredicate().test(normalizedKey) || N5HDF5Writer.containsEscapeCharacters(normalizedKey);
        if (isRoot || isPath) {
            this.writeAttributeAsJson(finalPathName, normalizedKey, attribute);
            return;
        }
        if (!this.writeHdf5Attribute(finalPathName, normalizedKey, attribute).booleanValue()) {
            this.writeAttributeAsJson(finalPathName, normalizedKey, attribute);
        }
    }

    private <T> Boolean writeHdf5Attribute(String pathName, String key, T attribute) {
        boolean written = true;
        if (attribute instanceof Boolean) {
            this.writer.bool().setAttr(pathName, key, ((Boolean)attribute).booleanValue());
        } else if (attribute instanceof Byte) {
            this.writer.int8().setAttr(pathName, key, ((Byte)attribute).byteValue());
        } else if (attribute instanceof Short) {
            this.writer.int16().setAttr(pathName, key, ((Short)attribute).shortValue());
        } else if (attribute instanceof Integer) {
            this.writer.int32().setAttr(pathName, key, ((Integer)attribute).intValue());
        } else if (attribute instanceof Long) {
            this.writer.int64().setAttr(pathName, key, ((Long)attribute).longValue());
        } else if (attribute instanceof Float) {
            this.writer.float32().setAttr(pathName, key, ((Float)attribute).floatValue());
        } else if (attribute instanceof Double) {
            this.writer.float64().setAttr(pathName, key, ((Double)attribute).doubleValue());
        } else if (attribute instanceof String) {
            this.writer.string().setAttr(pathName, key, (String)attribute);
        } else if (attribute instanceof byte[]) {
            this.writer.int8().setArrayAttr(pathName, key, (byte[])attribute);
        } else if (attribute instanceof byte[][]) {
            this.writer.int8().setMatrixAttr(pathName, key, (byte[][])attribute);
        } else if (attribute instanceof short[]) {
            this.writer.int16().setArrayAttr(pathName, key, (short[])attribute);
        } else if (attribute instanceof short[][]) {
            this.writer.int16().setMatrixAttr(pathName, key, (short[][])attribute);
        } else if (attribute instanceof int[]) {
            this.writer.int32().setArrayAttr(pathName, key, (int[])attribute);
        } else if (attribute instanceof int[][]) {
            this.writer.int32().setMatrixAttr(pathName, key, (int[][])attribute);
        } else if (attribute instanceof long[]) {
            this.writer.int64().setArrayAttr(pathName, key, (long[])attribute);
        } else if (attribute instanceof long[][]) {
            this.writer.int64().setMatrixAttr(pathName, key, (long[][])attribute);
        } else if (attribute instanceof float[]) {
            this.writer.float32().setArrayAttr(pathName, key, (float[])attribute);
        } else if (attribute instanceof float[][]) {
            this.writer.float32().setMatrixAttr(pathName, key, (float[][])attribute);
        } else if (attribute instanceof double[]) {
            this.writer.float64().setArrayAttr(pathName, key, (double[])attribute);
        } else if (attribute instanceof double[][]) {
            this.writer.float64().setMatrixAttr(pathName, key, (double[][])attribute);
        } else if (attribute instanceof String[]) {
            this.writer.string().setArrayAttr(pathName, key, (String[])attribute);
        } else {
            written = false;
        }
        return written;
    }

    private <T> void writeAttributeAsRootJson(String pathName, String key, T attribute) {
        this.writer.string().setAttr(pathName, key, this.gson.toJson(attribute));
    }

    private <T> void writeAttributeAsJson(String pathName, String key, T attribute) {
        JsonElement root = null;
        if (this.writer.object().hasAttribute(pathName, "N5_JSON_ROOT")) {
            root = JsonParser.parseString((String)this.writer.string().getAttr(pathName, "N5_JSON_ROOT"));
        }
        root = GsonUtils.insertAttribute(root, N5URI.normalizeAttributePath(key), attribute, this.gson);
        this.writer.string().setAttr(pathName, "N5_JSON_ROOT", this.gson.toJson(root));
    }

    @Override
    public void setAttributes(String pathName, Map<String, ?> attributes) throws N5Exception {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        for (Map.Entry<String, ?> attribute : attributes.entrySet()) {
            String key = attribute.getKey();
            Object value = attribute.getValue();
            this.setAttribute(pathName, key, value);
        }
    }

    @Override
    public void setAttributes(String groupPath, JsonElement attributes) throws N5Exception {
        this.setAttribute(groupPath, "/", attributes);
    }

    @Override
    public void setDatasetAttributes(String pathName, DatasetAttributes datasetAttributes) throws N5Exception {
        throw new UnsupportedOperationException("HDF5 datasets cannot be reshaped.");
    }

    @Override
    public boolean removeAttribute(String pathName, String key) throws N5Exception {
        JsonElement jsonRoot;
        String normalizedKey;
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        String string = pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        if (!this.exists(pathName)) {
            return false;
        }
        String normalizedAttrPath = N5URI.normalizeAttributePath(key);
        String string2 = normalizedKey = normalizedAttrPath.isEmpty() ? "/" : normalizedAttrPath;
        if (this.writer.object().hasAttribute(pathName, normalizedKey)) {
            this.writer.object().deleteAttribute(pathName, normalizedKey);
            return true;
        }
        if (this.writer.object().hasAttribute(pathName, "N5_JSON_ROOT") && GsonUtils.removeAttribute(jsonRoot = this.getAttribute(pathName, "N5_JSON_ROOT", JsonElement.class), N5URI.normalizeAttributePath(normalizedKey)) != null) {
            this.writer.string().setAttr(pathName, "N5_JSON_ROOT", this.gson.toJson(jsonRoot));
            return true;
        }
        return false;
    }

    @Override
    public <T> T removeAttribute(String pathName, String key, Class<T> cls) throws N5Exception {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        String string = pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        if (!this.exists(pathName)) {
            return null;
        }
        String normalizedAttrPath = N5URI.normalizeAttributePath(key);
        String normalizedKey = normalizedAttrPath.isEmpty() || normalizedAttrPath.equals("N5_JSON_ROOT") ? "/" : normalizedAttrPath;
        T removedAttribute = this.getAttribute(pathName, normalizedKey, cls);
        if (removedAttribute != null) {
            JsonElement jsonRoot;
            if (this.writer.object().hasAttribute(pathName, normalizedKey)) {
                this.writer.object().deleteAttribute(pathName, normalizedKey);
            }
            if (this.writer.object().hasAttribute(pathName, "N5_JSON_ROOT") && GsonUtils.removeAttribute(jsonRoot = this.getAttribute(pathName, "N5_JSON_ROOT", JsonElement.class), N5URI.normalizeAttributePath(normalizedKey), cls, this.gson) != null) {
                this.writer.string().setAttr(pathName, "N5_JSON_ROOT", this.gson.toJson(jsonRoot));
            }
        }
        return removedAttribute;
    }

    @Override
    public boolean removeAttributes(String pathName, List<String> attributes) throws N5Exception {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        String string = pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        if (!this.exists(pathName)) {
            return false;
        }
        JsonElement jsonRoot = null;
        boolean removed = false;
        for (String attribute : attributes) {
            String normalizedAttrPath = N5URI.normalizeAttributePath(attribute);
            String string2 = attribute = normalizedAttrPath.isEmpty() || normalizedAttrPath.equals("N5_JSON_ROOT") ? "/" : normalizedAttrPath;
            if (this.writer.object().hasAttribute(pathName, attribute)) {
                this.writer.object().deleteAttribute(pathName, attribute);
                removed = true;
                continue;
            }
            if (this.writer.object().hasAttribute(pathName, "N5_JSON_ROOT") && jsonRoot == null) {
                jsonRoot = this.getAttribute(pathName, "N5_JSON_ROOT", JsonElement.class);
            }
            if (jsonRoot == null) continue;
            removed |= GsonUtils.removeAttribute(jsonRoot, N5URI.normalizeAttributePath(attribute)) != null;
        }
        if (removed && jsonRoot != null) {
            this.writer.string().setAttr(pathName, "N5_JSON_ROOT", this.gson.toJson(jsonRoot));
        }
        return removed;
    }

    @Override
    public <T> void writeBlock(String pathName, DatasetAttributes datasetAttributes, DataBlock<T> dataBlock) throws N5Exception {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        long[] hdf5DataBlockSize = N5HDF5Util.reorderToLong(dataBlock.getSize());
        long[] hdf5Offset = N5HDF5Util.reorderMultiplyToLong(dataBlock.getGridPosition(), datasetAttributes.getBlockSize());
        if (datasetAttributes.getDataType() == DataType.STRING) {
            MDArray arr = new MDArray((Object[])((String[])dataBlock.getData()), hdf5DataBlockSize);
            this.writer.string().writeMDArrayBlockWithOffset(pathName, arr, hdf5Offset);
            return;
        }
        try (N5HDF5Util.OpenDataSetCache.OpenDataSet dataset = this.openDataSetCache.get(pathName);){
            long memorySpaceId = H5.H5Screate_simple((int)hdf5DataBlockSize.length, (long[])hdf5DataBlockSize, null);
            long fileSpaceId = H5.H5Dget_space((long)dataset.dataSetId);
            H5.H5Sselect_hyperslab((long)fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])hdf5Offset, null, (long[])hdf5DataBlockSize, null);
            long memTypeId = N5HDF5Util.memTypeId(datasetAttributes.getDataType());
            H5.H5Dwrite((long)dataset.dataSetId, (long)memTypeId, (long)memorySpaceId, (long)fileSpaceId, (long)HDF5Constants.H5P_DEFAULT, dataBlock.getData());
            H5.H5Sclose((long)fileSpaceId);
            H5.H5Sclose((long)memorySpaceId);
        }
    }

    @Override
    public boolean deleteBlock(String pathName, long ... gridPosition) throws N5Exception {
        if (pathName.equals("")) {
            pathName = "/";
        }
        DatasetAttributes datasetAttributes = this.getDatasetAttributes(pathName);
        DataType dataType = datasetAttributes.getDataType();
        switch (dataType) {
            case UINT8: 
            case UINT16: 
            case UINT32: 
            case UINT64: 
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT32: 
            case FLOAT64: {
                DataBlock<?> empty = dataType.createDataBlock(datasetAttributes.getBlockSize(), gridPosition);
                this.writeBlock(pathName, datasetAttributes, empty);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean remove() {
        this.openDataSetCache.close();
        File file = this.writer.file().getFile();
        this.writer.close();
        return file.delete();
    }

    @Override
    public boolean remove(String pathName) throws N5Exception {
        if (pathName.equals("")) {
            pathName = "/";
        }
        this.openDataSetCache.remove(pathName);
        this.writer.delete(pathName);
        return !this.writer.exists(pathName);
    }

    private static IHDF5Writer openHdf5Writer(String hdf5Path) {
        String normalHdf5Path = N5HDF5Writer.normalizeHdf5PathLocation(hdf5Path);
        if (Files.exists(Paths.get(normalHdf5Path, new String[0]), new LinkOption[0]) && !HDF5Utils.isHDF5(normalHdf5Path)) {
            throw new N5Exception("File exists at " + normalHdf5Path + " and is not a valid HDF5 file");
        }
        try {
            return HDF5Factory.open((String)normalHdf5Path);
        }
        catch (HDF5Exception e) {
            throw new N5Exception.N5IOException("Cannot open HDF5 Writer", new IOException(e));
        }
    }
}

