/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.CompressionAdapter;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.FileSystemKeyValueAccess;
import org.janelia.saalfeldlab.n5.GsonN5Reader;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.StringDataBlock;
import org.janelia.saalfeldlab.n5.hdf5.N5HDF5Util;
import org.scijava.util.VersionUtils;

public class N5HDF5Reader
implements GsonN5Reader,
Closeable {
    protected final Gson gson;
    protected static final String N5_JSON_ROOT_KEY = "N5_JSON_ROOT";
    protected static final FileSystemKeyValueAccess FILE_SYSTEM_KEY_VALUE_ACCESS = new FileSystemKeyValueAccess(FileSystems.getDefault());
    public static final N5Reader.Version VERSION = new N5Reader.Version(VersionUtils.getVersionFromPOM(N5HDF5Reader.class, (String)"org.janelia.saalfeldlab", (String)"n5-hdf5"));
    protected final IHDF5Reader reader;
    protected final int[] defaultBlockSize;
    protected boolean overrideBlockSize = false;
    protected final N5HDF5Util.OpenDataSetCache openDataSetCache;

    public N5HDF5Reader(IHDF5Reader reader, boolean overrideBlockSize, GsonBuilder gsonBuilder, int ... defaultBlockSize) throws N5Exception {
        gsonBuilder.registerTypeAdapter(DataType.class, (Object)new DataType.JsonAdapter());
        gsonBuilder.registerTypeHierarchyAdapter(Compression.class, (Object)CompressionAdapter.getJsonAdapter());
        gsonBuilder.disableHtmlEscaping();
        this.gson = gsonBuilder.create();
        this.reader = reader;
        N5Reader.Version version = this.getVersion();
        if (!VERSION.isCompatible(version)) {
            reader.close();
            throw new N5Exception("Incompatible N5-HDF5 version " + version + " (this is " + VERSION + ").");
        }
        this.overrideBlockSize = overrideBlockSize;
        this.defaultBlockSize = defaultBlockSize == null ? new int[0] : defaultBlockSize;
        this.openDataSetCache = new N5HDF5Util.OpenDataSetCache(reader);
    }

    public N5HDF5Reader(IHDF5Reader reader, boolean overrideBlockSize, int ... defaultBlockSize) {
        this(reader, overrideBlockSize, new GsonBuilder(), defaultBlockSize);
    }

    public N5HDF5Reader(IHDF5Reader reader, int ... defaultBlockSize) {
        this(reader, false, defaultBlockSize);
    }

    public N5HDF5Reader(String hdf5Path, boolean overrideBlockSize, GsonBuilder gsonBuilder, int ... defaultBlockSize) {
        this(N5HDF5Reader.openHdf5Reader(hdf5Path), overrideBlockSize, gsonBuilder, defaultBlockSize);
    }

    public N5HDF5Reader(String hdf5Path, boolean overrideBlockSize, int ... defaultBlockSize) {
        this(hdf5Path, overrideBlockSize, new GsonBuilder(), defaultBlockSize);
    }

    public N5HDF5Reader(String hdf5Path, int ... defaultBlockSize) {
        this(hdf5Path, false, defaultBlockSize);
    }

    @Override
    public Gson getGson() {
        return this.gson;
    }

    @Override
    public boolean exists(String pathName) {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        return this.reader.exists(pathName);
    }

    @Override
    public String[] list(String pathName) throws N5Exception {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        try {
            List members = this.reader.object().getGroupMembers(pathName);
            return members.toArray(new String[members.size()]);
        }
        catch (Exception e) {
            throw new N5Exception(e);
        }
    }

    private static IHDF5Reader openHdf5Reader(String hdf5Path) {
        try {
            return HDF5Factory.openForReading((String)N5HDF5Reader.normalizeHdf5PathLocation(hdf5Path));
        }
        catch (HDF5Exception e) {
            throw new N5Exception.N5IOException("Cannot open HDF5 Reader", new IOException(e));
        }
    }

    protected static String normalizeHdf5PathLocation(String hdf5Path) {
        try {
            return Paths.get(FILE_SYSTEM_KEY_VALUE_ACCESS.uri(hdf5Path)).toString();
        }
        catch (URISyntaxException e) {
            return hdf5Path;
        }
    }

    protected static boolean containsEscapeCharacters(String normalizedKey) {
        return normalizedKey.matches(".*(\\\\/|\\\\\\[).*");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T getAttribute(String pathName, String key, Type type) throws N5Exception {
        Object hdf5Attribute;
        String normalizedKey;
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        String normalizedAttrPath = N5URI.normalizeAttributePath(key);
        String string = normalizedKey = normalizedAttrPath.isEmpty() ? "/" : normalizedAttrPath;
        if (!this.reader.exists(pathName)) {
            return null;
        }
        boolean isDataset = this.datasetExists(pathName);
        if (isDataset) {
            if (normalizedKey.equals("dimensions") && type.getTypeName().equals(long[].class.getTypeName())) {
                HDF5DataSetInformation datasetInfo = this.reader.object().getDataSetInformation(pathName);
                long[] dimensions = datasetInfo.getDimensions();
                N5HDF5Reader.reorder(dimensions);
                return (T)dimensions;
            }
            if (normalizedKey.equals("blockSize") && type.getTypeName().equals(int[].class.getTypeName())) {
                int[] blockSize;
                HDF5DataSetInformation datasetInfo = this.reader.object().getDataSetInformation(pathName);
                long[] dimensions = datasetInfo.getDimensions();
                int[] nArray = blockSize = this.overrideBlockSize ? null : datasetInfo.tryGetChunkSizes();
                if (blockSize != null) {
                    N5HDF5Reader.reorder(blockSize);
                    return (T)blockSize;
                } else {
                    blockSize = new int[dimensions.length];
                    for (int i = 0; i < blockSize.length; ++i) {
                        blockSize[i] = i >= this.defaultBlockSize.length || this.defaultBlockSize[i] <= 0 ? (int)dimensions[i] : this.defaultBlockSize[i];
                    }
                }
                return (T)blockSize;
            }
            if (normalizedKey.equals("dataType") && type.getTypeName().equals(DataType.class.getTypeName())) {
                HDF5DataSetInformation datasetInfo = this.reader.object().getDataSetInformation(pathName);
                return (T)((Object)N5HDF5Reader.getDataType(datasetInfo));
            }
            if (normalizedKey.equals("compression") && type.getTypeName().equals(Compression.class.getTypeName())) {
                return (T)new RawCompression();
            }
        }
        if (!this.reader.object().hasAttribute(pathName, normalizedKey) || normalizedKey.equals(N5_JSON_ROOT_KEY)) {
            JsonElement attribute;
            JsonElement gsonAttribute;
            boolean hasN5JsonRoot = this.reader.object().hasAttribute(pathName, N5_JSON_ROOT_KEY);
            if (!hasN5JsonRoot) {
                if (!normalizedKey.equals("/")) {
                    return null;
                }
                gsonAttribute = null;
            } else {
                String n5JsonRoot = this.reader.string().getAttr(pathName, N5_JSON_ROOT_KEY);
                JsonElement root = JsonParser.parseString((String)n5JsonRoot);
                String jsonKey = normalizedKey.equals(N5_JSON_ROOT_KEY) ? "/" : normalizedKey;
                gsonAttribute = GsonUtils.getAttribute(root, jsonKey);
            }
            if (normalizedKey.equals("/")) {
                List allAttributeNames = this.reader.object().getAllAttributeNames(pathName);
                if (allAttributeNames.size() > 1 || gsonAttribute == null || isDataset) {
                    JsonObject attributeObj;
                    if (gsonAttribute != null && gsonAttribute.isJsonObject()) {
                        attributeObj = gsonAttribute.getAsJsonObject();
                    } else {
                        attributeObj = new JsonObject();
                        if (gsonAttribute != null) {
                            attributeObj.add(N5_JSON_ROOT_KEY, gsonAttribute);
                        }
                    }
                    for (String attr : allAttributeNames) {
                        if (attr.equals(N5_JSON_ROOT_KEY)) continue;
                        attributeObj.add(attr, this.gson.toJsonTree((Object)this.getAttribute(pathName, attr, JsonElement.class)));
                    }
                    if (isDataset) {
                        DatasetAttributes datasetAttributes = this.getDatasetAttributes(pathName);
                        attributeObj.add("dimensions", this.gson.toJsonTree((Object)datasetAttributes.getDimensions()));
                        attributeObj.add("blockSize", this.gson.toJsonTree((Object)datasetAttributes.getBlockSize()));
                        attributeObj.add("dataType", this.gson.toJsonTree((Object)datasetAttributes.getDataType()));
                        attributeObj.add("compression", this.gson.toJsonTree((Object)datasetAttributes.getCompression()));
                    }
                    attribute = attributeObj;
                } else {
                    attribute = gsonAttribute;
                }
            } else {
                attribute = gsonAttribute;
            }
            try {
                return GsonUtils.parseAttributeElement(attribute, this.gson, type);
            }
            catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
                throw new N5Exception.N5ClassCastException(e);
            }
        }
        HDF5DataTypeInformation attributeInfo = this.reader.object().getAttributeInformation(pathName, normalizedKey);
        Class clazz = attributeInfo.tryGetJavaType();
        if (clazz.isAssignableFrom(long[].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? this.reader.int64().getArrayAttr(pathName, key) : this.reader.uint64().getArrayAttr(pathName, key);
        } else if (clazz.isAssignableFrom(long[][].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)this.reader.int64().getMatrixAttr(pathName, key) : (Object)this.reader.uint64().getMatrixAttr(pathName, key);
        } else if (clazz.isAssignableFrom(int[].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)this.reader.int32().getArrayAttr(pathName, key) : (Object)this.reader.uint32().getArrayAttr(pathName, key);
        } else if (clazz.isAssignableFrom(int[][].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)this.reader.int32().getMatrixAttr(pathName, key) : (Object)this.reader.uint32().getMatrixAttr(pathName, key);
        } else if (clazz.isAssignableFrom(short[].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)this.reader.int16().getArrayAttr(pathName, key) : (Object)this.reader.uint16().getArrayAttr(pathName, key);
        } else if (clazz.isAssignableFrom(short[][].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)this.reader.int16().getMatrixAttr(pathName, key) : (Object)this.reader.uint16().getMatrixAttr(pathName, key);
        } else if (clazz.isAssignableFrom(byte[].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)this.reader.int8().getArrayAttr(pathName, key) : (Object)this.reader.uint8().getArrayAttr(pathName, key);
        } else if (clazz.isAssignableFrom(byte[][].class)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)this.reader.int8().getMatrixAttr(pathName, key) : (Object)this.reader.uint8().getMatrixAttr(pathName, key);
        } else if (clazz.isAssignableFrom(double[].class)) {
            hdf5Attribute = this.reader.float64().getArrayAttr(pathName, key);
        } else if (clazz.isAssignableFrom(double[][].class)) {
            hdf5Attribute = this.reader.float64().getMatrixAttr(pathName, key);
        } else if (clazz.isAssignableFrom(float[].class)) {
            hdf5Attribute = this.reader.float32().getArrayAttr(pathName, key);
        } else if (clazz.isAssignableFrom(float[][].class)) {
            hdf5Attribute = this.reader.float32().getMatrixAttr(pathName, key);
        } else if (clazz.isAssignableFrom(String[].class)) {
            hdf5Attribute = this.reader.string().getArrayAttr(pathName, normalizedKey);
        } else if (clazz.isAssignableFrom(Long.TYPE)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)new Long(this.reader.int64().getAttr(pathName, normalizedKey)) : (Object)new Long(this.reader.uint64().getAttr(pathName, normalizedKey));
        } else if (clazz.isAssignableFrom(Integer.TYPE)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)new Integer(this.reader.int32().getAttr(pathName, normalizedKey)) : (Object)new Integer(this.reader.uint32().getAttr(pathName, normalizedKey));
        } else if (clazz.isAssignableFrom(Short.TYPE)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)new Short(this.reader.int16().getAttr(pathName, normalizedKey)) : (Object)new Short(this.reader.uint16().getAttr(pathName, normalizedKey));
        } else if (clazz.isAssignableFrom(Byte.TYPE)) {
            hdf5Attribute = attributeInfo.isSigned() ? (Object)new Byte(this.reader.int8().getAttr(pathName, normalizedKey)) : (Object)new Byte(this.reader.uint8().getAttr(pathName, normalizedKey));
        } else if (clazz.isAssignableFrom(Double.TYPE)) {
            hdf5Attribute = new Double(this.reader.float64().getAttr(pathName, normalizedKey));
        } else if (clazz.isAssignableFrom(Float.TYPE)) {
            hdf5Attribute = new Float(this.reader.float32().getAttr(pathName, normalizedKey));
        } else if (clazz.isAssignableFrom(Boolean.TYPE)) {
            hdf5Attribute = this.reader.bool().getAttr(pathName, normalizedKey);
        } else {
            if (clazz.isAssignableFrom(String.class)) {
                String attributeString;
                block78: {
                    Class typeClass;
                    attributeString = attributeInfo.isArrayType() ? this.gson.toJson((Object)this.reader.string().getArrayAttr(pathName, normalizedKey)) : this.reader.string().getAttr(pathName, normalizedKey);
                    try {
                        typeClass = (Class)type;
                    }
                    catch (ClassCastException e) {
                        return (T)attributeString;
                    }
                    if (typeClass.isAssignableFrom(String.class)) {
                        if (!this.gson.serializeNulls() || !attributeString.equals("null")) return (T)attributeString;
                        return null;
                    }
                    if (!typeClass.isAssignableFrom(JsonElement.class)) return (T)this.gson.fromJson(attributeString, type);
                    if (!attributeString.isEmpty()) break block78;
                    return (T)this.gson.fromJson("\"" + attributeString + "\"", type);
                    {
                        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
                            throw new N5Exception.N5ClassCastException(e);
                        }
                    }
                }
                try {
                    return (T)this.gson.fromJson(attributeString, type);
                }
                catch (JsonSyntaxException e) {
                    return (T)this.gson.fromJson("\"" + attributeString + "\"", type);
                }
            }
            hdf5Attribute = null;
        }
        if (!(type instanceof Class)) return (T)hdf5Attribute;
        Class typeClass = (Class)type;
        JsonElement jsonTree = this.gson.toJsonTree(hdf5Attribute);
        if (typeClass.isAssignableFrom(JsonElement.class)) {
            return (T)jsonTree;
        }
        if (typeClass.isAssignableFrom(String.class)) {
            return (T)this.gson.toJson(hdf5Attribute);
        }
        try {
            return GsonUtils.parseAttributeElement(jsonTree, this.gson, type);
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
    }

    @Override
    public URI getURI() {
        return this.reader.file().getFile().toURI();
    }

    @Override
    public <T> T getAttribute(String pathName, String key, Class<T> clazz) throws N5Exception {
        return this.getAttribute(pathName, key, (Type)clazz);
    }

    @Override
    public JsonElement getAttributes(String pathName) throws N5Exception {
        return this.getAttribute(pathName, "/", JsonElement.class);
    }

    protected static DataType getDataType(HDF5DataSetInformation datasetInfo) {
        HDF5DataTypeInformation typeInfo = datasetInfo.getTypeInformation();
        Class type = typeInfo.tryGetJavaType();
        if (type.isAssignableFrom(Long.TYPE)) {
            if (typeInfo.isSigned()) {
                return DataType.INT64;
            }
            return DataType.UINT64;
        }
        if (type.isAssignableFrom(Integer.TYPE)) {
            if (typeInfo.isSigned()) {
                return DataType.INT32;
            }
            return DataType.UINT32;
        }
        if (type.isAssignableFrom(Short.TYPE)) {
            if (typeInfo.isSigned()) {
                return DataType.INT16;
            }
            return DataType.UINT16;
        }
        if (type.isAssignableFrom(Byte.TYPE)) {
            if (typeInfo.isSigned()) {
                return DataType.INT8;
            }
            return DataType.UINT8;
        }
        if (type.isAssignableFrom(Double.TYPE)) {
            return DataType.FLOAT64;
        }
        if (type.isAssignableFrom(Float.TYPE)) {
            return DataType.FLOAT32;
        }
        if (type.isAssignableFrom(String.class)) {
            return DataType.STRING;
        }
        System.err.println("Datasets of type " + typeInfo + " not yet implemented.");
        return null;
    }

    protected static void reorder(long[] array) {
        int max = array.length - 1;
        for (int i = (max - 1) / 2; i >= 0; --i) {
            int j = max - i;
            long a = array[i];
            array[i] = array[j];
            array[j] = a;
        }
    }

    protected static void reorder(int[] array) {
        int max = array.length - 1;
        for (int i = (max - 1) / 2; i >= 0; --i) {
            int j = max - i;
            int a = array[i];
            array[i] = array[j];
            array[j] = a;
        }
    }

    protected static void cropBlockSize(long[] gridPosition, long[] dimensions, int[] blockSize, int[] croppedBlockSize, long[] offset) {
        for (int d = 0; d < dimensions.length; ++d) {
            offset[d] = gridPosition[d] * (long)blockSize[d];
            croppedBlockSize[d] = (int)Math.min((long)blockSize[d], dimensions[d] - offset[d]);
        }
    }

    @Override
    public DatasetAttributes getDatasetAttributes(String pathName) {
        int[] blockSize;
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        String string = pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        if (!this.datasetExists(pathName)) {
            return null;
        }
        HDF5DataSetInformation datasetInfo = this.reader.object().getDataSetInformation(pathName);
        long[] dimensions = datasetInfo.getDimensions();
        N5HDF5Reader.reorder(dimensions);
        int[] nArray = blockSize = this.overrideBlockSize ? null : datasetInfo.tryGetChunkSizes();
        if (blockSize != null) {
            N5HDF5Reader.reorder(blockSize);
        } else {
            blockSize = new int[dimensions.length];
            for (int i = 0; i < blockSize.length; ++i) {
                blockSize[i] = i >= this.defaultBlockSize.length || this.defaultBlockSize[i] <= 0 ? (int)dimensions[i] : this.defaultBlockSize[i];
            }
        }
        return new DatasetAttributes(dimensions, blockSize, N5HDF5Reader.getDataType(datasetInfo), new RawCompression());
    }

    @Override
    public DataBlock<?> readBlock(String pathName, DatasetAttributes datasetAttributes, long ... gridPosition) throws N5Exception {
        long memTypeId;
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        int n = datasetAttributes.getDimensions().length;
        int[] croppedBlockSize = new int[n];
        long[] hdf5Offset = new long[n];
        N5HDF5Reader.cropBlockSize(gridPosition, datasetAttributes.getDimensions(), datasetAttributes.getBlockSize(), croppedBlockSize, hdf5Offset);
        long[] hdf5CroppedBlockSize = N5HDF5Util.reorderToLong(croppedBlockSize);
        N5HDF5Reader.reorder(hdf5Offset);
        if (datasetAttributes.getDataType() == DataType.STRING) {
            int[] intHdf5CroppedBlockSize = Arrays.stream(hdf5CroppedBlockSize).mapToInt(i -> (int)i).toArray();
            MDArray data = this.reader.string().readMDArrayBlockWithOffset(normalizedPathName, intHdf5CroppedBlockSize, hdf5Offset);
            return new StringDataBlock(croppedBlockSize, gridPosition, (String[])data.getAsFlatArray());
        }
        DataType dataType = datasetAttributes.getDataType();
        try {
            memTypeId = N5HDF5Util.memTypeId(dataType);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        DataBlock<?> block = dataType.createDataBlock(croppedBlockSize, (long[])gridPosition.clone());
        try (N5HDF5Util.OpenDataSetCache.OpenDataSet dataset = this.openDataSetCache.get(pathName);){
            long memorySpaceId = H5.H5Screate_simple((int)hdf5CroppedBlockSize.length, (long[])hdf5CroppedBlockSize, null);
            long fileSpaceId = H5.H5Dget_space((long)dataset.dataSetId);
            H5.H5Sselect_hyperslab((long)fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])hdf5Offset, null, (long[])hdf5CroppedBlockSize, null);
            H5.H5Dread((long)dataset.dataSetId, (long)memTypeId, (long)memorySpaceId, (long)fileSpaceId, (long)this.openDataSetCache.numericConversionXferPropertyListID, block.getData());
            H5.H5Sclose((long)fileSpaceId);
            H5.H5Sclose((long)memorySpaceId);
        }
        return block;
    }

    @Override
    public boolean datasetExists(String pathName) {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        pathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        return this.reader.exists(pathName) && this.reader.object().isDataSet(pathName);
    }

    @Override
    public Map<String, Class<?>> listAttributes(String pathName) throws N5Exception {
        String normalizedPathName = N5URI.normalizeGroupPath(pathName);
        String finalPathName = normalizedPathName.isEmpty() ? "/" : normalizedPathName;
        HashMap attributes = new HashMap();
        if (!this.exists(normalizedPathName)) {
            return attributes;
        }
        this.reader.object().getAttributeNames(finalPathName).forEach(attributeName -> {
            Class clazz = this.reader.object().getAttributeInformation(finalPathName, attributeName).tryGetJavaType();
            boolean isN5JsonRoot = attributeName.equals(N5_JSON_ROOT_KEY);
            if (clazz.isAssignableFrom(String.class)) {
                try {
                    String value = this.reader.string().getAttr(finalPathName, attributeName);
                    JsonElement element = JsonParser.parseString((String)value);
                    if (isN5JsonRoot && element.isJsonObject()) {
                        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
                            JsonElement rootElement = (JsonElement)entry.getValue();
                            Class rootClass = rootElement.isJsonArray() ? Object[].class : (!rootElement.isJsonPrimitive() ? Object.class : GsonUtils.classForJsonPrimitive(rootElement.getAsJsonPrimitive()));
                            attributes.put((String)entry.getKey(), rootClass);
                        }
                    } else if (element.isJsonArray()) {
                        clazz = Object[].class;
                    } else if (!element.isJsonPrimitive()) {
                        clazz = Object.class;
                    }
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
            }
            if (!isN5JsonRoot) {
                attributes.put((String)attributeName, clazz);
            }
        });
        return attributes;
    }

    @Override
    public void close() {
        this.openDataSetCache.close();
        this.reader.close();
    }

    public File getFilename() {
        return this.reader.file().getFile();
    }

    public int[] getDefaultBlockSizeCopy() {
        return (int[])this.defaultBlockSize.clone();
    }

    public boolean doesOverrideBlockSize() {
        return this.overrideBlockSize;
    }

    public String toString() {
        return String.format("%s[file=%s]", this.getClass().getSimpleName(), this.reader.file().getFile());
    }
}

