/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.util;

import java.util.function.Function;
import java.util.stream.IntStream;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.cache.CacheLoader;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;

public class IntervalKeyLoaderAsLongKeyLoader<A>
implements CacheLoader<Long, Cell<A>> {
    private final CellGrid grid;
    private final Function<Interval, A> intervalKeyLoader;

    public IntervalKeyLoaderAsLongKeyLoader(CellGrid grid, Function<Interval, A> intervalKeyLoader) {
        this.grid = grid;
        this.intervalKeyLoader = intervalKeyLoader;
    }

    @Override
    public Cell<A> get(Long key) {
        long index = key;
        int n = this.grid.numDimensions();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        this.grid.getCellDimensions(index, cellMin, cellDims);
        long[] cellMax = IntStream.range(0, n).mapToLong(d -> cellMin[d] + (long)cellDims[d] - 1L).toArray();
        A result = this.intervalKeyLoader.apply((Interval)new FinalInterval(cellMin, cellMax));
        return new Cell(cellDims, cellMin, result);
    }
}

