/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.supplier.biop;

import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.viewer.Interpolation;
import ch.epfl.biop.bdv.select.SourceSelectorBehaviour;
import java.awt.Font;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform3D;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.navigate.RayCastPositionerSliderAdder;
import sc.fiji.bdvpg.bdv.navigate.SourceNavigatorSliderAdder;
import sc.fiji.bdvpg.bdv.navigate.TimepointAdapterAdder;
import sc.fiji.bdvpg.bdv.overlay.SourceNameOverlayAdder;
import sc.fiji.bdvpg.bdv.supplier.BdvSupplierHelper;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.biop.BiopSerializableBdvOptions;

public class BiopBdvSupplier
implements IBdvSupplier {
    public final BiopSerializableBdvOptions sOptions;

    public BiopBdvSupplier(BiopSerializableBdvOptions sOptions) {
        this.sOptions = sOptions;
    }

    public BiopBdvSupplier() {
        this.sOptions = BiopSerializableBdvOptions.options();
    }

    public BdvHandle get() {
        BdvOptions options = this.sOptions.getBdvOptions();
        ArrayImg dummyImg = ArrayImgs.bytes((long[])new long[]{2L, 2L, 2L});
        options = options.sourceTransform(new AffineTransform3D());
        BdvStackSource bss = BdvFunctions.show((RandomAccessibleInterval)dummyImg, (String)"dummy", (BdvOptions)options);
        BdvHandle bdvh = bss.getBdvHandle();
        if (this.sOptions.interpolate) {
            bdvh.getViewerPanel().setInterpolation(Interpolation.NLINEAR);
        }
        bdvh.getViewerPanel().state().removeSource(bdvh.getViewerPanel().state().getCurrentSource());
        bdvh.getViewerPanel().setNumTimepoints(this.sOptions.numTimePoints);
        BdvSupplierHelper.addSourcesDragAndDrop(bdvh);
        SourceSelectorBehaviour ssb = BdvSupplierHelper.addEditorMode(bdvh, "");
        bdvh.getSplitPanel().setCollapsed(false);
        JPanel editorModeToggle = new JPanel();
        JButton editorToggle = new JButton("Editor Mode");
        editorToggle.addActionListener(e -> {
            if (ssb.isEnabled()) {
                ssb.disable();
                editorToggle.setText("Editor Mode 'E'");
            } else {
                ssb.enable();
                editorToggle.setText("Navigation Mode 'E'");
            }
        });
        editorModeToggle.add(editorToggle);
        JButton nameToggle = new JButton("Display sources name");
        AtomicBoolean nameOverlayEnabled = new AtomicBoolean();
        nameOverlayEnabled.set(true);
        SourceNameOverlayAdder nameOverlayAdder = new SourceNameOverlayAdder(bdvh, new Font(this.sOptions.font, 0, this.sOptions.fontSize));
        nameToggle.addActionListener(e -> {
            if (nameOverlayEnabled.get()) {
                nameOverlayEnabled.set(false);
                nameToggle.setText("Display sources names");
                nameOverlayAdder.removeFromBdv();
            } else {
                nameOverlayEnabled.set(true);
                nameToggle.setText("Hide sources name");
                nameOverlayAdder.addToBdv();
            }
        });
        editorModeToggle.add(nameToggle);
        SwingUtilities.invokeLater(() -> {
            nameOverlayAdder.run();
            BdvHandleHelper.addCenterCross((BdvHandle)bdvh);
            new RayCastPositionerSliderAdder(bdvh).run();
            new SourceNavigatorSliderAdder(bdvh).run();
            new TimepointAdapterAdder(bdvh).run();
        });
        BdvHandleHelper.addCard((BdvHandle)bdvh, (String)"Mode", (JComponent)editorModeToggle, (boolean)true);
        return bdvh;
    }
}

