/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.supplier.biop;

import java.util.Arrays;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.biop.BiopBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.biop.BiopSerializableBdvOptions;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Set BDV window (biop)", description="Set preferences of Bdv Window (Biop)")
public class BdvSetBiopViewerSettingsCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Click this checkbox to ignore all parameters and reset the default biop viewer", persist=false)
    boolean resetToDefault = false;
    @Parameter
    int width = 640;
    @Parameter
    int height = 480;
    @Parameter
    String screenscales = "1, 0.5, 0.25, 0.125";
    @Parameter
    int numrenderingthreads = 3;
    @Parameter
    int numsourcegroups = 10;
    @Parameter
    String frametitle = "BigDataViewer";
    @Parameter
    boolean is2d = false;
    @Parameter
    boolean interpolate = false;
    @Parameter
    int numtimepoints = 1;
    @Parameter
    int fontSize = 18;
    @Parameter(choices={"Courier", "TimesRoman"})
    String font;
    @Parameter
    SourceAndConverterBdvDisplayService sacDisplayService;

    public void run() {
        if (this.resetToDefault) {
            BiopBdvSupplier bdvSupplier = new BiopBdvSupplier(new BiopSerializableBdvOptions());
            this.sacDisplayService.setDefaultBdvSupplier((IBdvSupplier)bdvSupplier);
        } else {
            BiopSerializableBdvOptions options = new BiopSerializableBdvOptions();
            options.frameTitle = this.frametitle;
            options.is2D = this.is2d;
            options.numRenderingThreads = this.numrenderingthreads;
            options.screenScales = Arrays.stream(this.screenscales.split(",")).mapToDouble(Double::parseDouble).toArray();
            options.height = this.height;
            options.width = this.width;
            options.numSourceGroups = this.numsourcegroups;
            options.numTimePoints = this.numtimepoints;
            options.interpolate = this.interpolate;
            options.font = this.font;
            options.fontSize = this.fontSize;
            BiopBdvSupplier bdvSupplier = new BiopBdvSupplier(options);
            this.sacDisplayService.setDefaultBdvSupplier((IBdvSupplier)bdvSupplier);
        }
    }
}

