/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.supplier;

import bdv.ui.SourcesTransferable;
import bdv.util.BdvHandle;
import ch.epfl.biop.bdv.select.SourceSelectorBehaviour;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.DragBehaviour;
import sc.fiji.bdvpg.behaviour.EditorBehaviourInstaller;
import sc.fiji.bdvpg.scijava.services.ui.swingdnd.BdvTransferHandler;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class BdvSupplierHelper {
    public static void addSourcesDragAndDrop(BdvHandle bdvh) {
        bdvh.getViewerPanel().setTransferHandler((TransferHandler)new BdvTransferHandler());
    }

    public static SourceSelectorBehaviour addEditorMode(BdvHandle bdvh, String pathToBindings) {
        SourceSelectorBehaviour ssb = new SourceSelectorBehaviour(bdvh, "E");
        SourceAndConverterServices.getBdvDisplayService().setDisplayMetadata(bdvh, SourceSelectorBehaviour.class.getSimpleName(), (Object)ssb);
        new EditorBehaviourInstaller(ssb, pathToBindings).run();
        if (bdvh.getViewerPanel().getTransferHandler() instanceof BdvTransferHandler) {
            System.out.println("Dragging support enabled");
            BdvTransferHandler handler = (BdvTransferHandler)bdvh.getViewerPanel().getTransferHandler();
            handler.setTransferableFunction(c -> new SourcesTransferable((Collection)ssb.getSelectedSources()));
            ssb.addBehaviour((Behaviour)new DragNDSourcesBehaviour(bdvh), "drag-selected-sources", new String[]{"alt button1"});
        }
        return ssb;
    }

    static class DragNDSourcesBehaviour
    implements DragBehaviour {
        final BdvHandle bdvh;

        public DragNDSourcesBehaviour(BdvHandle bdvh) {
            this.bdvh = bdvh;
        }

        @Override
        public void init(int x, int y) {
            this.bdvh.getViewerPanel().getTransferHandler().exportAsDrag((JComponent)this.bdvh.getViewerPanel(), new MouseEvent((Component)this.bdvh.getViewerPanel(), 0, 0L, 0, 100, 100, 1, false), 2);
        }

        @Override
        public void drag(int x, int y) {
        }

        @Override
        public void end(int x, int y) {
        }
    }
}

