/*
 * Decompiled with CFR 0.152.
 */
package bdv.util.converters;

import bdv.viewer.SourceAndConverter;
import java.util.HashMap;
import java.util.Map;
import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.RealType;
import sc.fiji.bdvpg.sourceandconverter.ICloneableConverter;

public abstract class RealARGBColorConverter<R extends RealType<?>>
implements ColorConverter,
Converter<R, ARGBType>,
ICloneableConverter {
    protected double min;
    protected double max;
    protected final ARGBType color = new ARGBType(ARGBType.rgba((int)255, (int)255, (int)255, (int)255));
    protected int A;
    protected double scaleR;
    protected double scaleG;
    protected double scaleB;
    protected int black;
    protected final Map<Double, Integer> valueToColor = new HashMap<Double, Integer>();

    public RealARGBColorConverter(double min, double max) {
        this.min = min;
        this.max = max;
        this.update();
    }

    public Map<Double, Integer> getValueToColor() {
        return this.valueToColor;
    }

    public ARGBType getColor() {
        return this.color.copy();
    }

    public void setColor(ARGBType c) {
        this.color.set(c);
        this.update();
    }

    public boolean supportsColor() {
        return true;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
        this.update();
    }

    public void setMin(double min) {
        this.min = min;
        this.update();
    }

    private void update() {
        double scale = 1.0 / (this.max - this.min);
        int value = this.color.get();
        this.A = ARGBType.alpha((int)value);
        this.scaleR = (double)ARGBType.red((int)value) * scale;
        this.scaleG = (double)ARGBType.green((int)value) * scale;
        this.scaleB = (double)ARGBType.blue((int)value) * scale;
        this.black = ARGBType.rgba((int)0, (int)0, (int)0, (int)this.A);
    }

    public static class Imp1<R extends RealType<?>>
    extends RealARGBColorConverter<R> {
        final double typeMin;
        final double typeMax;

        public Imp1(double min, double max) {
            super(min, max);
            this.typeMax = max;
            this.typeMin = min;
        }

        public void convert(R input, ARGBType output) {
            double value = input.getRealDouble();
            if (this.valueToColor.containsKey(value)) {
                output.set(((Integer)this.valueToColor.get(value)).intValue());
                return;
            }
            double valueMinusMin = value - this.min;
            if (valueMinusMin < 0.0) {
                output.set(this.black);
            } else {
                int r0 = (int)(this.scaleR * valueMinusMin + 0.5);
                int g0 = (int)(this.scaleG * valueMinusMin + 0.5);
                int b0 = (int)(this.scaleB * valueMinusMin + 0.5);
                int r = Math.min(255, r0);
                int g = Math.min(255, g0);
                int b = Math.min(255, b0);
                output.set(ARGBType.rgba((int)r, (int)g, (int)b, (int)255));
            }
        }

        public Converter duplicateConverter(SourceAndConverter source) {
            Imp1<R> converter = new Imp1<R>(this.typeMin, this.typeMax);
            converter.setMin(this.min);
            converter.setMax(this.max);
            converter.setColor(this.getColor());
            return converter;
        }
    }

    public static class Imp0<R extends RealType<?>>
    extends RealARGBColorConverter<R> {
        final double typeMin;
        final double typeMax;

        public Imp0(double min, double max) {
            super(min, max);
            this.typeMax = max;
            this.typeMin = min;
        }

        public void convert(R input, ARGBType output) {
            double value = input.getRealDouble();
            if (this.valueToColor.containsKey(value)) {
                output.set(((Integer)this.valueToColor.get(value)).intValue());
                return;
            }
            double valueMinusMin = value - this.min;
            if (valueMinusMin < 0.0) {
                output.set(this.black);
            } else {
                int r0 = (int)(this.scaleR * valueMinusMin + 0.5);
                int g0 = (int)(this.scaleG * valueMinusMin + 0.5);
                int b0 = (int)(this.scaleB * valueMinusMin + 0.5);
                int r = Math.min(255, r0);
                int g = Math.min(255, g0);
                int b = Math.min(255, b0);
                output.set(ARGBType.rgba((int)r, (int)g, (int)b, (int)255));
            }
        }

        public Converter duplicateConverter(SourceAndConverter source) {
            Imp0<R> converter = new Imp0<R>(this.typeMin, this.typeMax);
            converter.setMin(this.min);
            converter.setMax(this.max);
            converter.setColor(this.getColor());
            return converter;
        }
    }
}

