/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

import org.renjin.eval.Session;
import org.renjin.sexp.DoubleVector;
import org.renjin.stats.internals.Distributions;
import org.renjin.stats.internals.distributions.Beta;
import org.renjin.stats.internals.distributions.ChiSquare;
import org.renjin.stats.internals.distributions.SignRank;

public class F {
    public static double rf(Session context, double n1, double n2) {
        if (Double.isNaN(n1) || Double.isNaN(n2) || n1 <= 0.0 || n2 <= 0.0) {
            return Double.NaN;
        }
        double v1 = Double.isInfinite(n1) ? ChiSquare.rchisq(context, n1) / n1 : 1.0;
        double v2 = Double.isInfinite(n2) ? ChiSquare.rchisq(context, n2) / n2 : 1.0;
        return v1 / v2;
    }

    public static double dnf(double x, double df1, double df2, double ncp, boolean give_log) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(df1) || DoubleVector.isNaN(df2) || DoubleVector.isNaN(ncp)) {
            return x + df2 + df1 + ncp;
        }
        if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return SignRank.R_D__0(true, give_log);
        }
        if (!DoubleVector.isFinite(ncp)) {
            return Double.NaN;
        }
        if (!DoubleVector.isFinite(df1) && !DoubleVector.isFinite(df2)) {
            if (x == 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return SignRank.R_D__0(true, give_log);
        }
        if (!DoubleVector.isFinite(df2)) {
            return df1 * Distributions.dnchisq(x * df1, df1, ncp, give_log);
        }
        if (df1 > 1.0E14 && ncp < 1.0E7) {
            double f = 1.0 + ncp / df1;
            double z = Distributions.dgamma(1.0 / x / f, df2 / 2.0, 2.0 / df2, give_log);
            return give_log ? z - 2.0 * Math.log(x) - Math.log(f) : z / (x * x) / f;
        }
        double y = df1 / df2 * x;
        double z = Distributions.dnbeta(y / (1.0 + y), df1 / 2.0, df2 / 2.0, ncp, give_log);
        return give_log ? z + Math.log(df1) - Math.log(df2) - 2.0 * Math.log1p(y) : z * (df1 / df2) / (1.0 + y) / (1.0 + y);
    }

    public static double pnf(double x, double df1, double df2, double ncp, boolean lower_tail, boolean log_p) {
        if (DoubleVector.isNaN(x) || DoubleVector.isNaN(df1) || DoubleVector.isNaN(df2) || DoubleVector.isNaN(ncp)) {
            return x + df2 + df1 + ncp;
        }
        if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (!DoubleVector.isFinite(ncp)) {
            return Double.NaN;
        }
        if (!DoubleVector.isFinite(df1) && !DoubleVector.isFinite(df2)) {
            return Double.NaN;
        }
        if (x <= 0.0) {
            return SignRank.R_DT_0(lower_tail, log_p);
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return SignRank.R_DT_1(lower_tail, log_p);
        }
        if (df2 > 1.0E8) {
            return Distributions.pnchisq(x * df1, df1, ncp, lower_tail, log_p);
        }
        double y = df1 / df2 * x;
        return Beta.pnbeta2(y / (1.0 + y), 1.0 / (1.0 + y), df1 / 2.0, df2 / 2.0, ncp, lower_tail, log_p);
    }

    public static double qnf(double p, double df1, double df2, double ncp, boolean lower_tail, boolean log_p) {
        if (DoubleVector.isNaN(p) || DoubleVector.isNaN(df1) || DoubleVector.isNaN(df2) || DoubleVector.isNaN(ncp)) {
            return p + df1 + df2 + ncp;
        }
        if (df1 <= 0.0 || df2 <= 0.0 || ncp < 0.0) {
            return Double.NaN;
        }
        if (!DoubleVector.isFinite(ncp)) {
            return Double.NaN;
        }
        if (!DoubleVector.isFinite(df1) && !DoubleVector.isFinite(df2)) {
            return Double.NaN;
        }
        if (log_p && p > 0.0 || !log_p && (p < 0.0 || p > 1.0)) {
            return Double.NaN;
        }
        if (p == SignRank.R_DT_0(lower_tail, log_p)) {
            return 0.0;
        }
        if (p == SignRank.R_DT_1(lower_tail, log_p)) {
            return Double.POSITIVE_INFINITY;
        }
        if (df2 > 1.0E8) {
            return Distributions.qnchisq(p, df1, ncp, lower_tail, log_p) / df1;
        }
        double y = Beta.qnbeta(p, df1 / 2.0, df2 / 2.0, ncp, lower_tail, log_p);
        return y / (1.0 - y) * (df2 / df1);
    }
}

