/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.codegen.WrapperRuntime;
import org.renjin.primitives.MathExt;
import org.renjin.primitives.R$primitive$abs$deferred_d;
import org.renjin.primitives.R$primitive$abs$deferred_z;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class R$primitive$abs
extends BuiltinFunction {
    public R$primitive$abs() {
        super("abs");
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, PairList args2) {
        try {
            ArgumentIterator argIt = new ArgumentIterator(context, environment2, args2);
            SEXP s0 = argIt.evalNext();
            if (!argIt.hasNext()) {
                return R$primitive$abs.doApply(context, environment2, s0);
            }
            throw new EvalException("abs: too many arguments, expected at most 1.", new Object[0]);
        }
        catch (ArgumentException e) {
            throw new EvalException(context, "Invalid argument: %s. Expected:\n\tabs(Complex)\n\tabs(double)", e.getMessage());
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
    }

    public static SEXP doApply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        try {
            if (args2.length == 1) {
                return R$primitive$abs.doApply(context, environment2, args2[0]);
            }
        }
        catch (EvalException e) {
            e.initContext(context);
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EvalException(e);
        }
        throw new EvalException("abs: max arity is 1", new Object[0]);
    }

    @Override
    public SEXP apply(Context context, Environment environment2, FunctionCall call2, String[] argNames, SEXP[] args2) {
        return R$primitive$abs.doApply(context, environment2, call2, argNames, args2);
    }

    public static SEXP doApply(Context context, Environment environment2, SEXP arg0) throws Exception {
        if (arg0 instanceof Vector && DoubleVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0)) {
            Vector vector0 = WrapperRuntime.convertToVector(arg0);
            int length0 = vector0.length();
            int currentElementIndex0 = 0;
            int cycles = 0;
            if (length0 == 0) {
                return DoubleVector.EMPTY;
            }
            if (length0 > cycles) {
                cycles = length0;
            }
            if (cycles > 100 || vector0 instanceof DeferredComputation) {
                return context.simplify(new R$primitive$abs$deferred_d(vector0, vector0.getAttributes().copyStructural()));
            }
            DoubleArrayVector.Builder builder = new DoubleArrayVector.Builder(cycles);
            for (int i = 0; i != cycles; ++i) {
                if (vector0.isElementNA(currentElementIndex0)) {
                    builder.setNA(i);
                } else {
                    builder.set(i, MathExt.abs(vector0.getElementAsDouble(currentElementIndex0)));
                }
                if (++currentElementIndex0 != length0) continue;
                currentElementIndex0 = 0;
            }
            if (length0 == cycles) {
                builder.copySomeAttributesFrom(vector0, new Symbol[]{Symbols.DIM, Symbols.DIMNAMES, Symbols.NAMES});
            }
            return builder.build();
        }
        if (arg0 instanceof Vector && ComplexVector.VECTOR_TYPE.isWiderThanOrEqualTo((Vector)arg0)) {
            Vector vector0 = WrapperRuntime.convertToVector(arg0);
            int length0 = vector0.length();
            int currentElementIndex0 = 0;
            int cycles = 0;
            if (length0 == 0) {
                return DoubleVector.EMPTY;
            }
            if (length0 > cycles) {
                cycles = length0;
            }
            if (cycles > 100 || vector0 instanceof DeferredComputation) {
                return context.simplify(new R$primitive$abs$deferred_z(vector0, vector0.getAttributes().copyStructural()));
            }
            DoubleArrayVector.Builder builder = new DoubleArrayVector.Builder(cycles);
            for (int i = 0; i != cycles; ++i) {
                if (vector0.isElementNA(currentElementIndex0)) {
                    builder.setNA(i);
                } else {
                    builder.set(i, MathExt.abs(vector0.getElementAsComplex(currentElementIndex0)));
                }
                if (++currentElementIndex0 != length0) continue;
                currentElementIndex0 = 0;
            }
            if (length0 == cycles) {
                builder.copySomeAttributesFrom(vector0, new Symbol[]{Symbols.DIM, Symbols.DIMNAMES, Symbols.NAMES});
            }
            return builder.build();
        }
        throw new EvalException(String.format("Invalid argument:\n\tabs(%s)\n\tExpected:\n\tabs(Complex)\n\tabs(double)", arg0.getTypeName()), new Object[0]);
    }
}

