/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import sc.fiji.timelapse.StandardDeviation;

public class LinearRegression {
    protected boolean calculated;
    protected double a;
    protected double b;
    protected double sx;
    protected double sxx;
    protected double sy;
    protected double sxy;
    protected int count;

    public LinearRegression(double[] x, double[] y) {
        int length = Math.min(x.length, y.length);
        for (int i = 0; i < length; ++i) {
            this.add(x[i], y[i]);
        }
    }

    public LinearRegression() {
    }

    public void add(double x, double y) {
        this.sx += x;
        this.sxx += x * x;
        this.sy += y;
        this.sxy += x * y;
        ++this.count;
        this.calculated = false;
    }

    public void reset() {
        this.count = 0;
        this.sy = this.sxy = (double)0;
        this.sxx = this.sxy;
        this.sx = this.sxy;
        this.calculated = false;
    }

    protected void calculate() {
        double det = this.sxx * (double)this.count - this.sx * this.sx;
        double m00 = (double)this.count / det;
        double m01 = -this.sx / det;
        double m11 = this.sxx / det;
        this.a = m00 * this.sxy + m01 * this.sy;
        this.b = m01 * this.sxy + m11 * this.sy;
        this.calculated = true;
    }

    public double getA() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.a;
    }

    public double getB() {
        if (!this.calculated) {
            this.calculate();
        }
        return this.b;
    }

    public double get(double x) {
        if (!this.calculated) {
            this.calculate();
        }
        return this.a * x + this.b;
    }

    public double[] get(double[] x) {
        if (!this.calculated) {
            this.calculate();
        }
        double[] y = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            y[i] = this.a * x[i] + this.b;
        }
        return y;
    }

    public double[][] filterOutOutliers(double[] x, double[] y, double tolerance) {
        StandardDeviation stdDev = new StandardDeviation();
        for (int i = 0; i < x.length && i < y.length; ++i) {
            stdDev.add(Math.abs(this.distanceTo(x[i], y[i])));
        }
        tolerance *= stdDev.getMean();
        int[] index = new int[x.length];
        int count = 0;
        for (int i = 0; i < x.length && i < y.length; ++i) {
            if (!(Math.abs(this.distanceTo(x[i], y[i])) <= tolerance)) continue;
            index[count++] = i;
        }
        double[][] result = new double[2][count];
        for (int i = 0; i < count; ++i) {
            result[0][i] = x[index[i]];
            result[1][i] = y[index[i]];
        }
        return result;
    }

    public double distanceTo(double x, double y) {
        return y - this.get(x);
    }
}

