/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.xml.BaseHandler;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.xml.sax.Attributes;

public class MetamorphHandler
extends BaseHandler {
    private Hashtable metadata;
    private Vector<String> timestamps;
    private String imageName;
    private String date;
    private Vector<Integer> wavelengths;
    private Vector<Double> zPositions;
    private double pixelSizeX;
    private double pixelSizeY;
    private double temperature;
    private double lensNA;
    private double lensRI;
    private String binning;
    private double readOutRate;
    private double zoom;
    private Length positionX;
    private Length positionY;
    private Vector<Double> exposures;
    private String channelName;
    private Vector<String> channelNames;
    private String stageLabel;
    private Double gain;
    private boolean dualCamera = false;

    public MetamorphHandler() {
        this(null);
    }

    public MetamorphHandler(Hashtable metadata) {
        this.metadata = metadata;
        this.timestamps = new Vector();
        this.wavelengths = new Vector();
        this.zPositions = new Vector();
        this.exposures = new Vector();
        this.channelNames = new Vector();
    }

    public Double getGain() {
        return this.gain;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Vector<String> getChannelNames() {
        return this.channelNames;
    }

    public String getStageLabel() {
        return this.stageLabel;
    }

    public Vector<String> getTimestamps() {
        return this.timestamps;
    }

    public Vector<Integer> getWavelengths() {
        return this.wavelengths;
    }

    public Vector<Double> getZPositions() {
        return this.zPositions;
    }

    public String getDate() {
        return this.date;
    }

    public String getImageName() {
        return this.imageName;
    }

    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public String getBinning() {
        return this.binning;
    }

    public double getReadOutRate() {
        return this.readOutRate;
    }

    public double getZoom() {
        return this.zoom;
    }

    public Length getStagePositionX() {
        return this.positionX;
    }

    public Length getStagePositionY() {
        return this.positionY;
    }

    public double getLensNA() {
        return this.lensNA;
    }

    public double getLensRI() {
        return this.lensRI;
    }

    public Vector<Double> getExposures() {
        return this.exposures;
    }

    public boolean hasDualCamera() {
        return this.dualCamera;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        String id = attributes.getValue("id");
        String value = attributes.getValue("value");
        String delim = " #13; #10;";
        if (value != null && value.indexOf(delim) < 0) {
            delim = "&#13;&#10;";
        }
        if (id != null && value != null) {
            if (id.equals("Description")) {
                if (this.metadata != null) {
                    this.metadata.remove("Comment");
                }
                String k = null;
                String v = null;
                boolean freeform = true;
                StringBuilder freeformDescription = new StringBuilder();
                if (value.indexOf(delim) != -1) {
                    int currentIndex = -delim.length();
                    while (currentIndex != -1) {
                        int nextIndex = value.indexOf(delim, currentIndex += delim.length());
                        String line = null;
                        line = nextIndex == -1 ? value.substring(currentIndex, value.length()) : value.substring(currentIndex, nextIndex);
                        currentIndex = nextIndex;
                        if (line.startsWith("Exposure: ")) {
                            freeform = false;
                            if (this.metadata != null) {
                                this.metadata.put("User Description", freeformDescription.toString().trim());
                            }
                        }
                        if (freeform) {
                            freeformDescription.append(line);
                            freeformDescription.append("\n");
                            continue;
                        }
                        int colon = line.indexOf(58);
                        if (colon != -1) {
                            k = line.substring(0, colon).trim();
                            v = line.substring(colon + 1).trim();
                            if (this.metadata != null) {
                                this.metadata.put(k, v);
                            }
                            this.checkKey(k, v);
                            continue;
                        }
                        if (this.metadata == null) continue;
                        this.metadata.put(k, k);
                    }
                } else {
                    int colon = value.indexOf(58);
                    while (colon != -1) {
                        k = value.substring(0, colon);
                        int space = value.lastIndexOf(" ", value.indexOf(":", colon + 1));
                        if (space == -1) {
                            space = value.length();
                        }
                        v = value.substring(colon + 1, space).trim();
                        if (this.metadata != null) {
                            this.metadata.put(k, v);
                        }
                        value = value.substring(space).trim();
                        colon = value.indexOf(58);
                        this.checkKey(k, v);
                    }
                }
            } else {
                if (this.metadata != null) {
                    this.metadata.put(id, value);
                }
                this.checkKey(id, value);
            }
        }
    }

    private void checkKey(String key, String value) {
        Double doubleValue = this.parseDouble(value);
        if (doubleValue != null) {
            if (key.equals("Temperature")) {
                this.temperature = doubleValue;
            } else if (key.equals("spatial-calibration-x")) {
                this.pixelSizeX = doubleValue;
            } else if (key.equals("spatial-calibration-y")) {
                this.pixelSizeY = doubleValue;
            } else if (key.equals("z-position")) {
                this.zPositions.add(doubleValue);
            } else if (key.equals("_MagNA_")) {
                this.lensNA = doubleValue;
            } else if (key.equals("_MagRI_")) {
                this.lensRI = doubleValue;
            } else if (key.equals("Readout Frequency")) {
                this.readOutRate = doubleValue;
            } else if (key.equals("zoom-percent")) {
                this.zoom = doubleValue;
            } else if (key.equals("stage-position-x")) {
                this.positionX = new Length((Number)doubleValue, UNITS.REFERENCEFRAME);
                if (this.metadata != null) {
                    this.metadata.put("X position for position #1", this.positionX);
                }
            } else if (key.equals("stage-position-y")) {
                this.positionY = new Length((Number)doubleValue, UNITS.REFERENCEFRAME);
                if (this.metadata != null) {
                    this.metadata.put("Y position for position #1", this.positionY);
                }
            }
        }
        if (key.equals("wavelength")) {
            this.wavelengths.add(Integer.parseInt(value));
        } else if (key.equals("acquisition-time-local")) {
            this.date = value;
            this.timestamps.add(this.date);
        } else if (key.equals("image-name")) {
            this.imageName = value;
        } else if (key.equals("Binning")) {
            this.binning = value;
        } else if (key.equals("Speed")) {
            Double rate;
            int space = value.indexOf(32);
            if (space > 0) {
                value = value.substring(0, space);
            }
            if ((rate = this.parseDouble(value.trim())) != null) {
                this.readOutRate = rate;
            }
        } else if (key.equals("Exposure")) {
            Double exposure;
            if (value.indexOf(32) != -1) {
                value = value.substring(0, value.indexOf(32));
            }
            if ((exposure = this.parseDouble(value)) != null) {
                exposure = exposure / 1000.0;
            }
            this.exposures.add(exposure);
        } else if (key.equals("_IllumSetting_")) {
            if (this.channelName == null) {
                this.channelName = value;
            }
            this.channelNames.add(value);
        } else if (key.equals("stage-label")) {
            this.stageLabel = value;
        } else if (key.endsWith("Gain") && this.gain == null) {
            Double v = this.parseDouble(value.replaceAll("[xX]", ""));
            if (v != null) {
                this.gain = v;
            }
        } else if (key.startsWith("Dual Camera")) {
            int space = value.lastIndexOf(" ");
            if (space == -1) {
                this.dualCamera = true;
            } else {
                try {
                    Double.parseDouble(value.substring(space));
                    this.dualCamera = false;
                }
                catch (NumberFormatException e) {
                    this.dualCamera = true;
                }
            }
        }
    }

    private Double parseDouble(String v) {
        return DataTools.parseDouble(v.replaceAll("\\+", ""));
    }
}

