/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.wrapper;

import ij.ImageJ;
import java.util.ArrayList;
import mpicbg.imglib.container.DirectAccessContainerFactory;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.array.ByteArray;
import mpicbg.imglib.container.basictypecontainer.array.DoubleArray;
import mpicbg.imglib.container.basictypecontainer.array.IntArray;
import mpicbg.imglib.container.basictypecontainer.array.LongArray;
import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.container.cell.CellContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.type.numeric.integer.ByteType;
import mpicbg.imglib.type.numeric.integer.ShortType;
import mpicbg.imglib.type.numeric.integer.UnsignedByteType;
import mpicbg.imglib.type.numeric.real.FloatType;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.list.ListImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public class ImgLib1 {
    public static Img<net.imglib2.type.numeric.real.FloatType> wrapFloatToImgLib2(Image<FloatType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayFloatToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellFloatToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<DoubleType> wrapDoubleToImgLib2(Image<mpicbg.imglib.type.numeric.real.DoubleType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayDoubleToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellDoubleToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<LongType> wrapLongToImgLib2(Image<mpicbg.imglib.type.numeric.integer.LongType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayLongToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellLongToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<IntType> wrapIntToImgLib2(Image<mpicbg.imglib.type.numeric.integer.IntType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayIntToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellIntToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<UnsignedIntType> wrapUnsignedIntToImgLib2(Image<mpicbg.imglib.type.numeric.integer.UnsignedIntType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayUnsignedIntToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellUnsignedIntToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<net.imglib2.type.numeric.integer.ShortType> wrapShortToImgLib2(Image<ShortType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayShortToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellShortToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<UnsignedShortType> wrapUnsignedShortToImgLib2(Image<mpicbg.imglib.type.numeric.integer.UnsignedShortType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayUnsignedShortToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellUnsignedShortToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<net.imglib2.type.numeric.integer.ByteType> wrapByteToImgLib2(Image<ByteType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayByteToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellByteToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<net.imglib2.type.numeric.integer.UnsignedByteType> wrapUnsignedByteToImgLib2(Image<UnsignedByteType> image) {
        if (image.getContainer() instanceof Array) {
            return ImgLib1.wrapArrayUnsignedByteToImgLib2(image);
        }
        if (image.getContainer() instanceof CellContainer) {
            return ImgLib1.wrapCellUnsignedByteToImgLib2(image);
        }
        throw new RuntimeException("Container " + image.getContainer().getClass().getCanonicalName() + " not supported.");
    }

    public static Img<net.imglib2.type.numeric.real.FloatType> wrapCellFloatToImgLib2(Image<FloatType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new FloatArray(((mpicbg.imglib.container.basictypecontainer.array.FloatArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new net.imglib2.type.numeric.real.FloatType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        net.imglib2.type.numeric.real.FloatType linkedType = new net.imglib2.type.numeric.real.FloatType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<DoubleType> wrapCellDoubleToImgLib2(Image<mpicbg.imglib.type.numeric.real.DoubleType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new net.imglib2.img.basictypeaccess.array.DoubleArray(((DoubleArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new DoubleType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        DoubleType linkedType = new DoubleType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<LongType> wrapCellLongToImgLib2(Image<mpicbg.imglib.type.numeric.integer.LongType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new net.imglib2.img.basictypeaccess.array.LongArray(((LongArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new LongType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        LongType linkedType = new LongType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<IntType> wrapCellIntToImgLib2(Image<mpicbg.imglib.type.numeric.integer.IntType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new net.imglib2.img.basictypeaccess.array.IntArray(((IntArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new IntType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        IntType linkedType = new IntType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<UnsignedIntType> wrapCellUnsignedIntToImgLib2(Image<mpicbg.imglib.type.numeric.integer.UnsignedIntType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new net.imglib2.img.basictypeaccess.array.IntArray(((IntArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new UnsignedIntType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        UnsignedIntType linkedType = new UnsignedIntType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<net.imglib2.type.numeric.integer.ShortType> wrapCellShortToImgLib2(Image<ShortType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new ShortArray(((mpicbg.imglib.container.basictypecontainer.array.ShortArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new net.imglib2.type.numeric.integer.ShortType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        net.imglib2.type.numeric.integer.ShortType linkedType = new net.imglib2.type.numeric.integer.ShortType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<UnsignedShortType> wrapCellUnsignedShortToImgLib2(Image<mpicbg.imglib.type.numeric.integer.UnsignedShortType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new ShortArray(((mpicbg.imglib.container.basictypecontainer.array.ShortArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new UnsignedShortType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        UnsignedShortType linkedType = new UnsignedShortType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<net.imglib2.type.numeric.integer.ByteType> wrapCellByteToImgLib2(Image<ByteType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new net.imglib2.img.basictypeaccess.array.ByteArray(((ByteArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new net.imglib2.type.numeric.integer.ByteType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        net.imglib2.type.numeric.integer.ByteType linkedType = new net.imglib2.type.numeric.integer.ByteType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<net.imglib2.type.numeric.integer.UnsignedByteType> wrapCellUnsignedByteToImgLib2(Image<UnsignedByteType> image) {
        CellContainer cellContainer = (CellContainer)image.getContainer();
        int n = cellContainer.getNumDimensions();
        long[] dimensions = Util.int2long((int[])cellContainer.getDimensions());
        int[] cellDimensions = cellContainer.getCellSize();
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        for (int i = 0; i < cellContainer.getNumCells(); ++i) {
            grid.getCellDimensions((long)i, cellMin, cellDims);
            cellList.add(new Cell(cellDims, cellMin, (Object)new net.imglib2.img.basictypeaccess.array.ByteArray(((ByteArray)cellContainer.getCell(i).getData()).getCurrentStorageArray())));
        }
        ListImg cells = new ListImg(cellList, grid.getGridDimensions());
        CellImgFactory factory = new CellImgFactory(cellDimensions);
        Fraction entitiesPerPixel = new net.imglib2.type.numeric.integer.UnsignedByteType().getEntitiesPerPixel();
        CellImg cellImg = new CellImg(factory, grid, cells, entitiesPerPixel);
        net.imglib2.type.numeric.integer.UnsignedByteType linkedType = new net.imglib2.type.numeric.integer.UnsignedByteType((NativeImg)cellImg);
        cellImg.setLinkedType((NativeType)linkedType);
        return cellImg;
    }

    public static Img<net.imglib2.type.numeric.real.FloatType> wrapArrayFloatToImgLib2(Image<FloatType> image) {
        Array array = (Array)image.getContainer();
        mpicbg.imglib.container.basictypecontainer.array.FloatArray f = (mpicbg.imglib.container.basictypecontainer.array.FloatArray)array.update(null);
        float[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        FloatArray access = new FloatArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        net.imglib2.type.numeric.real.FloatType linkedType = new net.imglib2.type.numeric.real.FloatType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<DoubleType> wrapArrayDoubleToImgLib2(Image<mpicbg.imglib.type.numeric.real.DoubleType> image) {
        Array array = (Array)image.getContainer();
        DoubleArray f = (DoubleArray)array.update(null);
        double[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        net.imglib2.img.basictypeaccess.array.DoubleArray access = new net.imglib2.img.basictypeaccess.array.DoubleArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        DoubleType linkedType = new DoubleType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<LongType> wrapArrayLongToImgLib2(Image<mpicbg.imglib.type.numeric.integer.LongType> image) {
        Array array = (Array)image.getContainer();
        LongArray f = (LongArray)array.update(null);
        long[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        net.imglib2.img.basictypeaccess.array.LongArray access = new net.imglib2.img.basictypeaccess.array.LongArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        LongType linkedType = new LongType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<UnsignedIntType> wrapArrayUnsignedIntToImgLib2(Image<mpicbg.imglib.type.numeric.integer.UnsignedIntType> image) {
        Array array = (Array)image.getContainer();
        IntArray f = (IntArray)array.update(null);
        int[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        net.imglib2.img.basictypeaccess.array.IntArray access = new net.imglib2.img.basictypeaccess.array.IntArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        UnsignedIntType linkedType = new UnsignedIntType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<IntType> wrapArrayIntToImgLib2(Image<mpicbg.imglib.type.numeric.integer.IntType> image) {
        Array array = (Array)image.getContainer();
        IntArray f = (IntArray)array.update(null);
        int[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        net.imglib2.img.basictypeaccess.array.IntArray access = new net.imglib2.img.basictypeaccess.array.IntArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        IntType linkedType = new IntType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<UnsignedShortType> wrapArrayUnsignedShortToImgLib2(Image<mpicbg.imglib.type.numeric.integer.UnsignedShortType> image) {
        Array array = (Array)image.getContainer();
        mpicbg.imglib.container.basictypecontainer.array.ShortArray f = (mpicbg.imglib.container.basictypecontainer.array.ShortArray)array.update(null);
        short[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        ShortArray access = new ShortArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        UnsignedShortType linkedType = new UnsignedShortType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<net.imglib2.type.numeric.integer.ShortType> wrapArrayShortToImgLib2(Image<ShortType> image) {
        Array array = (Array)image.getContainer();
        mpicbg.imglib.container.basictypecontainer.array.ShortArray f = (mpicbg.imglib.container.basictypecontainer.array.ShortArray)array.update(null);
        short[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        ShortArray access = new ShortArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        net.imglib2.type.numeric.integer.ShortType linkedType = new net.imglib2.type.numeric.integer.ShortType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<net.imglib2.type.numeric.integer.ByteType> wrapArrayByteToImgLib2(Image<ByteType> image) {
        Array array = (Array)image.getContainer();
        ByteArray f = (ByteArray)array.update(null);
        byte[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        net.imglib2.img.basictypeaccess.array.ByteArray access = new net.imglib2.img.basictypeaccess.array.ByteArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        net.imglib2.type.numeric.integer.ByteType linkedType = new net.imglib2.type.numeric.integer.ByteType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static Img<net.imglib2.type.numeric.integer.UnsignedByteType> wrapArrayUnsignedByteToImgLib2(Image<UnsignedByteType> image) {
        Array array = (Array)image.getContainer();
        ByteArray f = (ByteArray)array.update(null);
        byte[] data = f.getCurrentStorageArray();
        long[] dim = new long[image.getNumDimensions()];
        for (int d = 0; d < dim.length; ++d) {
            dim[d] = image.getDimension(d);
        }
        net.imglib2.img.basictypeaccess.array.ByteArray access = new net.imglib2.img.basictypeaccess.array.ByteArray(data);
        ArrayImg arrayImgLib2 = new ArrayImg((Object)access, dim, new Fraction());
        net.imglib2.type.numeric.integer.UnsignedByteType linkedType = new net.imglib2.type.numeric.integer.UnsignedByteType((NativeImg)arrayImgLib2);
        arrayImgLib2.setLinkedType((NativeType)linkedType);
        return arrayImgLib2;
    }

    public static void main(String[] args) {
        DirectAccessContainerFactory t = new CellContainerFactory(5);
        t = new ArrayContainerFactory();
        ImageFactory<FloatType> f = new ImageFactory<FloatType>(new FloatType(), t);
        new ImageJ();
        Image<FloatType> img = f.createImage(new int[]{19, 8, 3});
        int i = 0;
        for (FloatType ft : img) {
            ft.set(i++);
        }
        ImageJFunctions.show(img);
        net.imglib2.img.display.imagej.ImageJFunctions.show(ImgLib1.wrapFloatToImgLib2(img));
    }
}

