/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.special;

import java.util.Iterator;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.cursor.special.AbstractSortedGrayLevelIterator;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.IntegerType;

public class SortedGrayLevelIteratorArrayContainerOnly<T extends IntegerType<T>>
extends AbstractSortedGrayLevelIterator<T> {
    protected T arrayType;

    public SortedGrayLevelIteratorArrayContainerOnly(Image<T> image) {
        super(image);
        if (!Array.class.isInstance(image.getContainer())) {
            throw new RuntimeException("Only array container is supported. Use class SortedGrayLevelIterator instead.");
        }
    }

    @Override
    protected void createInternalCursor() {
        this.arrayType = (IntegerType)this.image.createCursor().getType();
    }

    @Override
    protected int getIntegerValueAtLinearIndex(int p) {
        this.arrayType.updateIndex(p);
        return this.arrayType.getInteger();
    }

    @Override
    public void fwd() {
        ++this.curIdx;
        this.arrayType.updateIndex(this.sortedLinIdx[this.curIdx]);
    }

    @Override
    public void fwd(long steps) {
        this.curIdx += (int)steps;
        this.arrayType.updateIndex(this.sortedLinIdx[this.curIdx]);
    }

    @Override
    public void getPosition(int[] position) {
        SortedGrayLevelIteratorArrayContainerOnly.indexToPosition(this.sortedLinIdx[this.curIdx], this.image.getDimensions(), position);
    }

    @Override
    public int getPosition(int dim) {
        SortedGrayLevelIteratorArrayContainerOnly.indexToPosition(this.sortedLinIdx[this.curIdx], this.image.getDimensions(), this.position);
        return this.position[dim];
    }

    @Override
    public void close() {
    }

    @Override
    public int getStorageIndex() {
        return this.arrayType.getIndex();
    }

    @Override
    public T getType() {
        return this.arrayType;
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }
}

