/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.function.NormMinMax;
import mpicbg.imglib.algorithm.math.ComputeMinMax;
import mpicbg.imglib.algorithm.math.ImageConverter;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.util.RealSum;

public class NormalizeImageMinMax<T extends RealType<T>>
implements Algorithm,
MultiThreaded {
    final Image<T> image;
    String errorMessage = "";
    int numThreads;

    public NormalizeImageMinMax(Image<T> image) {
        this.setNumThreads();
        this.image = image;
    }

    @Override
    public boolean process() {
        double max;
        ComputeMinMax<T> minMax = new ComputeMinMax<T>(this.image);
        minMax.setNumThreads(this.getNumThreads());
        if (!minMax.checkInput() || !minMax.process()) {
            this.errorMessage = "Cannot compute min and max: " + minMax.getErrorMessage();
            return false;
        }
        double min = ((RealType)minMax.getMin()).getRealDouble();
        if (min == (max = ((RealType)minMax.getMax()).getRealDouble())) {
            this.errorMessage = "Min and Max of the image are equal";
            return false;
        }
        ImageConverter<T, T> imgConv = new ImageConverter<T, T>(this.image, this.image, new NormMinMax(min, max));
        imgConv.setNumThreads(this.getNumThreads());
        if (!imgConv.checkInput() || !imgConv.process()) {
            this.errorMessage = "Cannot divide by value: " + imgConv.getErrorMessage();
            return false;
        }
        return true;
    }

    public static <T extends RealType<T>> double sumImage(Image<T> image) {
        RealSum sum = new RealSum();
        Cursor<T> cursor = image.createCursor();
        while (cursor.hasNext()) {
            cursor.fwd();
            sum.add(((RealType)cursor.getType()).getRealDouble());
        }
        cursor.close();
        return sum.getSum();
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "NormalizeImageReal: [Image<T> image] is null.";
            return false;
        }
        return true;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

