/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.vesselness;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.outofbounds.AbstractOutOfBoundsMirror;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.FrangiVesselness.class)
public class DefaultFrangi<T extends RealType<T>, U extends RealType<U>>
extends AbstractUnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<U>>
implements Ops.Filter.FrangiVesselness {
    public static final int MIN_DIMS = 2;
    public static final int MAX_DIMS = 3;
    @Parameter
    private double[] spacing;
    @Parameter
    private int scale;
    protected double alpha = 0.5;
    protected double beta = 0.5;
    protected double minimumVesselness = Double.MIN_VALUE;
    protected double maximumVesselness = Double.MAX_VALUE;

    public double getMinimumVesselness() {
        return this.minimumVesselness;
    }

    public double getMaximumVesselness() {
        return this.maximumVesselness;
    }

    private double getDistance(RandomAccess<T> ahead, RandomAccess<T> behind, int d) {
        double distance = 0.0;
        for (int i = 0; i < d; ++i) {
            double separation = (double)(ahead.getLongPosition(i) - behind.getLongPosition(i)) * this.spacing[i];
            if (separation == 0.0) continue;
            distance += separation * separation;
        }
        return Math.sqrt(distance);
    }

    private double derive(double val1, double val2, double distance) {
        return (val2 - val1) / distance;
    }

    @Override
    public void compute(RandomAccessibleInterval<T> input, RandomAccessibleInterval<U> output) {
        if (this.spacing == null) {
            this.spacing = new double[input.numDimensions()];
            for (int i = 0; i < input.numDimensions(); ++i) {
                this.spacing[i] = 1.0;
            }
        }
        this.frangi(input, output, this.scale);
    }

    private final void frangi(RandomAccessibleInterval<T> in, RandomAccessibleInterval<U> out, int step) {
        double ad = 2.0 * this.alpha * this.alpha;
        double bd = 2.0 * this.beta * this.beta;
        OutOfBoundsMirrorFactory osmf = new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE);
        Cursor cursor = Views.iterable(in).localizingCursor();
        Matrix hessian = new Matrix(in.numDimensions(), in.numDimensions());
        AbstractOutOfBoundsMirror current = osmf.create(in);
        AbstractOutOfBoundsMirror behind = osmf.create(in);
        AbstractOutOfBoundsMirror ahead = osmf.create(in);
        RandomAccess outputRA = out.randomAccess();
        while (cursor.hasNext()) {
            double al2;
            double l2;
            double al1;
            double l1;
            double cd;
            double c;
            cursor.fwd();
            for (int m = 0; m < in.numDimensions(); ++m) {
                for (int n = 0; n < in.numDimensions(); ++n) {
                    current.setPosition((Localizable)cursor);
                    ahead.setPosition((Localizable)cursor);
                    behind.setPosition((Localizable)cursor);
                    behind.move(-step, m);
                    if (m != n) {
                        behind.move(-step, n);
                    }
                    double derivativeA = this.derive(((RealType)behind.get()).getRealDouble(), ((RealType)current.get()).getRealDouble(), this.getDistance((RandomAccess<T>)behind, (RandomAccess<T>)current, in.numDimensions()));
                    ahead.move(step, m);
                    if (m != n) {
                        ahead.move(step, n);
                    }
                    double derivativeB = this.derive(((RealType)current.get()).getRealDouble(), ((RealType)ahead.get()).getRealDouble(), this.getDistance((RandomAccess<T>)current, (RandomAccess<T>)ahead, in.numDimensions()));
                    double derivative2 = this.derive(derivativeA, derivativeB, this.getDistance((RandomAccess<T>)behind, (RandomAccess<T>)ahead, in.numDimensions()));
                    hessian.set(m, n, derivative2);
                }
            }
            double s = hessian.normF();
            double cn = -(s * s);
            EigenvalueDecomposition e = hessian.eig();
            double[] eigenvaluesArray = e.getRealEigenvalues();
            ArrayList<Double> eigenvaluesArrayList = new ArrayList<Double>();
            for (double d : eigenvaluesArray) {
                eigenvaluesArrayList.add(d);
            }
            Collections.sort(eigenvaluesArrayList, Comparator.comparingDouble(Math::abs));
            double v = 0.0;
            if (in.numDimensions() == 2) {
                c = 15.0;
                cd = 2.0 * c * c;
                l1 = (Double)eigenvaluesArrayList.get(0);
                al1 = Math.abs(l1);
                l2 = (Double)eigenvaluesArrayList.get(1);
                al2 = Math.abs(l2);
                if (l2 < 0.0) {
                    double rb = al1 / al2;
                    double bn = -(rb * rb);
                    v = Math.exp(bn / bd) * (1.0 - Math.exp(cn / cd));
                }
            } else if (in.numDimensions() == 3) {
                c = 200.0;
                cd = 2.0 * c * c;
                l1 = (Double)eigenvaluesArrayList.get(0);
                al1 = Math.abs(l1);
                l2 = (Double)eigenvaluesArrayList.get(1);
                al2 = Math.abs(l2);
                double l3 = (Double)eigenvaluesArrayList.get(2);
                double al3 = Math.abs(l3);
                if (l3 < 0.0) {
                    double rb = al1 / Math.sqrt(al2 * al3);
                    double ra = al2 / al3;
                    double an = -(ra * ra);
                    double bn = -(rb * rb);
                    v = (1.0 - Math.exp(an / ad)) * Math.exp(bn / bd) * (1.0 - Math.exp(cn / cd));
                }
            } else {
                throw new RuntimeException("Currently only 2 or 3 dimensional images are supported");
            }
            if (!Double.isNaN(v)) {
                this.maximumVesselness = Math.max(v, this.maximumVesselness);
                this.minimumVesselness = Math.min(v, this.minimumVesselness);
            }
            outputRA.setPosition((Localizable)cursor);
            ((RealType)outputRA.get()).setReal(v);
        }
    }
}

