/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.io;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imagej.ImgPlus;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.UncheckedCache;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.ReadOnlyCachedCellImgFactory;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.volatiles.VolatileArrayDataAccess;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileDoubleArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileFloatArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileIntArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileLongArray;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileShortArray;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.LazyCellImg;
import net.imglib2.img.io.IJLoader;
import net.imglib2.img.io.proxyaccess.ByteAccessProxy;
import net.imglib2.img.io.proxyaccess.FloatAccessProxy;
import net.imglib2.img.io.proxyaccess.IntAccessProxy;
import net.imglib2.img.io.proxyaccess.LongAccessProxy;
import net.imglib2.img.io.proxyaccess.ShortAccessProxy;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.view.Views;

public class Load {
    public static final <T extends NumericType<T> & NativeType<T>, A extends ArrayDataAccess<A>> CachedCellImg<T, A> lazyStack(List<String> paths, CacheLoader<String, Img<T>> loader) {
        CacheLoader cache_loader;
        final UncheckedCache<Integer, Img> loading_cache = new SoftRefLoaderCache<Integer, Img>().withLoader(i -> (Img)loader.get((String)paths.get((int)i))).unchecked();
        final Img first = loading_cache.get(0);
        long[] dimensions_all = new long[first.numDimensions() + 1];
        first.dimensions(dimensions_all);
        dimensions_all[dimensions_all.length - 1] = paths.size();
        final int[] dimensions_cell = new int[first.numDimensions() + 1];
        if (first instanceof PlanarImg) {
            final int numSlices = ((PlanarImg)first).numSlices();
            dimensions_cell[0] = (int)first.dimension(0);
            dimensions_cell[1] = (int)first.dimension(1);
            dimensions_cell[2] = 1;
            dimensions_cell[3] = 1;
            cache_loader = new CacheLoader<Long, Cell<A>>(){

                @Override
                public final Cell<A> get(Long index) throws Exception {
                    int i = index.intValue();
                    int t = i / numSlices;
                    int z = i % numSlices;
                    long[] min = new long[first.numDimensions() + 1];
                    min[2] = z;
                    min[3] = t;
                    PlanarImg stack = (PlanarImg)loading_cache.get(t);
                    return new Cell(dimensions_cell, min, (Object)stack.getPlane(z));
                }
            };
        } else {
            for (int d = 0; d < dimensions_cell.length - 1; ++d) {
                dimensions_cell[d] = (int)first.dimension(d);
            }
            dimensions_cell[dimensions_cell.length - 1] = 1;
            cache_loader = new CacheLoader<Long, Cell<A>>(){

                @Override
                public final Cell<A> get(Long index) throws Exception {
                    long[] min = new long[first.numDimensions() + 1];
                    min[min.length - 1] = index;
                    return new Cell(dimensions_cell, min, (Object)Load.extractDataAccess((Img)loading_cache.get(index.intValue())));
                }
            };
        }
        CachedCellImg ccimg = new ReadOnlyCachedCellImgFactory().createWithCacheLoader(dimensions_all, (NativeType)((NumericType)first.firstElement()).createVariable(), cache_loader, (ReadOnlyCachedCellImgOptions)((ReadOnlyCachedCellImgOptions)ReadOnlyCachedCellImgOptions.options().volatileAccesses(true)).cellDimensions(dimensions_cell));
        return ccimg;
    }

    private static final <T extends NumericType<T> & NativeType<T>, A extends ArrayDataAccess<?>> A extractDataAccess(Img<T> img) {
        if (ImgPlus.class.isAssignableFrom(img.getClass())) {
            return Load.extractDataAccess(((ImgPlus)img).getImg());
        }
        if (ArrayImg.class.isAssignableFrom(img.getClass())) {
            return (A)Load.wrapAsVolatile((ArrayDataAccess)((ArrayImg)img).update(null));
        }
        NumericType type = (NumericType)img.firstElement();
        if (type instanceof GenericByteType) {
            return (A)new ByteAccessProxy<T>(img);
        }
        if (type instanceof GenericShortType) {
            return (A)new ShortAccessProxy<T>(img);
        }
        if (type instanceof GenericIntType) {
            return (A)new IntAccessProxy<T>(img);
        }
        if (type instanceof GenericLongType) {
            return (A)new LongAccessProxy<T>(img);
        }
        if (type instanceof RealType) {
            return (A)new FloatAccessProxy<T>(img);
        }
        return null;
    }

    private static final VolatileArrayDataAccess<?> wrapAsVolatile(ArrayDataAccess<?> access) {
        Object array = access.getCurrentStorageArray();
        if (array instanceof byte[]) {
            return new VolatileByteArray((byte[])array, true);
        }
        if (array instanceof short[]) {
            return new VolatileShortArray((short[])array, true);
        }
        if (array instanceof int[]) {
            return new VolatileIntArray((int[])array, true);
        }
        if (array instanceof long[]) {
            return new VolatileLongArray((long[])array, true);
        }
        if (array instanceof float[]) {
            return new VolatileFloatArray((float[])array, true);
        }
        if (array instanceof double[]) {
            return new VolatileDoubleArray((double[])array, true);
        }
        return null;
    }

    public static final <T extends NumericType<T> & NativeType<T>, A extends ArrayDataAccess<A>> LazyCellImg<T, A> lazyStack(String[] paths) {
        return Load.lazyStack(Arrays.asList(paths), new IJLoader());
    }

    public static final <T extends NumericType<T> & NativeType<T>, A extends ArrayDataAccess<A>> LazyCellImg<T, A> lazyStack(List<String> paths) {
        return Load.lazyStack(paths, new IJLoader());
    }

    public static final <T extends NumericType<T> & NativeType<T>> RandomAccessibleInterval<T> stack(List<String> paths, CacheLoader<String, Img<T>> loader) {
        return Views.stack(paths.stream().map(path -> {
            try {
                return (Img)loader.get((String)path);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList()));
    }

    public static final <T extends NumericType<T> & NativeType<T>> RandomAccessibleInterval<T> stack(String[] paths, CacheLoader<String, Img<T>> loader) {
        return Load.stack(Arrays.asList(paths), loader);
    }
}

