/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.display.projector.IterableIntervalProjector2D;
import net.imglib2.display.projector.MultithreadedIterableIntervalProjector2D;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.display.imagej.AbstractVirtualStack;
import net.imglib2.img.display.imagej.ImageProcessorUtils;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class ImageJVirtualStack<T extends NativeType<T>>
extends AbstractVirtualStack {
    private final long[] higherSourceDimensions;
    private final RandomAccessibleInterval<T> source;
    private final T type;
    private boolean isWritable = false;
    protected ExecutorService service;

    protected <S> ImageJVirtualStack(RandomAccessibleInterval<S> source, Converter<? super S, T> converter, T type, int bitDepth) {
        this(Converters.convert(source, converter, type), bitDepth);
    }

    protected <S> ImageJVirtualStack(RandomAccessibleInterval<S> source, Converter<? super S, T> converter, T type, int bitDepth, ExecutorService service) {
        this(source, converter, type, bitDepth);
        this.setExecutorService(service);
    }

    protected ImageJVirtualStack(RandomAccessibleInterval<T> source, int bitDepth) {
        super((int)source.dimension(0), (int)source.dimension(1), ImageJVirtualStack.multiply(ImageJVirtualStack.initHigherDimensions(source)), bitDepth);
        assert (source.numDimensions() > 1);
        this.source = ImageJVirtualStack.zeroMin(source);
        this.type = (NativeType)Util.getTypeFromInterval(source);
        this.higherSourceDimensions = ImageJVirtualStack.initHigherDimensions(source);
    }

    private static int multiply(long[] higherSourceDimensions) {
        return (int)LongStream.of(higherSourceDimensions).reduce(1L, (a, b) -> a * b);
    }

    private static long[] initHigherDimensions(Interval source) {
        return IntStream.range(2, source.numDimensions()).mapToLong(arg_0 -> ((Interval)source).dimension(arg_0)).toArray();
    }

    private static <S> RandomAccessibleInterval<S> zeroMin(RandomAccessibleInterval<S> source) {
        return Views.isZeroMin(source) ? source : Views.zeroMin(source);
    }

    public void setExecutorService(ExecutorService service) {
        this.service = service;
    }

    public void setWritable(boolean writable) {
        this.isWritable = writable;
    }

    @Override
    public boolean isWritable() {
        return this.isWritable;
    }

    private ArrayImg<T, ?> getSlice(int index) {
        int sizeX = (int)this.source.dimension(0);
        int sizeY = (int)this.source.dimension(1);
        ArrayImg img = new ArrayImgFactory(this.type).create(new long[]{sizeX, sizeY});
        this.project(index, (Img<T>)img, (Converter<T, T>)((Converter)(i, o) -> o.set((Type)i)));
        return img;
    }

    private void project(int index, Img<T> img, Converter<T, T> converter) {
        IterableIntervalProjector2D projector = this.service == null ? new IterableIntervalProjector2D(0, 1, this.source, img, converter) : new MultithreadedIterableIntervalProjector2D<T, T>(0, 1, this.source, img, converter, this.service);
        this.setPosition(index, (Positionable)projector);
        projector.map();
    }

    private void setPosition(int index, Positionable projector) {
        if (this.higherSourceDimensions.length > 0) {
            int[] position = new int[this.higherSourceDimensions.length];
            IntervalIndexer.indexToPosition((long)index, (long[])this.higherSourceDimensions, (int[])position);
            for (int i = 0; i < position.length; ++i) {
                projector.setPosition(position[i], i + 2);
            }
        }
    }

    @Override
    protected Object getPixelsZeroBasedIndex(int index) {
        ArrayImg<T, ?> img = this.getSlice(index);
        return ((ArrayDataAccess)img.update(null)).getCurrentStorageArray();
    }

    @Override
    protected void setPixelsZeroBasedIndex(int index, Object pixels) {
        Img<?> img = ImageProcessorUtils.createImg(pixels, this.getWidth(), this.getHeight());
        this.project(index, img, (o, i) -> o.set((Type)i));
    }

    protected RandomAccessibleInterval<T> getSliceZeroBasedIndex(int index) {
        IntervalView origin = this.source;
        if (this.higherSourceDimensions.length > 0) {
            int[] position = new int[this.higherSourceDimensions.length];
            IntervalIndexer.indexToPosition((long)index, (long[])this.higherSourceDimensions, (int[])position);
            for (int i = 0; i < position.length; ++i) {
                origin = Views.hyperSlice(origin, (int)2, (long)position[i]);
            }
        }
        return origin;
    }
}

