/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import ij.ImagePlus;
import java.util.AbstractList;
import net.imagej.ImgPlus;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.display.imagej.PlanarImgToVirtualStack;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class CellImgToVirtualStack {
    public static boolean isSupported(ImgPlus<?> imgPlus) {
        return CellImgToVirtualStack.isCellImgWithPlanarCells(imgPlus.getImg()) && PlanarImgToVirtualStack.isSupported(CellImgToVirtualStack.toPlanarImgPlus(imgPlus));
    }

    private static boolean isCellImgWithPlanarCells(Img<?> imgPlus) {
        return imgPlus instanceof AbstractCellImg && CellImgToVirtualStack.areCellsPlanar(((AbstractCellImg)imgPlus).getCellGrid());
    }

    private static boolean areCellsPlanar(CellGrid cellGrid) {
        int i;
        for (i = 0; i < 2; ++i) {
            if ((long)cellGrid.cellDimension(i) >= cellGrid.imgDimension(i)) continue;
            return false;
        }
        for (i = 2; i < cellGrid.numDimensions(); ++i) {
            if (cellGrid.cellDimension(i) == 1 || cellGrid.imgDimension(i) == 1L) continue;
            return false;
        }
        return true;
    }

    public static ImagePlus wrap(ImgPlus<?> imgPlus) {
        return PlanarImgToVirtualStack.wrap(CellImgToVirtualStack.toPlanarImgPlus(imgPlus));
    }

    private static <T> ImgPlus<T> toPlanarImgPlus(ImgPlus<T> image) {
        if (!CellImgToVirtualStack.isCellImgWithPlanarCells(image.getImg())) {
            throw new IllegalArgumentException("ERROR: Image must be a CellImg, with planar cells.");
        }
        return new ImgPlus(CellImgToVirtualStack.toPlanar((AbstractCellImg)image.getImg()), image);
    }

    private static <T extends NativeType<T>, A extends ArrayDataAccess<A>> PlanarImg<?, ?> toPlanar(AbstractCellImg<T, A, ?, ?> cellImage) {
        long[] dim = Intervals.dimensionsAsLongArray(cellImage);
        NativeType type = (NativeType)((NativeType)Util.getTypeFromInterval(cellImage)).copy();
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        SlicesList<A> slices = new SlicesList<A>(cellImage);
        PlanarImg ts = new PlanarImg(slices, dim, entitiesPerPixel);
        ts.setLinkedType(type.getNativeTypeFactory().createLinkedType((NativeImg)ts));
        return ts;
    }

    private static class SlicesList<A extends ArrayDataAccess<?>>
    extends AbstractList<A> {
        final RandomAccessible<? extends Cell<A>> cells;
        final Dimensions gridDim;

        public SlicesList(AbstractCellImg<?, A, ?, ?> cellImage) {
            this.cells = cellImage.getCells();
            this.gridDim = new FinalDimensions(cellImage.getCellGrid().getGridDimensions());
        }

        @Override
        public A set(int index, A element) {
            A destination = this.get(index);
            System.arraycopy(element.getCurrentStorageArray(), 0, destination.getCurrentStorageArray(), 0, Math.min(element.getArrayLength(), destination.getArrayLength()));
            return destination;
        }

        @Override
        public A get(int index) {
            RandomAccess ra = this.cells.randomAccess();
            IntervalIndexer.indexToPosition((long)index, (Dimensions)this.gridDim, (Positionable)ra);
            return (A)((ArrayDataAccess)((Cell)ra.get()).getData());
        }

        @Override
        public int size() {
            return (int)Intervals.numElements((Dimensions)this.gridDim);
        }
    }
}

