/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.commands.io;

import java.io.File;
import java.io.IOException;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.io.IOPlugin;
import org.scijava.io.IOService;
import org.scijava.io.location.FileLocation;
import org.scijava.io.location.Location;
import org.scijava.log.LogService;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.DialogPrompt;
import org.scijava.ui.UIService;

@Plugin(type=Command.class, iconPath="/icons/commands/folder_picture.png", menu={@Menu(label="File", weight=0.0, mnemonic=102), @Menu(label="Open...", weight=1.0, mnemonic=111, accelerator="^O")}, attrs={@Attr(name="no-legacy")})
public class OpenFile
extends ContextCommand {
    @Parameter
    private LogService log;
    @Parameter
    private IOService ioService;
    @Parameter
    private UIService uiService;
    @Parameter(label="File to open")
    private File inputFile;
    @Parameter(type=ItemIO.OUTPUT, label="Data")
    private Object data;

    public void run() {
        try {
            FileLocation source = new FileLocation(this.inputFile);
            IOPlugin opener = this.ioService.getOpener((Location)source);
            if (opener == null) {
                this.error("No appropriate format found: " + source);
                return;
            }
            this.data = opener.open((Location)source);
            if (this.data == null) {
                this.cancel(null);
                return;
            }
        }
        catch (IOException exc) {
            this.log.error((Throwable)exc);
            this.error(exc.getMessage());
        }
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    private void error(String message) {
        this.uiService.showDialog(message, DialogPrompt.MessageType.ERROR_MESSAGE);
    }
}

