/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.utils;

import ch.epfl.biop.utils.IJLogger;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.process.FloatProcessor;
import ij.process.ImageStatistics;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;

public class Tools {
    private static final int HEAT_MAP_SCALED_SIZE = 256;
    private static final String HEAT_MAP_BIT_DEPTH = "32-bit black";
    public static final String SEPARATION_CHARACTER = "%";
    public static final String PROCESSED_IMAGES_SUFFIX = "processed_images";
    public static final String PARENT_TABLE_SUFFIX = "table";
    public static final String PROCESSED_FEATURE = "feature";
    public static final String FWHM_TAG = "fwhm";
    public static final String FIELD_DISTORTION_TAG = "field_distortion";
    public static final String FIELD_UNIFORMITY_TAG = "field_uniformity";
    public static final String ARGOLIGHT_TAG = "argolight";
    public static final String RAW_TAG = "raw";
    public static final String PROCESSED_TAG = "processed";
    public static final String FULL_FOV = "fullFoV";
    public static final String PARTIAL_FOV = "partialFoV";

    public static String getCurrentDateAndHour() {
        LocalDateTime localDateTime = LocalDateTime.now();
        LocalTime localTime = localDateTime.toLocalTime();
        LocalDate localDate = localDateTime.toLocalDate();
        return String.valueOf(localDate.getYear()) + (localDate.getMonthValue() < 10 ? "0" + localDate.getMonthValue() : Integer.valueOf(localDate.getMonthValue())) + (localDate.getDayOfMonth() < 10 ? "0" + localDate.getDayOfMonth() : Integer.valueOf(localDate.getDayOfMonth())) + "-" + (localTime.getHour() < 10 ? "0" + localTime.getHour() : Integer.valueOf(localTime.getHour())) + "h" + (localTime.getMinute() < 10 ? "0" + localTime.getMinute() : Integer.valueOf(localTime.getMinute())) + "m" + (localTime.getSecond() < 10 ? "0" + localTime.getSecond() : Integer.valueOf(localTime.getSecond()));
    }

    public static String getErrorStackTraceAsString(Exception e) {
        return Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).reduce("", (a, b) -> a + "     at " + b + "\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveCsvFile(File file, String text) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file));){
            bw.write(text);
            IJLogger.info("Saving csv file", "File successfully saved in " + file.getAbsolutePath());
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            IJLogger.error("Saving csv file", "Error when saving csv in " + file.getAbsolutePath(), e);
            return false;
        }
    }

    public static List<String> readCsvFile(File table) {
        try {
            ArrayList<String> rows = new ArrayList<String>();
            try (BufferedReader br = new BufferedReader(new FileReader(table));){
                String line = "";
                while ((line = br.readLine()) != null) {
                    rows.add(line);
                }
            }
            return rows;
        }
        catch (IOException e) {
            IJLogger.error("Reading csv file", "Error when reading csv " + table.getAbsolutePath(), e);
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean appendCsvFile(File file, String text) {
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, true));){
            bw.write(text);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            IJLogger.error("Updating csv File", "Error when trying to update csv file in " + file.getAbsolutePath(), e);
            return false;
        }
    }

    public static double[] computeStatistics(List<Double> values) {
        if (values.isEmpty()) {
            return new double[]{0.0, 0.0, 0.0, 0.0};
        }
        double average = values.stream().reduce(0.0, Double::sum) / (double)values.size();
        ArrayList stdList = new ArrayList();
        values.forEach(e -> stdList.add(Math.pow(e - average, 2.0)));
        double std = Math.sqrt(stdList.stream().reduce(0.0, Double::sum) / (double)values.size());
        double min = (Double)values.stream().min(Comparator.naturalOrder()).get();
        double max = (Double)values.stream().max(Comparator.naturalOrder()).get();
        return new double[]{average, std, min, max};
    }

    public static ImagePlus computeHeatMap(List<Double> values, String title, int imgWidth, int imgHeight, Roi cross, double rotation, double pixelSize, int argoSpacing) {
        int nPoints = (int)Math.sqrt(values.size() + 1);
        ImagePlus imp = IJ.createImage((String)title, (String)HEAT_MAP_BIT_DEPTH, (int)nPoints, (int)nPoints, (int)1);
        values.add((int)Math.floor((double)values.size() / 2.0), Double.NaN);
        FloatProcessor fp = new FloatProcessor(nPoints, nPoints, values.stream().mapToDouble(Double::doubleValue).toArray());
        values.remove((int)Math.floor((double)values.size() / 2.0));
        imp.getProcessor().setPixels(1, fp);
        ImagePlus heatMapScaledImp = IJ.createImage((String)title, (String)HEAT_MAP_BIT_DEPTH, (int)(256 * imgWidth / imgHeight), (int)256, (int)1);
        double ratio = (double)(nPoints * argoSpacing) / pixelSize / (double)imgWidth;
        int targetScaledSize = (int)((double)heatMapScaledImp.getWidth() * ratio);
        ImagePlus enlarged_imp = imp.resize(Math.max(targetScaledSize, 1), Math.max(targetScaledSize, 1), "none");
        double cos = Math.cos(rotation);
        double sin = Math.sin(rotation);
        double halfSize = (double)targetScaledSize / 2.0;
        ImageStatistics crossStat = cross.getStatistics();
        double scaledCrossX = crossStat.xCentroid * (double)heatMapScaledImp.getWidth() / (double)imgWidth;
        double scaledCrossY = crossStat.yCentroid * (double)heatMapScaledImp.getHeight() / (double)imgHeight;
        for (int i = 0; i < enlarged_imp.getWidth(); ++i) {
            for (int j = 0; j < enlarged_imp.getHeight(); ++j) {
                int transformX = (int)(((double)i - halfSize) * cos - ((double)j - halfSize) * sin + scaledCrossX);
                int transformY = (int)(((double)i - halfSize) * sin + ((double)j - halfSize) * cos + scaledCrossY);
                if (transformX < 0 || transformX >= heatMapScaledImp.getWidth() || transformY < 0 || transformY >= heatMapScaledImp.getHeight()) continue;
                heatMapScaledImp.getProcessor().putPixelValue(transformX, transformY, (double)enlarged_imp.getProcessor().getPixelValue(i, j));
            }
        }
        heatMapScaledImp.setTitle(title);
        IJ.run((ImagePlus)heatMapScaledImp, (String)"Fire", (String)"");
        heatMapScaledImp.show();
        return heatMapScaledImp;
    }

    public static List<Double> computePCC(ImagePlus imp1, ImagePlus imp2, List<Roi> rois) {
        ArrayList<ImagePlus> imp1Crops = new ArrayList<ImagePlus>();
        ArrayList<ImagePlus> imp2Crops = new ArrayList<ImagePlus>();
        rois.forEach(roi -> {
            imp1.setRoi(roi);
            imp1Crops.add(imp1.crop());
            imp2.setRoi(roi);
            imp2Crops.add(imp2.crop());
        });
        return Tools.computePCC(imp1Crops, imp2Crops);
    }

    private static List<Double> computePCC(List<ImagePlus> impList1, List<ImagePlus> impList2) {
        if (impList1.size() != impList2.size()) {
            IJLogger.error("computePCC", "Images lists do not have the same size :  " + impList1.size() + " vs " + impList2.size());
            return new ArrayList<Double>();
        }
        ArrayList<Double> pccList = new ArrayList<Double>();
        for (int i = 0; i < impList1.size(); ++i) {
            pccList.add(Tools.computePCC(impList1.get(i), impList2.get(i)));
        }
        return pccList;
    }

    private static double computePCC(ImagePlus imp1, ImagePlus imp2) {
        if (imp1.getWidth() != imp2.getWidth() || imp1.getHeight() != imp2.getHeight()) {
            IJLogger.error("computePCC", "Image patches do not have the same dimensions ; w x h : " + imp1.getWidth() + " x " + imp1.getHeight() + " and " + imp2.getWidth() + " x " + imp2.getHeight());
            return Double.NaN;
        }
        ArrayList<Float> array1 = new ArrayList<Float>();
        ArrayList<Float> array2 = new ArrayList<Float>();
        for (int k = 0; k < imp1.getWidth(); ++k) {
            for (int l = 0; l < imp1.getHeight(); ++l) {
                array1.add(Float.valueOf(imp1.getProcessor().getPixelValue(k, l)));
                array2.add(Float.valueOf(imp2.getProcessor().getPixelValue(k, l)));
            }
        }
        PearsonsCorrelation pcc = new PearsonsCorrelation();
        return pcc.correlation(array1.stream().mapToDouble(Float::floatValue).toArray(), array2.stream().mapToDouble(Float::floatValue).toArray());
    }
}

