/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.senders;

import ch.epfl.biop.image.ImageFile;
import ch.epfl.biop.retrievers.OMERORetriever;
import ch.epfl.biop.retrievers.Retriever;
import ch.epfl.biop.senders.Sender;
import ch.epfl.biop.utils.IJLogger;
import ch.epfl.biop.utils.Tools;
import fr.igred.omero.Client;
import fr.igred.omero.GenericObjectWrapper;
import fr.igred.omero.annotations.FileAnnotationWrapper;
import fr.igred.omero.annotations.GenericAnnotationWrapper;
import fr.igred.omero.annotations.MapAnnotationWrapper;
import fr.igred.omero.annotations.TableWrapper;
import fr.igred.omero.annotations.TagAnnotationWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.DatasetWrapper;
import fr.igred.omero.repository.GenericRepositoryObjectWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.roi.ROIWrapper;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.process.ImageStatistics;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.DataObject;
import omero.gateway.model.EllipseData;
import omero.gateway.model.FileAnnotationData;
import omero.gateway.model.ImageData;
import omero.gateway.model.MapAnnotationData;
import omero.gateway.model.ROIData;
import omero.gateway.model.RectangleData;
import omero.gateway.model.ShapeData;
import omero.gateway.model.TableData;
import omero.gateway.model.TableDataColumn;
import omero.gateway.model.TagAnnotationData;
import omero.model.NamedValue;

public class OMEROSender
implements Sender {
    final Client client;
    private final String ARGOLIGHT_NAMESPACE = "ArgoLight analysis";
    private final String date;
    private final boolean cleanTarget;
    private final String datasetId;
    private ImageWrapper imageWrapper;
    private boolean cleanParent;

    public OMEROSender(Client client, String datasetTarget, boolean cleanTarget) {
        this.client = client;
        this.datasetId = datasetTarget;
        this.date = Tools.getCurrentDateAndHour();
        this.cleanTarget = cleanTarget;
        this.cleanParent = cleanTarget;
    }

    @Override
    public void initialize(ImageFile imageFile, Retriever retriever) {
        this.imageWrapper = ((OMERORetriever)retriever).getImageWrapper(imageFile.getId());
        if (this.cleanTarget) {
            this.clean();
        }
    }

    @Override
    public void sendTags(List<String> tags) {
        this.sendTags(tags, this.imageWrapper);
    }

    private void sendTags(List<String> tags, ImageWrapper imageWrapper) {
        List imageTags;
        List groupTags;
        IJLogger.info("Adding tag");
        try {
            groupTags = this.client.getTags();
            imageTags = imageWrapper.getTags(this.client);
        }
        catch (AccessException | OMEROServerError | ServiceException | ExecutionException e) {
            IJLogger.error("Adding tag", "Cannot retrieve existing & linked tags from OMERO", (Exception)e);
            return;
        }
        for (String tag : tags) {
            try {
                List rawTag = groupTags.stream().filter(t -> t.getName().equals(tag)).collect(Collectors.toList());
                boolean isTagAlreadyExists = imageTags.stream().anyMatch(t -> t.getName().equals(tag));
                if (!isTagAlreadyExists) {
                    imageWrapper.link(this.client, (GenericAnnotationWrapper)(rawTag.isEmpty() ? new TagAnnotationWrapper(new TagAnnotationData(tag)) : (TagAnnotationWrapper)rawTag.get(0)));
                    IJLogger.info("Adding tag", "The tag " + tag + " has been successfully applied on the image " + imageWrapper.getId());
                    continue;
                }
                IJLogger.info("Adding tag", "The tag " + tag + " is already applied on the image " + imageWrapper.getId());
            }
            catch (AccessException | ServiceException | ExecutionException e) {
                IJLogger.error("Adding tag", "The tag " + tag + " could not be applied on the image " + imageWrapper.getId(), (Exception)e);
            }
        }
    }

    @Override
    public void clean() {
        IJLogger.info("Cleaning target...");
        try {
            IJLogger.info("Cleaning target", "Unlink tags from image " + this.imageWrapper.getId());
            List tags = this.imageWrapper.getTags(this.client);
            for (TagAnnotationWrapper tag : tags) {
                this.imageWrapper.unlink(this.client, (GenericAnnotationWrapper)tag);
            }
            IJLogger.info("Cleaning target", "Tags unlinked");
        }
        catch (OMEROServerError | InterruptedException | ExecutionException | DSAccessException | DSOutOfServiceException e) {
            IJLogger.error("Cleaning target", "Cannot unlink tags for image " + this.imageWrapper.getId(), (Exception)e);
        }
        try {
            IJLogger.info("Cleaning target", "Removing key-values from image " + this.imageWrapper.getId());
            List keyValues = this.client.getMetadata().getAnnotations(this.client.getCtx(), this.imageWrapper.asDataObject()).stream().filter(MapAnnotationData.class::isInstance).map(MapAnnotationData.class::cast).map(DataObject::asIObject).collect(Collectors.toList());
            if (keyValues.isEmpty()) {
                IJLogger.warn("Cleaning target", "No Key-values to remove");
            } else {
                this.client.getDm().delete(this.client.getCtx(), keyValues);
                IJLogger.info("Cleaning target", "Key-values removed");
            }
        }
        catch (ExecutionException | DSAccessException | DSOutOfServiceException e) {
            IJLogger.error("Cleaning target", "Cannot delete key-values for image " + this.imageWrapper.getId(), (Exception)e);
        }
        try {
            IJLogger.info("Cleaning target", "Removing tables from image " + this.imageWrapper.getId());
            List tables = this.imageWrapper.getTables(this.client);
            if (tables.isEmpty()) {
                IJLogger.warn("Cleaning target", "No table to remove");
            } else {
                this.client.deleteTables((Collection)tables);
                IJLogger.info("Cleaning target", "Tables removed");
            }
        }
        catch (OMEROServerError | InterruptedException | ExecutionException | DSAccessException | DSOutOfServiceException e) {
            IJLogger.error("Cleaning target", "Cannot delete tables for image " + this.imageWrapper.getId(), (Exception)e);
        }
        try {
            IJLogger.info("Cleaning target", "Removing ROIs from image " + this.imageWrapper.getId());
            List rois = this.imageWrapper.getROIs(this.client).stream().map(GenericObjectWrapper::asDataObject).map(DataObject::asIObject).collect(Collectors.toList());
            if (rois.isEmpty()) {
                IJLogger.warn("Cleaning target", "No ROIs to remove");
            } else {
                this.client.getDm().delete(this.client.getCtx(), rois);
                IJLogger.info("Cleaning target", "ROIs removed");
            }
        }
        catch (ExecutionException | DSAccessException | DSOutOfServiceException e) {
            IJLogger.error("Cleaning target", "Cannot delete ROIs for image " + this.imageWrapper.getId(), (Exception)e);
        }
        if (this.cleanParent) {
            this.cleanParent = false;
            try {
                IJLogger.info("Cleaning target", "Removing parent table from image " + this.imageWrapper.getId());
                List dataset = this.imageWrapper.getDatasets(this.client);
                List tables = ((DatasetWrapper)dataset.get(0)).getTables(this.client);
                if (tables.isEmpty()) {
                    IJLogger.warn("Cleaning target", "No parent table to remove");
                } else {
                    this.client.deleteTables((Collection)tables);
                    IJLogger.info("Cleaning target", "Parent table removed");
                }
            }
            catch (OMEROServerError | InterruptedException | ExecutionException | DSAccessException | DSOutOfServiceException e) {
                IJLogger.error("Cleaning target", "Cannot delete parent tables for image " + this.imageWrapper.getId(), (Exception)e);
            }
        }
    }

    @Override
    public void sendHeatMaps(final ImagePlus imp) {
        IJLogger.info("Sending heatmap");
        String home = Prefs.getHomeDir();
        File localImageFile = OMEROSender.saveHeatMapLocally(imp, home);
        if (localImageFile == null) {
            IJLogger.error("Saving temporary heatMap", "Cannot save temporary image " + imp.getTitle() + " in " + home);
            return;
        }
        try {
            List analysisImage_omeroID = this.client.getDataset(Long.valueOf(Long.parseLong(this.datasetId))).importImage(this.client, localImageFile.toString());
            ImageWrapper analysisImage_wpr = this.client.getImage((Long)analysisImage_omeroID.get(0));
            IJLogger.info("Sending heatmap", imp.getTitle() + ".tif was uploaded to OMERO with ID : " + analysisImage_omeroID);
            ArrayList<String> tags = new ArrayList<String>(){
                {
                    this.add("processed");
                    this.add("argolight");
                    this.add((String)imp.getProperty("feature"));
                }
            };
            this.sendTags((List<String>)tags, analysisImage_wpr);
        }
        catch (AccessException | OMEROServerError | ServiceException | ExecutionException e) {
            IJLogger.error("Sending heatmap", "Cannot upload heat maps on OMERO", (Exception)e);
        }
        boolean hasBeenDeleted = localImageFile.delete();
        if (hasBeenDeleted) {
            IJLogger.info("Upload heatMap", "Temporary image deleted");
        } else {
            IJLogger.error("Upload heatMap", "Cannot delete temporary image from " + localImageFile.getAbsolutePath());
        }
    }

    @Override
    public void sendKeyValues(Map<String, String> keyValues) {
        IJLogger.info("Sending Key-values");
        if (!keyValues.isEmpty()) {
            ArrayList<NamedValue> namedValues = new ArrayList<NamedValue>();
            namedValues.add(new NamedValue("Processing date", this.date));
            keyValues.forEach((key, value) -> namedValues.add(new NamedValue(key, value)));
            MapAnnotationWrapper newKeyValues = new MapAnnotationWrapper(namedValues);
            newKeyValues.setNameSpace("ArgoLight analysis");
            try {
                this.imageWrapper.link(this.client, (GenericAnnotationWrapper)newKeyValues);
                IJLogger.info("Sending Key-values", "Key-values have been successfully applied on the image " + this.imageWrapper.getId());
            }
            catch (AccessException | ServiceException | ExecutionException e) {
                IJLogger.error("Sending Key-Values", "Key-values could not be uploaded and linked to the image " + this.imageWrapper.getId(), (Exception)e);
            }
        } else {
            IJLogger.warn("Sending Key-Values", "There is no key-values to send to OMERO");
        }
    }

    @Override
    public void sendGridPoints(List<Roi> rois, int channelId, String roiTitle) {
        IJLogger.info("Sending " + roiTitle + " ROIs");
        if (!rois.isEmpty()) {
            List<ShapeData> gridShapes = this.convertIJRoisToShapeData(rois, channelId);
            final ROIData roiGrid = new ROIData();
            gridShapes.forEach(arg_0 -> ((ROIData)roiGrid).addShapeData(arg_0));
            ArrayList<ROIWrapper> omeroRois = new ArrayList<ROIWrapper>(){
                {
                    this.add(new ROIWrapper(roiGrid));
                }
            };
            ((ROIWrapper)omeroRois.get(0)).setName(this.date + "_" + roiTitle);
            try {
                this.imageWrapper.saveROIs(this.client, (Collection)omeroRois);
                IJLogger.info("Sending " + roiTitle + " ROIs", "The ROIs have been successfully uploaded and linked to the image " + this.imageWrapper.getId());
            }
            catch (ExecutionException | DSAccessException | DSOutOfServiceException e) {
                IJLogger.error("Sending " + roiTitle + " ROIs", "Error during saving ROIs on OMERO.", (Exception)e);
            }
        } else {
            IJLogger.info("Sending " + roiTitle + " ROIs", "There is no Annotations to upload on OMERO");
        }
    }

    @Override
    public void sendPCCTable(List<List<Double>> pccValues, int nChannels) {
        int i;
        IJLogger.info("Sending PCC table");
        ArrayList<TableDataColumn> columns = new ArrayList<TableDataColumn>();
        ArrayList<ArrayList<Double>> measurements = new ArrayList<ArrayList<Double>>();
        ArrayList<Integer> chs1 = new ArrayList<Integer>();
        ArrayList<Integer> chs2 = new ArrayList<Integer>();
        for (i = 0; i < nChannels - 1; ++i) {
            for (int j = i + 1; j < nChannels; ++j) {
                chs1.add(i);
                chs2.add(j);
            }
        }
        i = 0;
        for (List<Double> channelPair : pccValues) {
            columns.add(new TableDataColumn("ch" + chs1.get(i) + "_ch" + chs2.get(i), i++, Double.class));
            measurements.add(new ArrayList<Double>(channelPair));
        }
        if (!columns.isEmpty()) {
            try {
                TableWrapper tableWrapper = new TableWrapper(new TableData(columns, measurements));
                tableWrapper.setName(this.date + "_PCC_table");
                this.sendAttachment(this.client, (GenericRepositoryObjectWrapper<?>)this.imageWrapper, tableWrapper);
                IJLogger.info("Sending PCC table", "PCC table has been successfully uploaded and linked to the image " + this.imageWrapper.getId());
            }
            catch (ExecutionException | DSAccessException | DSOutOfServiceException e) {
                IJLogger.error("Sending PCC table", "Cannot add the results table to image " + this.imageWrapper.getName() + " : " + this.imageWrapper.getId(), (Exception)e);
            }
        } else {
            IJLogger.warn("Saving PCC table", "No results to save");
        }
    }

    @Override
    public void sendResultsTable(List<List<Double>> values, List<Integer> channelIdList, boolean createNewTable, String tableName) {
        IJLogger.info("Sending " + tableName + " table");
        TableWrapper table = OMEROSender.getOmeroTable(this.client, this.imageWrapper, tableName);
        TableWrapper tableWrapper = !createNewTable && table != null ? this.addNewColumnsToTable(table, values, channelIdList, this.date) : this.createNewTable(values, channelIdList, this.date);
        try {
            tableWrapper.setName(tableName);
            this.sendAttachment(this.client, (GenericRepositoryObjectWrapper<?>)this.imageWrapper, tableWrapper);
            if (table != null) {
                this.client.deleteTable(table);
            }
            IJLogger.info("Sending " + tableName + " table", tableName + " table has been successfully uploaded and linked to the image " + this.imageWrapper.getId());
        }
        catch (OMEROServerError | InterruptedException | ExecutionException | DSAccessException | DSOutOfServiceException e) {
            IJLogger.error("Sending " + tableName + " table", "Cannot add the " + tableName + " table to image " + this.imageWrapper.getName() + " : " + this.imageWrapper.getId(), (Exception)e);
        }
    }

    @Override
    public void populateParentTable(Retriever retriever, Map<String, List<List<Double>>> summary, List<String> headers, boolean populateExistingTable) {
        IJLogger.info("Update parent table...");
        ArrayList<Object[]> fullRows = new ArrayList<Object[]>();
        for (Map.Entry<String, List<List<Double>>> IdEntry : summary.entrySet()) {
            List<List<Double>> allChannelMetrics = IdEntry.getValue();
            ArrayList<ArrayList<Double>> allChannelMetricsAsObject = new ArrayList<ArrayList<Double>>();
            for (List<Double> objects : allChannelMetrics) {
                allChannelMetricsAsObject.add(new ArrayList<Double>(objects));
            }
            String omeroID = IdEntry.getKey().split("%")[1];
            ImageWrapper image = ((OMERORetriever)retriever).getImageWrapper(omeroID);
            for (List list : allChannelMetricsAsObject) {
                list.add(0, image.getName());
                list.add(0, image.asDataObject());
                fullRows.add(list.toArray());
            }
        }
        try {
            DatasetWrapper dataset = this.client.getDataset(Long.valueOf(Long.parseLong(this.datasetId)));
            if (populateExistingTable) {
                TableWrapper tableWrapper = OMEROSender.getLastOmeroTable(this.client, dataset);
                if (tableWrapper == null) {
                    this.addNewParentTable((List<Object[]>)fullRows, headers, (GenericRepositoryObjectWrapper<?>)dataset, this.date);
                } else {
                    this.replaceExistingParentTable((List<Object[]>)fullRows, (GenericRepositoryObjectWrapper<?>)dataset, tableWrapper, this.date);
                }
            } else {
                this.addNewParentTable((List<Object[]>)fullRows, headers, (GenericRepositoryObjectWrapper<?>)dataset, this.date);
            }
            IJLogger.info("Update parent table", "New analysis summaries have been uploaded and linked to dataset " + dataset.getName() + " : " + dataset.getId());
        }
        catch (ServiceException | ExecutionException | DSAccessException e) {
            IJLogger.error("Update parent table", "Cannot add the summaries to the parent table on dataset " + this.datasetId, (Exception)e);
        }
    }

    private void sendAttachment(Client client, GenericRepositoryObjectWrapper<?> repoWrapper, TableWrapper tableWrapper) throws DSAccessException, DSOutOfServiceException, ExecutionException {
        repoWrapper.addTable(client, tableWrapper);
        long fileId = tableWrapper.getFileId();
        FileAnnotationWrapper originalFile = repoWrapper.getFileAnnotations(client).stream().filter(e -> e.getFileID() == fileId).findFirst().orElse(null);
        if (originalFile != null) {
            originalFile.setNameSpace("ArgoLight analysis");
            client.getDm().updateObject(client.getCtx(), ((FileAnnotationData)originalFile.asDataObject()).asIObject(), null);
        }
    }

    private TableWrapper createNewTable(List<List<Double>> values, List<Integer> channelIdList, String date) {
        ArrayList<TableDataColumn> columns = new ArrayList<TableDataColumn>();
        ArrayList measurements = new ArrayList();
        int i = 0;
        if (values.size() > 0) {
            columns.add(new TableDataColumn("Image ID", i++, ImageData.class));
            ArrayList<DataObject> imageData = new ArrayList<DataObject>();
            for (Double ignored : values.get(0)) {
                imageData.add(this.imageWrapper.asDataObject());
            }
            measurements.add(imageData);
            columns.add(new TableDataColumn("Ring ID", i++, Long.class));
            ArrayList ids = new ArrayList();
            LongStream.range(0L, values.get(0).size()).forEach(ids::add);
            measurements.add(ids);
            for (int j = 0; j < values.size(); ++j) {
                columns.add(new TableDataColumn("ch" + channelIdList.get(j) + "_" + date, i++, Double.class));
                measurements.add(new ArrayList(values.get(j)));
            }
        }
        return new TableWrapper(new TableData(columns, measurements));
    }

    private TableWrapper addNewColumnsToTable(TableWrapper tableToPopulate, List<List<Double>> values, List<Integer> channelIdList, String date) {
        Object[][] data;
        TableData tableData = tableToPopulate.createTable();
        ArrayList<TableDataColumn> columns = new ArrayList<TableDataColumn>(Arrays.asList(tableData.getColumns()));
        ArrayList<List<Object>> measurements = new ArrayList<List<Object>>();
        for (Object[] datum : data = tableData.getData()) {
            measurements.add(Arrays.asList(datum));
        }
        int i = data.length;
        if (values.size() > 0) {
            for (int j = 0; j < values.size(); ++j) {
                columns.add(new TableDataColumn("ch" + channelIdList.get(j) + "_" + date, i++, Double.class));
                measurements.add(new ArrayList(values.get(j)));
            }
        }
        return new TableWrapper(new TableData(columns, measurements));
    }

    private void addNewParentTable(List<Object[]> fullRows, List<String> headers, GenericRepositoryObjectWrapper<?> repoWrapper, String date) {
        try {
            TableWrapper tableWrapper = new TableWrapper(headers.size() + 2, date + "_" + repoWrapper.getName() + "_Table");
            tableWrapper.setColumn(0, "Image", ImageData.class);
            tableWrapper.setColumn(1, "Label", String.class);
            int i = 2;
            for (String header : headers) {
                tableWrapper.setColumn(i++, header, Double.class);
            }
            tableWrapper.setRowCount(fullRows.size());
            for (Object[] row : fullRows) {
                tableWrapper.addRow(row);
            }
            this.sendAttachment(this.client, repoWrapper, tableWrapper);
        }
        catch (ExecutionException | DSAccessException | DSOutOfServiceException e) {
            IJLogger.error("Cannot add the results table to image " + this.imageWrapper.getName() + " : " + this.imageWrapper.getId(), (Exception)e);
        }
    }

    private void replaceExistingParentTable(List<Object[]> fullRows, GenericRepositoryObjectWrapper<?> repoWrapper, TableWrapper tableWrapper, String date) {
        try {
            int nExistingRows = tableWrapper.getRowCount();
            tableWrapper.setRowCount(nExistingRows + fullRows.size());
            for (Object[] row : fullRows) {
                tableWrapper.addRow(row);
            }
            TableWrapper newTable = new TableWrapper(tableWrapper.createTable());
            newTable.setName(date + "_" + repoWrapper.getName() + "_Table");
            this.sendAttachment(this.client, repoWrapper, newTable);
            this.client.deleteTable(tableWrapper);
        }
        catch (ExecutionException | DSAccessException | DSOutOfServiceException e) {
            IJLogger.error("Cannot add results to previous table " + tableWrapper.getName() + " : " + tableWrapper.getId(), (Exception)e);
        }
        catch (OMEROServerError | InterruptedException e) {
            IJLogger.error("Cannot delete previous table " + tableWrapper.getName() + " : " + tableWrapper.getId(), (Exception)e);
        }
    }

    public static File saveHeatMapLocally(ImagePlus imp, String folder) {
        FileSaver fs = new FileSaver(imp);
        File analysisImage_output_path = new File(folder, imp.getTitle() + ".tif");
        boolean hasBeenSaved = fs.saveAsTiff(analysisImage_output_path.toString());
        if (!hasBeenSaved) {
            return null;
        }
        return analysisImage_output_path;
    }

    private List<ShapeData> convertIJRoisToShapeData(List<Roi> rois, int channelId) {
        ArrayList<ShapeData> shapes = new ArrayList<ShapeData>();
        block4: for (int i = 0; i < rois.size(); ++i) {
            Roi roi = rois.get(i);
            int type = roi.getType();
            ImageStatistics roiStat = roi.getStatistics();
            switch (type) {
                case 1: {
                    EllipseData ellipse = new EllipseData(roiStat.xCentroid, roiStat.yCentroid, roiStat.roiWidth / 2.0, roiStat.roiHeight / 2.0);
                    ellipse.setText(i + ":child");
                    ellipse.setC(channelId);
                    ellipse.getShapeSettings().setStroke(roi.getStrokeColor());
                    ellipse.getShapeSettings().setFill(roi.getFillColor());
                    shapes.add((ShapeData)ellipse);
                    continue block4;
                }
                case 0: {
                    RectangleData rectangle = new RectangleData(roiStat.roiX, roiStat.roiY, roiStat.roiWidth, roiStat.roiHeight);
                    rectangle.setText(i + ":child");
                    rectangle.setC(channelId);
                    shapes.add((ShapeData)rectangle);
                }
            }
        }
        return shapes;
    }

    private static TableWrapper getLastOmeroTable(Client client, GenericRepositoryObjectWrapper<?> repoWrapper) {
        try {
            List repoTables = repoWrapper.getTables(client);
            if (!repoTables.isEmpty()) {
                List<String> names = repoTables.stream().map(TableWrapper::getName).collect(Collectors.toList());
                ArrayList orderedDate = new ArrayList();
                names.forEach(name -> orderedDate.add(name.split("_")[0]));
                orderedDate.sort(Comparator.reverseOrder());
                return (TableWrapper)repoTables.stream().filter(e -> e.getName().contains((CharSequence)orderedDate.get(0))).collect(Collectors.toList()).get(0);
            }
            return null;
        }
        catch (AccessException | ServiceException | ExecutionException e2) {
            IJLogger.error("Could not get tables attached to " + repoWrapper.getName() + " (" + repoWrapper.getId() + ")", (Exception)e2);
            return null;
        }
    }

    private static TableWrapper getOmeroTable(Client client, GenericRepositoryObjectWrapper<?> repoWrapper, String tableName) {
        try {
            List tableList = repoWrapper.getTables(client).stream().filter(e -> e.getName().contains(tableName)).collect(Collectors.toList());
            if (!tableList.isEmpty()) {
                return (TableWrapper)tableList.get(0);
            }
            return null;
        }
        catch (ExecutionException | DSAccessException | DSOutOfServiceException e2) {
            IJLogger.error("Could not get table " + tableName + " attached to " + repoWrapper.getName() + " (" + repoWrapper.getId() + ")", (Exception)e2);
            return null;
        }
    }
}

