/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.senders;

import ch.epfl.biop.image.ImageFile;
import ch.epfl.biop.retrievers.OMERORetriever;
import ch.epfl.biop.retrievers.Retriever;
import ch.epfl.biop.senders.Sender;
import ch.epfl.biop.utils.IJLogger;
import ch.epfl.biop.utils.Tools;
import fr.igred.omero.Client;
import fr.igred.omero.annotations.GenericAnnotationWrapper;
import fr.igred.omero.annotations.TagAnnotationWrapper;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.OMEROServerError;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.ImageWrapper;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.io.FileSaver;
import ij.io.RoiEncoder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import omero.gateway.exception.DSAccessException;
import omero.gateway.exception.DSOutOfServiceException;
import omero.gateway.model.TagAnnotationData;
import org.apache.commons.io.FileUtils;

public class LocalSender
implements Sender {
    private final String parentFolder;
    private final boolean cleanTarget;
    private final String date = Tools.getCurrentDateAndHour();
    private String imageFolder;
    private boolean cleanParent;
    private ImageWrapper imageWrapper;
    private Client client;
    private boolean updateProcessedImageFile;

    public LocalSender(File target, String microscopeName, boolean cleanTarget, boolean isOmeroRetriever) {
        this.cleanTarget = cleanTarget;
        this.cleanParent = cleanTarget;
        if (!target.getName().toLowerCase().contains(microscopeName)) {
            File[] files = target.listFiles();
            if (files != null) {
                List microscopeList = Arrays.stream(files).filter(e -> e.isDirectory() && e.getName().toLowerCase().contains(microscopeName)).collect(Collectors.toList());
                if (microscopeList.isEmpty()) {
                    IJLogger.info("Initialization", "Create a new folder");
                    this.parentFolder = this.createMicroscopeFolder(target, microscopeName);
                } else {
                    IJLogger.info("Initialization", "Select folder " + ((File)microscopeList.get(0)).getAbsolutePath());
                    this.parentFolder = ((File)microscopeList.get(0)).getAbsolutePath();
                }
            } else {
                IJLogger.info("Initialization", "Create a new folder");
                this.parentFolder = this.createMicroscopeFolder(target, microscopeName);
            }
        } else {
            IJLogger.info("Initialization", "Select folder " + target.getAbsolutePath());
            this.parentFolder = target.getAbsolutePath();
        }
        this.updateProcessedImageFile = !isOmeroRetriever;
    }

    private String createMicroscopeFolder(File target, String microscopeName) {
        String microscopeFolderPath = target.getAbsolutePath() + File.separator + microscopeName;
        if (new File(microscopeFolderPath).mkdir()) {
            IJLogger.info("Folder " + microscopeFolderPath + " has been successfully created");
            return microscopeFolderPath;
        }
        IJLogger.error("Cannot create folder " + microscopeFolderPath + ". Use this folder instead " + target.getAbsolutePath());
        return target.getAbsolutePath();
    }

    @Override
    public void initialize(ImageFile imageFile, Retriever retriever) {
        String dateFolderPath;
        if (retriever instanceof OMERORetriever) {
            OMERORetriever omeroRetriever = (OMERORetriever)retriever;
            this.imageWrapper = omeroRetriever.getImageWrapper(imageFile.getId());
            this.client = omeroRetriever.getClient();
        } else {
            this.imageWrapper = null;
            this.client = null;
            imageFile.removeAllTags();
            imageFile.addTags(imageFile.getTitle());
        }
        this.imageFolder = this.parentFolder + File.separator + imageFile.getImgNameWithoutExtension();
        File imageFileFolder = new File(this.imageFolder);
        if (!imageFileFolder.exists() && !imageFileFolder.mkdir()) {
            this.imageFolder = this.parentFolder;
            return;
        }
        if (this.cleanTarget) {
            this.clean();
        }
        if (new File(dateFolderPath = imageFileFolder.getAbsolutePath() + File.separator + this.date).mkdir()) {
            this.imageFolder = dateFolderPath;
        } else {
            IJLogger.error("Cannot create folder " + dateFolderPath + ". Use this folder instead " + this.imageFolder);
        }
    }

    @Override
    public void sendHeatMaps(ImagePlus imp) {
        IJLogger.info("Sending heatmap");
        FileSaver fs = new FileSaver(imp);
        File analysisImage_output_path = new File(this.imageFolder, imp.getTitle() + ".tif");
        boolean hasBeenSaved = fs.saveAsTiff(analysisImage_output_path.toString());
        if (hasBeenSaved) {
            IJLogger.info("Sending heatmap", imp.getTitle() + ".tif was saved in : " + this.imageFolder);
        } else {
            IJLogger.error("Sending heatmap", "Cannot save " + imp.getTitle() + " in " + this.imageFolder);
        }
    }

    @Override
    public void sendKeyValues(Map<String, String> keyValues) {
        IJLogger.info("Sending Key-values");
        if (!keyValues.isEmpty()) {
            String text = "key,value\n";
            for (Map.Entry<String, String> keyValue : keyValues.entrySet()) {
                text = text + keyValue.getKey() + "," + keyValue.getValue() + "\n";
            }
            File file = new File(this.imageFolder + File.separator + "Key_values.csv");
            Tools.saveCsvFile(file, text);
            IJLogger.info("Sending Key-values", "Key-values have been successfully saved in " + file.getAbsolutePath());
        } else {
            IJLogger.warn("Sending Key-Values", "There is no key-values to send !");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendGridPoints(List<Roi> rois, int channelId, String roiTitle) {
        IJLogger.info("Sending " + roiTitle + " ROIs");
        if (!rois.isEmpty()) {
            String path = this.imageFolder + File.separator + roiTitle + "_ch" + channelId + ".zip";
            FilterOutputStream out = null;
            try {
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
                out = new DataOutputStream(new BufferedOutputStream(zos));
                RoiEncoder re = new RoiEncoder((OutputStream)out);
                for (int i = 0; i < rois.size(); ++i) {
                    String label = roiTitle + ":" + i + ":child";
                    Roi roi = rois.get(i);
                    if (roi == null) continue;
                    if (!label.endsWith(".roi")) {
                        label = label + ".roi";
                    }
                    zos.putNextEntry(new ZipEntry(label));
                    re.write(roi);
                    ((DataOutputStream)out).flush();
                }
                out.close();
                IJLogger.info("Sending " + roiTitle + " ROIs", "The ROIs have been successfully saved in " + path);
            }
            catch (IOException e) {
                IJLogger.error("Sending " + roiTitle + " ROIs", "An error occurs during zip saving process", e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            IJLogger.warn("Sending " + roiTitle + " ROIs", "There is no annotations to save");
        }
    }

    @Override
    public void sendResultsTable(List<List<Double>> values, List<Integer> channelIdList, boolean createNewTable, String tableName) {
        IJLogger.info("Sending " + tableName + " table");
        String text = this.createNewTable(values, channelIdList);
        File file = new File(this.imageFolder + File.separator + tableName + "_" + "table" + ".csv");
        if (Tools.saveCsvFile(file, text)) {
            IJLogger.info("Sending " + tableName + " table", tableName + " table has been successfully saved in " + file.getAbsolutePath());
        }
    }

    @Override
    public void populateParentTable(Retriever retriever, Map<String, List<List<Double>>> summary, List<String> headers, boolean populateExistingTable) {
        IJLogger.info("Update parent table...");
        File lastTable = LocalSender.getLastLocalTable(this.parentFolder, "table");
        String text = "";
        if (!populateExistingTable || lastTable == null || !lastTable.exists()) {
            text = "Image ID,Label";
            for (String string : headers) {
                text = text + "," + string;
            }
            text = text + "\n";
        }
        ArrayList<String> IdList = new ArrayList<String>(summary.keySet());
        for (String Id : IdList) {
            String[] ids = Id.split("%");
            for (List<Double> metricsList : summary.get(Id)) {
                text = text + "" + ids[1] + "," + ids[0];
                for (Double metric : metricsList) {
                    text = text + "," + metric;
                }
                text = text + "\n";
            }
        }
        String string = new File(this.parentFolder).getName();
        File file = new File(this.parentFolder + File.separator + this.date + "_" + string + "_" + "table" + ".csv");
        if (!populateExistingTable || lastTable == null || !lastTable.exists()) {
            if (Tools.saveCsvFile(file, text)) {
                IJLogger.info("Update parent table", "New analysis summaries have been saved in " + file.getAbsolutePath());
            }
        } else if (Tools.appendCsvFile(lastTable, text)) {
            if (!lastTable.renameTo(file)) {
                IJLogger.warn("Cannot rename " + lastTable.getName() + " to " + file.getName());
            } else {
                IJLogger.info("Update parent table", "Existing table " + lastTable.getName() + " has been renamed to " + file.getName());
            }
        }
    }

    @Override
    public void sendPCCTable(List<List<Double>> pccValues, int nChannels) {
        IJLogger.info("Sending PCC table");
        ArrayList<Integer> chs1 = new ArrayList<Integer>();
        ArrayList<Integer> chs2 = new ArrayList<Integer>();
        for (int i = 0; i < nChannels - 1; ++i) {
            for (int j = i + 1; j < nChannels; ++j) {
                chs1.add(i);
                chs2.add(j);
            }
        }
        String text = "";
        for (int i = 0; i < chs1.size(); ++i) {
            text = text + "ch" + chs1.get(i) + "_ch" + chs2.get(i) + ",";
        }
        text = text + "\n";
        for (List<Double> channelPCCValue : pccValues) {
            for (Double ringPCCValue : channelPCCValue) {
                text = text + ringPCCValue + ",";
            }
            text = text + "\n";
        }
        File file = new File(this.imageFolder + File.separator + "PCC_table.csv");
        if (Tools.saveCsvFile(file, text)) {
            IJLogger.info("Sending PCC table", " PCC table has been successfully saved in " + file.getAbsolutePath());
        }
    }

    @Override
    public void sendTags(List<String> tags) {
        List imageTags;
        List groupTags;
        if (this.updateProcessedImageFile) {
            IJLogger.info("Update summary file of processed images");
            this.updateProcessedImageFile(tags);
            return;
        }
        if (this.imageWrapper == null || this.client == null) {
            return;
        }
        IJLogger.info("Adding tag");
        try {
            groupTags = this.client.getTags();
            imageTags = this.imageWrapper.getTags(this.client);
        }
        catch (AccessException | OMEROServerError | ServiceException | ExecutionException e) {
            IJLogger.error("Adding tag", "Cannot retrieve existing & linked tags from OMERO", (Exception)e);
            return;
        }
        for (String tag : tags) {
            try {
                List rawTag = groupTags.stream().filter(t -> t.getName().equals(tag)).collect(Collectors.toList());
                boolean isTagAlreadyExists = imageTags.stream().anyMatch(t -> t.getName().equals(tag));
                if (!isTagAlreadyExists) {
                    this.imageWrapper.link(this.client, (GenericAnnotationWrapper)(rawTag.isEmpty() ? new TagAnnotationWrapper(new TagAnnotationData(tag)) : (TagAnnotationWrapper)rawTag.get(0)));
                    IJLogger.info("Adding tag", "The tag " + tag + " has been successfully applied on the image " + this.imageWrapper.getId());
                    continue;
                }
                IJLogger.info("Adding tag", "The tag " + tag + " is already applied on the image " + this.imageWrapper.getId());
            }
            catch (AccessException | ServiceException | ExecutionException e) {
                IJLogger.error("Adding tag", "The tag " + tag + " could not be applied on the image " + this.imageWrapper.getId(), (Exception)e);
            }
        }
    }

    @Override
    public void clean() {
        IJLogger.info("Cleaning target...");
        File parent = new File(this.imageFolder);
        File[] children = parent.listFiles();
        IJLogger.info("Cleaning target", "Removing all documents located in  " + parent.getAbsolutePath());
        if (children != null) {
            for (File child : children) {
                if (child.isFile()) {
                    if (child.delete()) continue;
                    IJLogger.warn("Cleaning target", "Cannot delete file : " + child.getName());
                    continue;
                }
                try {
                    FileUtils.deleteDirectory((File)child);
                }
                catch (Exception e) {
                    IJLogger.warn("Cleaning target", "Cannot delete folder : " + child.getName());
                }
            }
        }
        IJLogger.info("Cleaning target", "Documents deleted");
        if (this.cleanParent) {
            IJLogger.info("Cleaning target", "Removing parent table from  " + this.parentFolder);
            this.cleanParent = false;
            File file = new File(this.parentFolder);
            String microscope = file.getName();
            children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (!child.isFile() || !child.getName().toLowerCase().contains(microscope.toLowerCase()) || !child.getName().endsWith("table.csv") && !child.getName().endsWith("processed_images.csv")) continue;
                    if (!child.delete()) {
                        IJLogger.warn("Cleaning target", "Cannot delete  " + child.getAbsolutePath());
                        continue;
                    }
                    IJLogger.info("Cleaning target", "Parent table " + child.getAbsolutePath() + " deleted");
                }
            }
        }
        if (this.imageWrapper != null && this.client != null) {
            try {
                IJLogger.info("Cleaning target", "Unlink tags from image " + this.imageWrapper.getId());
                List tags = this.imageWrapper.getTags(this.client);
                for (TagAnnotationWrapper tag : tags) {
                    this.imageWrapper.unlink(this.client, (GenericAnnotationWrapper)tag);
                }
                IJLogger.info("Cleaning target", "Tags unlinked");
            }
            catch (OMEROServerError | InterruptedException | ExecutionException | DSAccessException | DSOutOfServiceException e) {
                IJLogger.error("Cleaning target", "Cannot unlink tags for image " + this.imageWrapper.getId(), (Exception)e);
            }
        }
    }

    private void updateProcessedImageFile(List<String> filenames) {
        File lastTable = LocalSender.getLastLocalTable(this.parentFolder, "processed_images");
        String text = "";
        for (String name : filenames) {
            text = text + name + "\n";
        }
        File parentFolderFile = new File(this.parentFolder);
        File file = new File(this.parentFolder + File.separator + this.date + "_" + parentFolderFile.getName() + "_" + "processed_images" + ".csv");
        IJLogger.info("Search for file " + file.getName());
        if (lastTable == null || !lastTable.exists()) {
            if (Tools.saveCsvFile(file, text)) {
                IJLogger.info("Update processed images table", "New processed images have been saved in " + file.getName());
            }
        } else if (Tools.appendCsvFile(lastTable, text)) {
            if (!lastTable.renameTo(file)) {
                IJLogger.warn("Cannot rename " + lastTable.getName() + " to " + file.getName());
            } else {
                IJLogger.info("Update processed images table", "Existing table " + lastTable.getName() + " has been renamed to " + file.getName());
            }
        }
    }

    private String createNewTable(List<List<Double>> values, List<Integer> channelIdList) {
        String text = "Ring ID";
        for (Integer channelId : channelIdList) {
            text = text + ",ch_" + channelId;
        }
        text = text + "\n";
        if (values.size() > 0) {
            int i;
            int nRings = values.get(0).size();
            for (i = 0; i < values.size() - 1; ++i) {
                if (values.get(i).size() == values.get(i + 1).size()) continue;
                IJLogger.error("Cannot save table because the size of detected rings is not the same for each channel");
                return "";
            }
            for (i = 0; i < nRings; ++i) {
                text = text + "" + i;
                for (List<Double> doubles : values) {
                    text = text + "," + doubles.get(i);
                }
                text = text + "\n";
            }
        }
        return text;
    }

    private static File getLastLocalTable(String folderPath, String tableName) {
        File folder = new File(folderPath);
        File[] childFiles = folder.listFiles();
        String testedMicroscope = folder.getName();
        if (childFiles == null) {
            return null;
        }
        List<String> names = Arrays.stream(childFiles).filter(e -> e.isFile() && e.getName().contains(testedMicroscope) && e.getName().endsWith(tableName + ".csv")).map(File::getName).collect(Collectors.toList());
        if (names.isEmpty()) {
            return null;
        }
        ArrayList orderedDate = new ArrayList();
        names.forEach(name -> orderedDate.add(name.split("_")[0]));
        orderedDate.sort(Comparator.reverseOrder());
        if (orderedDate.isEmpty()) {
            return null;
        }
        String lastTable = (String)names.stream().filter(e -> e.contains((CharSequence)orderedDate.get(0))).collect(Collectors.toList()).get(0);
        return new File(folder + File.separator + lastTable);
    }
}

