/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.retrievers;

import ch.epfl.biop.retrievers.Retriever;
import ch.epfl.biop.utils.IJLogger;
import fr.igred.omero.Client;
import fr.igred.omero.exception.AccessException;
import fr.igred.omero.exception.ServiceException;
import fr.igred.omero.repository.DatasetWrapper;
import fr.igred.omero.repository.ImageWrapper;
import fr.igred.omero.repository.ProjectWrapper;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class OMERORetriever
implements Retriever {
    private final Client client;
    private final boolean isMicAtProjectLevel;
    private Map<String, ImageWrapper> images = new HashMap<String, ImageWrapper>();
    private long datasetId = -1L;
    private boolean processAllRawImages = false;

    public OMERORetriever(Client client, boolean isMicAtProjectLevel) {
        this.client = client;
        this.isMicAtProjectLevel = isMicAtProjectLevel;
    }

    public static List<String> listDatasets(Client client, String projectName) {
        List projectList = new ArrayList();
        try {
            projectList = client.getProjects(projectName);
        }
        catch (AccessException | ServiceException | ExecutionException e) {
            IJLogger.error("Project '" + projectName + "' cannot be found. Please check its name", (Exception)e);
        }
        if (projectList.size() > 0) {
            return ((ProjectWrapper)projectList.get(0)).getDatasets().stream().map(DatasetWrapper::getName).sorted().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<String> listProjects(Client client) {
        try {
            return client.getProjects(client.getUser()).stream().map(ProjectWrapper::getName).sorted().collect(Collectors.toList());
        }
        catch (AccessException | ServiceException | ExecutionException e) {
            IJLogger.error("Project cannot be listed from user '" + client.getUser().getUserName() + "' in group' " + client.getUser().getDefaultGroup().getName() + "'", (Exception)e);
            return Collections.emptyList();
        }
    }

    @Override
    public boolean loadImages(String parentTarget, String microscopeName, boolean processAllRawImages, String argoSlideName) {
        String projectName;
        String datasetName;
        this.processAllRawImages = processAllRawImages;
        if (this.isMicAtProjectLevel) {
            datasetName = parentTarget;
            projectName = microscopeName;
        } else {
            datasetName = microscopeName;
            projectName = parentTarget;
        }
        try {
            List projectlist = this.client.getProjects(projectName);
            if (projectlist.size() <= 0) {
                IJLogger.error("Load OMERO images", "The project '" + projectName + "' doesn't exist on OMERO. Please check its name.");
                return false;
            }
            ProjectWrapper projectWrapper = (ProjectWrapper)projectlist.get(0);
            List datasetWrapperList = projectWrapper.getDatasets().stream().filter(e -> e.getName().contains(datasetName)).collect(Collectors.toList());
            if (datasetWrapperList.size() == 1) {
                DatasetWrapper datasetWrapper = (DatasetWrapper)datasetWrapperList.get(0);
                IJLogger.info("Load OMERO images", "Images downloaded from dataset : " + datasetWrapper.getName());
                this.datasetId = datasetWrapper.getId();
                List imageWrapperList = datasetWrapper.getImages(this.client);
                this.images = this.filterImages(imageWrapperList, processAllRawImages, argoSlideName, microscopeName.replace("_", ""));
                return true;
            }
            if (datasetWrapperList.isEmpty()) {
                IJLogger.warn("Load OMERO images", "Project " + projectWrapper.getName() + " (" + projectWrapper.getId() + ") does not contain any dataset with name '" + datasetName + "'");
            } else {
                IJLogger.warn("Load OMERO images", "More than one dataset refer to " + datasetName + " Please, group these datasets or change their name.");
            }
            return false;
        }
        catch (Exception e2) {
            IJLogger.error("Load OMERO images", "Cannot retrieve images in project " + projectName + ", dataset '" + datasetName + "'", e2);
            return false;
        }
    }

    private Map<String, ImageWrapper> filterImages(List<ImageWrapper> imageWrapperList, boolean processAllRawImages, String argoSlideName, String microscopeName) {
        List<ImageWrapper> filteredWrappers = imageWrapperList.stream().filter(e -> {
            try {
                if (!processAllRawImages) {
                    return e.getTags(this.client).stream().noneMatch(t -> t.getName().equals("raw") || t.getName().equals("processed")) && !e.getName().contains("[macro image]") && e.getName().toLowerCase().contains(argoSlideName.toLowerCase()) && microscopeName.toLowerCase().contains(e.getName().split("_")[0].toLowerCase());
                }
                return e.getTags(this.client).stream().noneMatch(t -> t.getName().equals("processed")) && !e.getName().contains("[macro image]") && e.getName().toLowerCase().contains(argoSlideName.toLowerCase()) && microscopeName.toLowerCase().contains(e.getName().split("_")[0].toLowerCase());
            }
            catch (AccessException | ServiceException | ExecutionException ex) {
                throw new RuntimeException(ex);
            }
        }).collect(Collectors.toList());
        HashMap<String, ImageWrapper> imageWrapperMap = new HashMap<String, ImageWrapper>();
        filteredWrappers.forEach(e -> imageWrapperMap.put(String.valueOf(e.getId()), (ImageWrapper)e));
        return imageWrapperMap;
    }

    public ImageWrapper getImageWrapper(String key) {
        return this.images.get(key);
    }

    public Client getClient() {
        return this.client;
    }

    @Override
    public List<ImagePlus> getImage(String key) {
        try {
            ImageWrapper impWpr = this.images.get(key);
            if (impWpr == null) {
                return null;
            }
            return Collections.singletonList(impWpr.toImagePlus(this.client));
        }
        catch (AccessException | ServiceException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getNImages() {
        return this.images.size();
    }

    @Override
    public List<String> getIDs() {
        return new ArrayList<String>(this.images.keySet());
    }

    @Override
    public String getMicroscopeTarget() {
        return String.valueOf(this.datasetId);
    }

    @Override
    public boolean isProcessingAllRawImages() {
        return this.processAllRawImages;
    }
}

